/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.util;

import com.tridium.snmp.NullVarException;
import com.tridium.snmp.SnmpException;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpCounter;
import com.tridium.snmp.snmptypes.SnmpCounter64;
import com.tridium.snmp.snmptypes.SnmpGauge;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpIpAddress;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpTimeticks;
import com.tridium.snmp.snmptypes.SnmpUnsignedInt;
import com.tridium.snmp.snmptypes.SnmpVar;
import java.util.StringTokenizer;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

public class SnmpUtil
implements SnmpConst {
    public static final int INTEGER_TYPE = 0;
    public static final int STRING_TYPE = 1;
    public static final int COUNTER = 2;
    public static final int GAUGE = 3;
    public static final int TIMETICKS = 4;
    public static final int COUNTER_64 = 5;
    public static final int IP_ADDRESS = 6;
    public static final int OID = 7;

    public static long[] getLongArray(String s) {
        StringTokenizer st = new StringTokenizer(s, ".");
        int tokCnt = st.countTokens();
        long[] a = new long[tokCnt];
        for (int i = 0; i < tokCnt; ++i) {
            a[i] = Long.parseLong(st.nextToken(), 10);
        }
        return a;
    }

    public static String longArrayToString(long[] aVal) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aVal.length; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            sb.append(aVal[i]);
        }
        return sb.toString();
    }

    public static String byteArrayToString(byte[] aVal) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aVal.length; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            byte temp = aVal[i];
            int value = 0;
            boolean signBitSet = false;
            if ((temp & 0x80) != 0) {
                signBitSet = true;
                temp = (byte)(temp & 0x7F);
            }
            value |= temp;
            if (signBitSet) {
                value |= 0x80;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static String toString(String[] a) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String toString(byte[] a) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            if ((a[i] & 0xFF) < 16) {
                sb.append('0');
            }
            sb.append(Integer.toString(a[i] & 0xFF, 16));
        }
        return sb.toString();
    }

    public static String[] getStringArray(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        int tokCnt = st.countTokens();
        String[] b = new String[tokCnt];
        for (int i = 0; i < tokCnt; ++i) {
            b[i] = st.nextToken();
        }
        return b;
    }

    public static String ordToAbsolutePath(BOrd ord) {
        BIFile bif = (BIFile)ord.resolve().get();
        return BFileSystem.INSTANCE.pathToLocalFile(bif.getFilePath()).getAbsolutePath();
    }

    public static BOrd absolutePathToOrd(String path) {
        path = path.replace('\\', '/');
        return BOrd.make((String)("local:|file:/" + path));
    }

    public static BOrd absolutePathToDirOrd(String path) {
        if ((path = path.replace('\\', '/')).lastIndexOf(47) < 0) {
            return BFileSystem.INSTANCE.getOrdInHost();
        }
        path = path.substring(0, path.lastIndexOf(47));
        return BOrd.make((String)("local:|file:/" + path));
    }

    public static String rowIdFromOid(long[] aOid, int colNdx) {
        StringBuffer sb = new StringBuffer();
        for (int i = colNdx + 1; i < aOid.length; ++i) {
            if (i > colNdx + 1) {
                sb.append(".");
            }
            sb.append(aOid[i]);
        }
        return sb.toString();
    }

    public static Object[] getDecendantsByClass(BComponent c, Class cls) {
        Array a = new Array(cls);
        SnmpUtil.getDecendantsByClass(a, c, cls);
        return a.trim();
    }

    private static void getDecendantsByClass(Array a, BComponent c, Class cls) {
        SlotCursor sc = c.getProperties();
        while (sc.next()) {
            BValue o = sc.get();
            if (cls.isInstance(o)) {
                a.add((Object)o);
            }
            if (!(o instanceof BComponent)) continue;
            SnmpUtil.getDecendantsByClass(a, (BComponent)o, cls);
        }
    }

    public static BComponent getParent(BComponent child, Type parentType) {
        BComplex p = child.getParent();
        while (!p.getType().is(parentType)) {
            p = p.getParent();
        }
        return (BComponent)p;
    }

    public static int getIndex(String oid) {
        int ndx = oid.lastIndexOf(46);
        if (ndx < 0) {
            return -1;
        }
        return Integer.parseInt(oid.substring(ndx + 1));
    }

    public static String replaceIndex(String oid, int index) {
        return oid.substring(0, oid.lastIndexOf(46) + 1).concat(Integer.toString(index));
    }

    public static String replaceEnterprize(String oid, int ent) {
        long[] oida = SnmpUtil.getLongArray(oid);
        oida[6] = ent;
        return SnmpUtil.longArrayToString(oida);
    }

    public static int findFreeIndex(int[] ndxs, int cnt) {
        int free = 1;
        boolean found = true;
        block0: while (found) {
            found = false;
            for (int i = 0; i < cnt; ++i) {
                if (ndxs[i] != free) continue;
                found = true;
                ++free;
                continue block0;
            }
        }
        return free;
    }

    public static SnmpVar getSnmpVar(double f, BSnmpVariableTypeEnum typ) {
        switch (typ.getOrdinal()) {
            case 0: {
                return new SnmpInt((int)f);
            }
            case 1: {
                return new SnmpString(Double.toString(f));
            }
            case 3: {
                return new SnmpGauge((long)f);
            }
            case 4: {
                return new SnmpTimeticks((long)f);
            }
            case 2: {
                return new SnmpCounter((long)f);
            }
            case 5: {
                return new SnmpCounter64((long)f);
            }
        }
        return new SnmpNull();
    }

    public static SnmpVar getSnmpVar(boolean b, BSnmpVariableTypeEnum typ, BFacets f) {
        String trueText = f.gets("trueText", "true");
        String falseText = f.gets("falseText", "false");
        BEnumRange range = (BEnumRange)f.getFacet("range");
        int trueVal = 1;
        int falseVal = 0;
        if (range != null && range.isTag(trueText) && range.isTag(falseText)) {
            trueVal = range.tagToOrdinal(trueText);
            falseVal = range.tagToOrdinal(falseText);
        }
        int v = b ? trueVal : falseVal;
        switch (typ.getOrdinal()) {
            case 0: {
                return new SnmpInt(v);
            }
            case 1: {
                return new SnmpString(b ? trueText : falseText);
            }
            case 3: {
                return new SnmpGauge(v);
            }
            case 2: {
                return new SnmpCounter(v);
            }
            case 5: {
                return new SnmpCounter64(v);
            }
        }
        return new SnmpNull();
    }

    public static SnmpVar getSnmpVar(String s, BSnmpVariableTypeEnum typ) {
        try {
            switch (typ.getOrdinal()) {
                case 0: {
                    return new SnmpInt(Integer.parseInt(s));
                }
                case 1: {
                    return new SnmpString(s);
                }
                case 3: {
                    return new SnmpGauge(Integer.parseInt(s));
                }
                case 4: {
                    return new SnmpTimeticks(Integer.parseInt(s));
                }
                case 2: {
                    return new SnmpCounter(Integer.parseInt(s));
                }
                case 5: {
                    return new SnmpCounter64(Long.parseLong(s));
                }
                case 6: {
                    return new SnmpIpAddress(s);
                }
                case 7: {
                    return new SnmpOID(s);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SnmpNull();
    }

    public static SnmpVar getSnmpVar(BEnum en, BSnmpVariableTypeEnum typ) {
        try {
            int ord = en.getOrdinal();
            switch (typ.getOrdinal()) {
                case 0: {
                    return new SnmpInt(ord);
                }
                case 1: {
                    return new SnmpString(en.getTag());
                }
                case 3: {
                    return new SnmpGauge(ord);
                }
                case 4: {
                    return new SnmpTimeticks(ord);
                }
                case 2: {
                    return new SnmpCounter(ord);
                }
                case 5: {
                    return new SnmpCounter64(ord);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SnmpNull();
    }

    public static boolean getBoolean(SnmpVar var, BFacets f) {
        String trueText = f.gets("trueText", "true");
        String falseText = f.gets("falseText", "false");
        BEnumRange range = (BEnumRange)f.getFacet("range");
        int val = 0;
        switch (var.type) {
            case 2: {
                val = ((SnmpInt)var).intValue();
                break;
            }
            case 67: {
                val = (int)((SnmpTimeticks)var).longValue();
                break;
            }
            case 66: {
                val = (int)((SnmpGauge)var).longValue();
                break;
            }
            case 65: {
                val = (int)((SnmpCounter)var).longValue();
                break;
            }
            case 70: {
                val = (int)((SnmpCounter64)var).longValue();
                break;
            }
            case 4: {
                String sval = ((SnmpString)var).toStringValue();
                if (sval.equalsIgnoreCase(trueText)) {
                    return true;
                }
                if (sval.equalsIgnoreCase(falseText)) {
                    return false;
                }
                throw new SnmpException(SnmpPDU.translateErrorStatus(10));
            }
            case 5: {
                throw new NullVarException();
            }
            default: {
                throw new SnmpException(SnmpUtil.errorTypeToString(var.type));
            }
        }
        int trueVal = 1;
        int falseVal = 0;
        if (range != null && range.isTag(trueText) && range.isTag(falseText)) {
            trueVal = range.tagToOrdinal(trueText);
            falseVal = range.tagToOrdinal(falseText);
        }
        if (val == trueVal) {
            return true;
        }
        if (val == falseVal) {
            return false;
        }
        throw new SnmpException(SnmpPDU.translateErrorStatus(10));
    }

    public static double getNumeric(SnmpVar var) {
        switch (var.type) {
            case 2: {
                return ((SnmpInt)var).intValue();
            }
            case 67: {
                return ((SnmpTimeticks)var).longValue();
            }
            case 66: {
                return ((SnmpGauge)var).longValue();
            }
            case 65: 
            case 70: {
                return ((SnmpUnsignedInt)var).longValue();
            }
            case 4: {
                return Double.parseDouble(((SnmpString)var).toNumericStringValue());
            }
            case 5: {
                throw new NullVarException();
            }
        }
        throw new SnmpException(SnmpUtil.errorTypeToString(var.type));
    }

    public static BEnum getEnum(SnmpVar var, BEnumRange enumRange) {
        int ord;
        switch (var.type) {
            case 2: {
                ord = ((SnmpInt)var).intValue();
                break;
            }
            case 67: {
                ord = (int)((SnmpTimeticks)var).longValue();
                break;
            }
            case 66: {
                ord = (int)((SnmpGauge)var).longValue();
                break;
            }
            case 65: 
            case 70: {
                ord = (int)((SnmpUnsignedInt)var).longValue();
                break;
            }
            case 4: {
                return enumRange.get(((SnmpString)var).toStringValue());
            }
            case 5: {
                throw new NullVarException();
            }
            default: {
                throw new SnmpException(SnmpUtil.errorTypeToString(var.type));
            }
        }
        return enumRange.get(ord);
    }

    public static String getString(SnmpVar var) {
        switch (var.type) {
            case 2: 
            case 4: 
            case 6: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: {
                return var.toStringValue();
            }
            case 5: {
                throw new NullVarException();
            }
        }
        throw new SnmpException(SnmpUtil.errorTypeToString(var.type));
    }

    private static String errorTypeToString(int varType) {
        switch (varType) {
            case 128: {
                return SnmpPDU.translateErrorStatus(128);
            }
            case 129: {
                return SnmpPDU.translateErrorStatus(129);
            }
            case 130: {
                return SnmpPDU.translateErrorStatus(130);
            }
        }
        return "Attempted to read an unsupported SNMP variable type";
    }
}

