/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.snmptypes.ASNException;
import com.tridium.snmp.snmptypes.ASNInput;
import com.tridium.snmp.snmptypes.ASNOutput;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.util.SnmpUtil;
import java.net.InetAddress;
import java.util.Vector;
import javax.baja.sys.BAbsTime;

public class SnmpPDU
implements SnmpConst {
    private InetAddress destAddr = null;
    private InetAddress srcAddr = null;
    private int version = -1;
    private String community = null;
    private int pduType = 0;
    private int nonRepeaters = 0;
    private int maxRepetitions = 0;
    private int errIndex = 0;
    private int errStat = 0;
    private int remotePort = 0;
    private int reqId = 0;
    private long upTime = 0L;
    private int trapType = 0;
    private int specificType = 0;
    private SnmpOID enterprise;
    private Vector<SnmpVarBind> vars;
    private boolean full = false;
    private long[] trapEnterprise = null;
    private byte[] trapAgentAddr = null;
    private int trapGeneric = 0;
    private int trapSpecific = 0;
    private long trapTimeStamp = 0L;

    public SnmpPDU() {
        this.vars = new Vector();
    }

    public SnmpPDU(BSnmpDevice dev, int cmd) {
        this.setVersion(dev.getVersion());
        this.setReqid(dev.snmpNet().getNextReqid());
        this.setCommand(cmd);
        this.setRemotePort(dev.getPort());
        this.setDestinationIp(dev.getInetAddress());
        this.setCommunity(dev.getCommunity());
        this.vars = new Vector();
    }

    public SnmpPDU(byte[] aData) {
        this.decodeData(aData);
    }

    public void setFull(boolean full) {
        this.full = full;
    }

    public boolean isFull() {
        return this.full;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setCommand(int command) {
        this.pduType = command;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public void setReqid(int reqId) {
        this.reqId = reqId;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setErrindex(int errIndex) {
        this.errIndex = errIndex;
    }

    public void setErrstat(int errStat) {
        this.errStat = errStat;
    }

    public void setNonRepeaters(int nonRepeaters) {
        this.nonRepeaters = nonRepeaters;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public void setTrapType(int trapType) {
        this.trapType = trapType;
    }

    public void setSpecificType(int specificType) {
        this.specificType = specificType;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public void setEnterprise(SnmpOID enterprise) {
        this.enterprise = enterprise;
    }

    public void setDestinationIp(InetAddress destAddr) {
        this.destAddr = destAddr;
    }

    public void setSourceIp(InetAddress srcAddr) {
        this.srcAddr = srcAddr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getCommand() {
        return this.pduType;
    }

    public int getVersion() {
        return this.version;
    }

    public int getReqid() {
        return this.reqId;
    }

    public int getErrstat() {
        return this.errStat;
    }

    public int getNonRepeaters() {
        return this.nonRepeaters;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public int getErrindex() {
        return this.errIndex;
    }

    public InetAddress getSourceIp() {
        return this.srcAddr;
    }

    public InetAddress getDestinationIp() {
        return this.destAddr;
    }

    public String getCommunity() {
        return this.community != null ? this.community : "public";
    }

    public byte[] getData() {
        return this.encodeData();
    }

    public Vector<SnmpVarBind> getVariableBindings() {
        return this.vars;
    }

    public void setVariableBindings(Vector<SnmpVarBind> v) {
        this.vars = v;
    }

    public void clearVariableBindings() {
        this.vars.clear();
    }

    public void addVariableBinding(SnmpVarBind varBind) {
        this.vars.addElement(varBind);
    }

    public String getTrapEnterprise() {
        if (this.trapEnterprise == null) {
            return "null";
        }
        return SnmpUtil.longArrayToString(this.trapEnterprise);
    }

    public String getAgentAddr() {
        if (this.trapAgentAddr == null) {
            return "null";
        }
        return SnmpUtil.byteArrayToString(this.trapAgentAddr);
    }

    public String getGenericTrap() {
        return Integer.toString(this.trapGeneric);
    }

    public String getSpecificTrap() {
        return Integer.toString(this.trapSpecific);
    }

    public int getGenericTrapAsInt() {
        return this.trapGeneric;
    }

    public int getSpecificTrapAsInt() {
        return this.trapSpecific;
    }

    public String getTrapTimeStamp() {
        return Long.toString(this.trapTimeStamp) + "(" + BAbsTime.make((long)(this.trapTimeStamp * 10L)) + ")";
    }

    private void decodeData(byte[] aData) {
        try {
            ASNInput in = new ASNInput(aData);
            in.getSequenceLength();
            this.version = in.getInt();
            this.community = in.getString();
            this.pduType = in.getCommand();
            in.readLength();
            if (this.pduType == 164) {
                this.trapEnterprise = in.getObjectID();
                this.trapAgentAddr = in.getIpAddress();
                this.trapGeneric = in.getInt();
                this.trapSpecific = in.getInt();
                this.trapTimeStamp = in.getTimetick();
            } else {
                this.reqId = in.getInt();
                if (this.pduType == 165) {
                    this.nonRepeaters = in.getInt();
                    if (this.nonRepeaters < 0) {
                        this.nonRepeaters = 0;
                    }
                    this.maxRepetitions = in.getInt();
                } else {
                    this.errStat = in.getInt();
                    this.errIndex = in.getInt();
                }
            }
            int varLen = in.getSequenceLength();
            int maxPos = varLen + in.getPosition();
            this.vars = new Vector();
            while (maxPos > in.getPosition()) {
                in.getSequenceLength();
                this.vars.addElement(new SnmpVarBind(in));
            }
        }
        catch (ASNException e) {
            System.out.println(" error in SnmpPDU.decodeData: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    private byte[] encodeData() {
        ASNOutput out = new ASNOutput();
        out.addInt(this.version);
        out.addString(this.community);
        int pduPos = out.getPosition();
        if (this.pduType == 164) {
            out.addObjectId(this.enterprise.toValue());
            out.addIpAddress(this.srcAddr.getAddress());
            out.addInt(this.trapType);
            out.addInt(this.specificType);
            out.addTimeticks(this.upTime);
        } else {
            out.addInt(this.reqId);
            if (this.pduType == 165) {
                out.addInt(this.nonRepeaters);
                out.addInt(this.maxRepetitions);
            } else {
                out.addInt(this.errStat);
                out.addInt(this.errIndex);
            }
        }
        try {
            int varBindListPos = out.getPosition();
            Object[] a = new SnmpVarBind[this.vars.size()];
            this.vars.copyInto(a);
            for (int i = 0; i < a.length; ++i) {
                int varBindPos = out.getPosition();
                if (a[i] == null) {
                    System.out.println("a[i]==null");
                    continue;
                }
                if (((SnmpVarBind)a[i]).getObjectID() == null) {
                    System.out.println("a[i].getObjectID()==null");
                    continue;
                }
                if (((SnmpVarBind)a[i]).getVariable() == null) {
                    System.out.println("a[i].getVariable()==null");
                    continue;
                }
                out.addObjectId(((SnmpVarBind)a[i]).getObjectID().toValue());
                ((SnmpVarBind)a[i]).getVariable().encode(out);
                out.insertTag(48, varBindPos);
            }
            out.insertTag(48, varBindListPos);
        }
        catch (Throwable e) {
            System.out.println(this.toString());
            e.printStackTrace();
        }
        out.insertTag(this.pduType, pduPos);
        out.insertTag(48, 0);
        return out.getBytes();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("version: ").append(this.version + 1);
        sb.append("\ncommunity: ").append(this.community);
        sb.append("\npdu type: ").append(SnmpPDU.translatePduType(this.pduType));
        if (this.pduType == 164) {
            sb.append("\nenterprise: ").append(this.enterprise);
            sb.append("\nsrcAddr: ").append(this.srcAddr);
            sb.append("\ntrapType: ").append(this.trapType);
            sb.append("\nspecificType: ").append(this.specificType);
            sb.append("\nupTime: ").append(this.upTime);
        } else {
            sb.append("\nreqId: ").append(this.reqId);
            if (this.pduType == 165) {
                sb.append("\nnonRepeaters: ").append(this.nonRepeaters);
                sb.append("\nmaxRepetitions: ").append(this.maxRepetitions);
            } else if (this.errStat != 0) {
                sb.append("\nerrStat: ").append(SnmpPDU.translateErrorStatus(this.errStat));
                sb.append("\nerrIndex: ").append(this.errIndex);
            }
        }
        sb.append("\nvariables:\n");
        this.scanVarBinds(sb);
        return sb.toString();
    }

    public String printVarBinds() {
        StringBuffer sb = new StringBuffer();
        this.scanVarBinds(sb);
        return sb.toString();
    }

    public SnmpVarBind[] getVaribleBindingArray() {
        Object[] vbs = new SnmpVarBind[this.vars.size()];
        this.vars.copyInto(vbs);
        return vbs;
    }

    private void scanVarBinds(StringBuffer sb) {
        if (this.vars != null) {
            for (int i = 0; i < this.vars.size(); ++i) {
                if (this.vars.elementAt(i) == null) continue;
                sb.append(this.vars.elementAt(i)).append("\n");
            }
        }
    }

    public static String translatePduType(int typ) {
        switch (typ) {
            case 160: {
                return "GET_REQUEST";
            }
            case 161: {
                return "GET_NEXT_REQUEST";
            }
            case 162: {
                return "GET_RESPONSE";
            }
            case 163: {
                return "SET_REQUEST";
            }
            case 164: {
                return "TRAP_V1";
            }
            case 165: {
                return "GET_BULK_REQUEST";
            }
            case 166: {
                return "INFORM_REQUEST";
            }
            case 167: {
                return "TRAP_V2";
            }
            case 168: {
                return "REPORT";
            }
        }
        return "Unknown 0x" + Integer.toString(typ & 0xFF, 16);
    }

    public static String translateErrorStatus(int errStat) {
        switch (errStat) {
            case 0: {
                return "no error";
            }
            case 1: {
                return "too big";
            }
            case 2: {
                return "no such name";
            }
            case 3: {
                return "bad value";
            }
            case 4: {
                return "readonly";
            }
            case 5: {
                return "general error";
            }
            case 6: {
                return "no access";
            }
            case 7: {
                return "wrong type";
            }
            case 8: {
                return "wrong length";
            }
            case 9: {
                return "wrong encoding";
            }
            case 10: {
                return "wrong value";
            }
            case 11: {
                return "no creation";
            }
            case 12: {
                return "inconsistent value";
            }
            case 13: {
                return "resource unavailable";
            }
            case 14: {
                return "commit failed";
            }
            case 15: {
                return "undo failed";
            }
            case 16: {
                return "authorization error";
            }
            case 17: {
                return "not writable";
            }
            case 18: {
                return "inconsistent name";
            }
            case 128: {
                return "no such object";
            }
            case 129: {
                return "no such instance";
            }
            case 130: {
                return "end of mib view";
            }
        }
        return "unknown";
    }
}

