/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.alarm.AlarmUtil;
import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.datatypes.BNetworkManagerConfiguration;
import com.tridium.snmp.mib.table.AlarmEntry;
import com.tridium.snmp.snmptypes.AlarmTrap;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BSnmpRecipient
extends BAlarmRecipient {
    public static Lexicon lex = Lexicon.make((String)"snmp");
    public static final Property networkManagerConfig = BSnmpRecipient.newProperty((int)0, (BValue)new BNetworkManagerConfiguration(), null);
    public static final Property snmpAlarmTable = BSnmpRecipient.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)lex.getText("recipient.strings.storeAlarms"), (String)lex.getText("recipient.strings.discardAlarms")));
    public static final Type TYPE = Sys.loadType(BSnmpRecipient.class);

    public BNetworkManagerConfiguration getNetworkManagerConfig() {
        return (BNetworkManagerConfiguration)this.get(networkManagerConfig);
    }

    public void setNetworkManagerConfig(BNetworkManagerConfiguration v) {
        this.set(networkManagerConfig, (BValue)v, null);
    }

    public boolean getSnmpAlarmTable() {
        return this.getBoolean(snmpAlarmTable);
    }

    public void setSnmpAlarmTable(boolean v) {
        this.setBoolean(snmpAlarmTable, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.initAlarmTable();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop == snmpAlarmTable) {
            this.initAlarmTable();
        }
    }

    private void initAlarmTable() {
        if (!this.getSnmpAlarmTable()) {
            return;
        }
        String query = AlarmUtil.make((BAlarmService)((BAlarmService)Sys.getService((Type)BAlarmService.TYPE))).getInitialAlarmQuery((BAlarmRecipient)this);
        BOrd ord = BOrd.make((String)query);
        BITable result = (BITable)ord.resolve().get();
        TableCursor cur = result.cursor();
        while (cur.next()) {
            BAlarmRecord alarm = (BAlarmRecord)cur.get();
            if (!this.accept(alarm)) continue;
            this.snmp().alarms().addAlarmEntry((BAlarmRecord)alarm.newCopy());
        }
    }

    public void handleAlarm(BAlarmRecord alarmRecord) {
        try {
            if (!alarmRecord.isAcknowledged()) {
                AlarmEntry entry = this.getSnmpAlarmTable() ? this.snmp().alarms().addAlarmEntry(alarmRecord) : new AlarmEntry(alarmRecord, 0);
                if (this.snmp().isCommActive() && this.getNetworkManagerConfig().getRouteAlarmsToNetworkManager()) {
                    if (this.getNetworkManagerConfig().getUseDefaultNetworkManager()) {
                        AlarmTrap.sendAlarmTrap(this.snmp(), entry);
                    } else {
                        AlarmTrap.sendAlarmTrap(this, entry);
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.snmp() == null) {
                System.out.println("Exception generated in SnmpRecipient.  Could not find SnmpNetwork.  " + e);
            }
            this.snmp().log().severe("Exception generated in SnmpRecipient. " + e.toString());
        }
    }

    public BSnmpNetwork snmp() {
        return (BSnmpNetwork)Sys.getService((Type)BSnmpNetwork.TYPE);
    }
}

