/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.mib.OidElement;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;

public class OidEntry
extends OidElement {
    private String displayHint;
    String oid;
    MibObject mibObj;
    BSnmpAccessEnum access;
    String name;
    String status;
    String desc;
    String objSyntax;
    BSnmpVariableTypeEnum varType;
    BSnmpMipEntryTypeEnum elementType;
    public BEnumRange enumRange = null;
    public Range range = null;
    public Range size = null;

    public OidEntry(String oid, int type, String name, String status, String desc, MibObject mibObj, long ndx, BSnmpAccessEnum access) {
        super(ndx);
        this.oid = oid;
        this.entryType = type;
        this.access = access;
        this.name = name;
        this.status = status;
        this.desc = desc;
        this.mibObj = mibObj;
    }

    public OidEntry(String oid, int type, String name, String status, String desc, MibObject mibObj, long ndx, BSnmpAccessEnum access, String objSyntax, BSnmpMipEntryTypeEnum elementType, BSnmpVariableTypeEnum varType) {
        this(oid, type, name, status, desc, mibObj, ndx, access);
        this.objSyntax = objSyntax;
        this.elementType = elementType;
        this.varType = varType;
    }

    public OidEntry(String oid, int type, String name, String status, String desc, MibObject mibObj, long ndx, BSnmpAccessEnum access, String objSyntax, BSnmpMipEntryTypeEnum elementType, BSnmpVariableTypeEnum varType, String displayHint) {
        this(oid, type, name, status, desc, mibObj, ndx, access);
        this.objSyntax = objSyntax;
        this.elementType = elementType;
        this.varType = varType;
        this.displayHint = displayHint;
    }

    @Override
    public String toString() {
        return super.toString() + "  oid = " + this.oid;
    }

    @Override
    public boolean isOidEntry() {
        return true;
    }

    public BSnmpMipEntryTypeEnum getElementType() {
        return this.elementType;
    }

    public String getOid() {
        return this.oid;
    }

    public BSnmpAccessEnum getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getObjSyntax() {
        return this.objSyntax;
    }

    public MibObject getMibObject() {
        return this.mibObj;
    }

    public BSnmpVariableTypeEnum getVariableType() {
        return this.varType;
    }

    public String getDisplayHint() {
        return this.displayHint;
    }

    public BFacets getRangeFacets() {
        if (this.range == null) {
            return BFacets.DEFAULT;
        }
        return BFacets.makeNumeric(null, (int)1, (double)this.range.min, (double)this.range.max);
    }

    public static class Range {
        public double min;
        public double max;
    }
}

