/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.datatypes;

import com.tridium.snmp.datatypes.BMibListEntry;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMibListTable
extends BComponent {
    public static final Action clear = BMibListTable.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType(BMibListTable.class);

    public void clear() {
        this.invoke(clear, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMibListTable() {
    }

    public BMibListTable(BMibListEntry[] list) {
        this.setPointList(list);
    }

    public synchronized BMibListEntry[] getPointList() {
        BMibListEntry[] temp = new BMibListEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BMibListEntry.class)) {
            temp[count] = (BMibListEntry)c.get();
            ++count;
        }
        BMibListEntry[] result = new BMibListEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public synchronized BMibListEntry[] getPointListCopy() {
        BMibListEntry[] temp = new BMibListEntry[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BMibListEntry.class)) {
            BComponent kid = (BComponent)c.get();
            temp[count] = (BMibListEntry)kid.newCopy();
            ++count;
        }
        BMibListEntry[] result = new BMibListEntry[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public void addEntry(BMibListEntry entry) {
        String name = this.makeValidName(entry.getEntryName());
        try {
            this.add(name, (BValue)entry);
        }
        catch (DuplicateSlotException e) {
            this.add(null, (BValue)entry);
        }
    }

    private String makeValidName(String name) {
        if (!SlotPath.isValidName((String)name)) {
            name = SlotPath.escape((String)name);
        }
        int count = 2;
        boolean firstRename = true;
        while (this.getSlot(name) != null) {
            if (firstRename) {
                name = name + "_" + count;
                firstRename = false;
            } else {
                name = name.substring(0, name.lastIndexOf(95)) + "_" + count;
            }
            ++count;
        }
        return name;
    }

    public void clearEntries() {
        this.removeAll(null);
    }

    public void setPointList(BMibListEntry[] pointList) {
        this.clearEntries();
        if (pointList != null) {
            for (int i = 0; i < pointList.length; ++i) {
                this.addEntry(pointList[i]);
            }
        }
    }

    public void doClear() {
        this.clearEntries();
    }
}

