/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.alarm;

import com.tridium.snmp.datatypes.BStringArray;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTrapType
extends BComponent {
    public static final Property trapName = BTrapType.newProperty((int)0, (String)"", null);
    public static final Property description = BTrapType.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property reference = BTrapType.newProperty((int)0, (String)"", null);
    public static final Property variablesArray = BTrapType.newProperty((int)0, (BValue)new BStringArray(), null);
    public static final Property trapOid = BTrapType.newProperty((int)0, (String)"", null);
    public static final Property genericType = BTrapType.newProperty((int)0, (int)-1, null);
    public static final Property specificType = BTrapType.newProperty((int)0, (int)-1, null);
    public static final Type TYPE = Sys.loadType(BTrapType.class);

    public String getTrapName() {
        return this.getString(trapName);
    }

    public void setTrapName(String v) {
        this.setString(trapName, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public String getReference() {
        return this.getString(reference);
    }

    public void setReference(String v) {
        this.setString(reference, v, null);
    }

    public BStringArray getVariablesArray() {
        return (BStringArray)this.get(variablesArray);
    }

    public void setVariablesArray(BStringArray v) {
        this.set(variablesArray, (BValue)v, null);
    }

    public String getTrapOid() {
        return this.getString(trapOid);
    }

    public void setTrapOid(String v) {
        this.setString(trapOid, v, null);
    }

    public int getGenericType() {
        return this.getInt(genericType);
    }

    public void setGenericType(int v) {
        this.setInt(genericType, v, null);
    }

    public int getSpecificType() {
        return this.getInt(specificType);
    }

    public void setSpecificType(int v) {
        this.setInt(specificType, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTrapType() {
        this("", "", "", new String[0], new long[0]);
    }

    public BTrapType(String trapName, String description, String reference, String[] variables, long[] oid, int genericType, int specificType) {
        this.setTrapName(trapName);
        this.setDescription(description);
        this.setReference(reference);
        if (variables == null) {
            variables = new String[]{};
        }
        this.getVariablesArray().setArray(variables);
        if (oid == null) {
            oid = new long[]{};
        }
        this.setTrapOid(SnmpUtil.longArrayToString(oid));
        this.setGenericType(genericType);
        this.setSpecificType(specificType);
    }

    public BTrapType(String trapName, String description, String reference, String[] variables, long[] oid) {
        this.setTrapName(trapName);
        this.setDescription(description);
        this.setReference(reference);
        if (variables == null) {
            variables = new String[]{};
        }
        this.getVariablesArray().setArray(variables);
        if (oid == null) {
            oid = new long[]{};
        }
        this.setTrapOid(SnmpUtil.longArrayToString(oid));
    }

    public BTrapType(BTrapType entry) {
        this.copyFrom((BComplex)entry);
    }

    public String[] getVariables() {
        this.getVariablesArray().lease();
        return this.getVariablesArray().getArray();
    }

    public long[] getOid() {
        long[] retVal = null;
        try {
            retVal = SnmpUtil.getLongArray(this.getTrapOid());
        }
        catch (Exception e) {
            retVal = null;
        }
        return retVal;
    }

    public void setOid(long[] oidArray) {
        if (oidArray == null) {
            oidArray = new long[]{};
        }
        this.setTrapOid(SnmpUtil.longArrayToString(oidArray));
    }

    public String toString(Context context) {
        String[] variables;
        StringBuffer sbuf = new StringBuffer();
        if (this.getGenericType() == -1 && this.getSpecificType() == -1) {
            sbuf.append("NOTIFICATION NAME: " + this.getTrapName() + "; ");
        } else {
            sbuf.append("TRAP NAME: " + this.getTrapName() + "; ");
        }
        sbuf.append("OID: " + this.getTrapOid() + "; ");
        if (this.getGenericType() != -1 || this.getSpecificType() != -1) {
            sbuf.append("GENERIC TYPE: " + this.getGenericType() + "; ");
            sbuf.append("SPECIFIC TYPE: " + this.getSpecificType() + "; ");
        }
        if ((variables = this.getVariables()).length > 0) {
            if (this.getGenericType() == -1 && this.getSpecificType() == -1) {
                sbuf.append("OBJECTS: ");
            } else {
                sbuf.append("VARIABLES: ");
            }
            for (int i = 0; i < variables.length; ++i) {
                if (i > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(variables[i]);
            }
            sbuf.append("; ");
        }
        sbuf.append("DESCRIPTION: " + this.getDescription() + "; ");
        sbuf.append("REFERENCE: " + this.getReference() + ".");
        return sbuf.toString();
    }

    public String toDebugString() {
        return this.toString(null);
    }

    public boolean compareTraps(BTrapType comp) {
        String[] compares;
        if (!this.getTrapName().equals(comp.getTrapName())) {
            return false;
        }
        if (!this.getDescription().equals(comp.getDescription())) {
            return false;
        }
        if (!this.getReference().equals(comp.getReference())) {
            return false;
        }
        if (this.getGenericType() != comp.getGenericType()) {
            return false;
        }
        if (this.getSpecificType() != comp.getSpecificType()) {
            return false;
        }
        if (!this.getTrapOid().equals(comp.getTrapOid())) {
            return false;
        }
        String[] locals = this.getVariables();
        if (locals.length != (compares = comp.getVariables()).length) {
            return false;
        }
        for (int i = 0; i < locals.length; ++i) {
            if (locals[i].equals(compares[i])) continue;
            return false;
        }
        return true;
    }
}

