/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.alarm;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.alarm.BTrapType;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.util.SnmpUtil;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BSnmpAlarmDeviceExt
extends BAlarmDeviceExt {
    private static long[] coldStartOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 1L};
    private static long[] warmStartOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 2L};
    private static long[] linkDownOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 3L};
    private static long[] linkUpOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 4L};
    private static long[] authenticationFailureOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 5L};
    private static long[] egpNeighborLossOid = new long[]{1L, 3L, 6L, 1L, 6L, 3L, 1L, 1L, 5L, 6L};
    private static Lexicon lex = Lexicon.make((String)"snmp");
    public static final Property lastReceivedTrap = BSnmpAlarmDeviceExt.newProperty((int)267, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property ignoreUnrecognizedTraps = BSnmpAlarmDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property coldStart = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.coldStart"), "", "null", new String[0], coldStartOid, 0, 0), null);
    public static final Property warmStart = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.warmStart"), "", "null", new String[0], warmStartOid, 1, 0), null);
    public static final Property linkDown = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.linkDown"), "", "null", new String[0], linkDownOid, 2, 0), null);
    public static final Property linkUp = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.linkUp"), "", "null", new String[0], linkUpOid, 3, 0), null);
    public static final Property authenticationFailure = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.authenticationFailure"), "", "null", new String[0], authenticationFailureOid, 4, 0), null);
    public static final Property egpNeighborLoss = BSnmpAlarmDeviceExt.newProperty((int)0, (BValue)new BTrapType(lex.getText("traps.strings.egpNeighborLoss"), "", "null", new String[0], egpNeighborLossOid, 5, 0), null);
    public static final Action clear = BSnmpAlarmDeviceExt.newAction((int)128, null);
    public static final Topic receivedTrap = BSnmpAlarmDeviceExt.newTopic((int)8, null);
    public static final Type TYPE = Sys.loadType(BSnmpAlarmDeviceExt.class);
    private AlarmSupport alarmSupport = new AlarmSupport((BIAlarmSource)this, "");
    private static BTrapType[] genericTrapList = new BTrapType[]{new BTrapType(lex.getText("traps.strings.coldStart"), "", "null", new String[0], coldStartOid, 0, 0), new BTrapType(lex.getText("traps.strings.warmStart"), "", "null", new String[0], warmStartOid, 1, 0), new BTrapType(lex.getText("traps.strings.linkDown"), "", "null", new String[0], linkDownOid, 2, 0), new BTrapType(lex.getText("traps.strings.linkUp"), "", "null", new String[0], linkUpOid, 3, 0), new BTrapType(lex.getText("traps.strings.authenticationFailure"), "", "null", new String[0], authenticationFailureOid, 4, 0), new BTrapType(lex.getText("traps.strings.egpNeighborLoss"), "", "null", new String[0], egpNeighborLossOid, 5, 0)};

    public String getLastReceivedTrap() {
        return this.getString(lastReceivedTrap);
    }

    public void setLastReceivedTrap(String v) {
        this.setString(lastReceivedTrap, v, null);
    }

    public boolean getIgnoreUnrecognizedTraps() {
        return this.getBoolean(ignoreUnrecognizedTraps);
    }

    public void setIgnoreUnrecognizedTraps(boolean v) {
        this.setBoolean(ignoreUnrecognizedTraps, v, null);
    }

    public BTrapType getColdStart() {
        return (BTrapType)this.get(coldStart);
    }

    public void setColdStart(BTrapType v) {
        this.set(coldStart, (BValue)v, null);
    }

    public BTrapType getWarmStart() {
        return (BTrapType)this.get(warmStart);
    }

    public void setWarmStart(BTrapType v) {
        this.set(warmStart, (BValue)v, null);
    }

    public BTrapType getLinkDown() {
        return (BTrapType)this.get(linkDown);
    }

    public void setLinkDown(BTrapType v) {
        this.set(linkDown, (BValue)v, null);
    }

    public BTrapType getLinkUp() {
        return (BTrapType)this.get(linkUp);
    }

    public void setLinkUp(BTrapType v) {
        this.set(linkUp, (BValue)v, null);
    }

    public BTrapType getAuthenticationFailure() {
        return (BTrapType)this.get(authenticationFailure);
    }

    public void setAuthenticationFailure(BTrapType v) {
        this.set(authenticationFailure, (BValue)v, null);
    }

    public BTrapType getEgpNeighborLoss() {
        return (BTrapType)this.get(egpNeighborLoss);
    }

    public void setEgpNeighborLoss(BTrapType v) {
        this.set(egpNeighborLoss, (BValue)v, null);
    }

    public void clear() {
        this.invoke(clear, null, null);
    }

    public void fireReceivedTrap(BAlarmRecord event) {
        this.fire(receivedTrap, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doRouteAlarm(BAlarmRecord record) throws Exception {
        System.out.println("To doRouteAlarm");
    }

    public BBoolean doAckAlarm(BAlarmRecord record) throws Exception {
        try {
            BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            record.setAckTime(Clock.time());
            record.setAckState(BAckState.acked);
            record.setAckRequired(false);
            as.routeAlarm(record);
        }
        catch (Exception e) {
            if (this.getNetwork() != null) {
                ((BSnmpNetwork)this.getNetwork()).log().severe("Could not route acknowledgement to alarm class:  " + e.toString());
            }
            return BBoolean.make((boolean)false);
        }
        return BBoolean.make((boolean)true);
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BTrapType;
    }

    public void issueTrapAlert(BFacets alarmData, String trapMessage) {
        BAlarmRecord alert;
        block3: {
            this.alarmSupport.setAlarmClass(this.getAlarmClass());
            alert = null;
            try {
                alert = this.alarmSupport.newAlert(alarmData);
            }
            catch (Exception e) {
                if (this.getNetwork() == null) break block3;
                ((BSnmpNetwork)this.getNetwork()).log().severe("Could not generate SNMP trap alert for " + this.getDevice().getName() + " " + e.toString());
            }
        }
        if (alert != null) {
            this.setLastReceivedTime(BAbsTime.make());
            this.setLastReceivedTrap(trapMessage);
            this.fireReceivedTrap(alert);
        }
    }

    public synchronized BTrapType[] getTrapList() {
        BTrapType[] temp = new BTrapType[this.getSlotCount()];
        int count = 0;
        SlotCursor c = this.getProperties();
        while (c.next(BTrapType.class)) {
            BValue kid = c.get();
            temp[count] = (BTrapType)kid;
            ++count;
        }
        BTrapType[] result = new BTrapType[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public void addEntry(BTrapType entry) {
        String name = entry.getTrapName();
        if (!SlotPath.isValidName((String)name)) {
            name = SlotPath.escape((String)name);
        }
        int count = 2;
        boolean firstRename = true;
        while (this.getSlot(name) != null) {
            if (firstRename) {
                name = name + "_" + count;
                firstRename = false;
            } else {
                name = name.substring(0, name.lastIndexOf(95)) + "_" + count;
            }
            ++count;
        }
        this.add(name, (BValue)entry);
    }

    public void clearEntries() {
        this.removeAll(null);
    }

    public void doClear() {
        this.clearEntries();
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
    }

    public void setTrapList(BTrapType[] trapList) {
        this.clearEntries();
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            space.update((BComponent)this, 0);
        }
        if (trapList != null) {
            for (int i = 0; i < trapList.length; ++i) {
                this.addEntry(trapList[i]);
            }
        }
        if (space != null) {
            space.update((BComponent)this, 0);
        }
    }

    public void addTrapsToList(BTrapType[] list) {
        int i;
        BTrapType[] trapList = this.getTrapList();
        int found = 0;
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (!BSnmpAlarmDeviceExt.listContainsTrap(trapList, list[i2])) continue;
            ++found;
        }
        BTrapType[] addList = new BTrapType[list.length - found];
        int count = 0;
        for (int i3 = 0; i3 < list.length; ++i3) {
            if (BSnmpAlarmDeviceExt.listContainsTrap(trapList, list[i3])) continue;
            addList[count] = (BTrapType)list[i3].newCopy();
            ++count;
        }
        BTrapType[] newList = new BTrapType[trapList.length + addList.length];
        for (i = 0; i < trapList.length; ++i) {
            newList[i] = (BTrapType)trapList[i].newCopy();
        }
        for (i = trapList.length; i < trapList.length + addList.length; ++i) {
            newList[i] = (BTrapType)addList[i - trapList.length].newCopy();
        }
        this.setTrapList(newList);
    }

    public void removeTrapsFromList(BTrapType[] removeList) {
        BTrapType[] trapList = this.getTrapList();
        int found = 0;
        for (int i = 0; i < removeList.length; ++i) {
            if (!BSnmpAlarmDeviceExt.listContainsTrap(trapList, removeList[i])) continue;
            ++found;
            for (int j = i + 1; j < removeList.length; ++j) {
                if (!removeList[i].compareTraps(removeList[j])) continue;
                --found;
            }
        }
        BTrapType[] newList = new BTrapType[trapList.length - found];
        int count = 0;
        for (int i = 0; i < trapList.length; ++i) {
            if (BSnmpAlarmDeviceExt.listContainsTrap(removeList, trapList[i])) continue;
            newList[count] = (BTrapType)trapList[i].newCopy();
            ++count;
        }
        this.setTrapList(newList);
    }

    private static boolean listContainsTrap(BTrapType[] list, BTrapType trap) {
        for (int j = 0; j < list.length; ++j) {
            if (!trap.compareTraps(list[j])) continue;
            return true;
        }
        return false;
    }

    public BTrapType getTrapTypeByOID(SnmpOID oidVal) {
        BTrapType[] trapList = this.getTrapList();
        long[] oid = oidVal.toValue();
        if (oid == null) {
            return null;
        }
        for (int i = 0; i < trapList.length; ++i) {
            long[] trapOid = trapList[i].getOid();
            if (oid.length != trapOid.length) continue;
            boolean match = true;
            for (int j = 0; j < oid.length; ++j) {
                if (oid[j] == trapOid[j]) continue;
                match = false;
            }
            if (!match) continue;
            return trapList[i];
        }
        return null;
    }

    public BTrapType getTrapTypeByGenericSpecific(String enterprise, int generic, int specific) {
        BTrapType[] trapList = this.getTrapList();
        for (int i = 0; i < trapList.length; ++i) {
            if (trapList[i].getGenericType() != generic || trapList[i].getSpecificType() != specific || !SnmpUtil.longArrayToString(trapList[i].getOid()).equals(enterprise) && !"1.3.6.1.2.1.11".equals(enterprise)) continue;
            return trapList[i];
        }
        return null;
    }

    public static final BTrapType getGenericTrapType(int genType, int specType) {
        for (int i = 0; i < genericTrapList.length; ++i) {
            if (genericTrapList[i].getGenericType() != genType || genericTrapList[i].getSpecificType() != specType) continue;
            return genericTrapList[i];
        }
        return null;
    }

    public static final BTrapType getGenericTrapType(SnmpOID oidVal) {
        long[] oid = oidVal.toValue();
        if (oid == null) {
            return null;
        }
        for (int i = 0; i < genericTrapList.length; ++i) {
            long[] trapOid = genericTrapList[i].getOid();
            if (oid.length != trapOid.length) continue;
            boolean match = true;
            for (int j = 0; j < oid.length; ++j) {
                if (oid[j] == trapOid[j]) continue;
                match = false;
            }
            if (!match) continue;
            return genericTrapList[i];
        }
        return null;
    }
}

