/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.wb;

import com.tridium.bacnet.job.BDiscoveryDevice;
import com.tridium.bacnet.ui.device.BBacnetDeviceManager;
import com.tridium.bacnet.ui.device.BacnetDeviceController;
import com.tridium.bacnet.ui.device.BacnetDeviceLearn;
import com.tridium.bacnet.ui.device.BacnetDeviceModel;
import com.tridium.bacnetEde.BEdeConfig;
import com.tridium.bacnetEde.BEdeRecord;
import com.tridium.bacnetEde.jobs.BDeviceDiscoveryJob;
import com.tridium.bacnetEde.jobs.BEdeDiscoveryDevice;
import com.tridium.bacnetEde.wb.BEdeConfigSelector;
import com.tridium.bacnetEde.wb.BWbEdeService;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.driver.BDevice;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.tool.WbServiceManager;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetNetwork", "bacnet:BacnetDeviceFolder"}, defaultAgent=AgentOn.Preference.NOT_PREFERRED)})
public class BEdeBacnetDeviceManager
extends BBacnetDeviceManager {
    public static final Type TYPE = Sys.loadType(BEdeBacnetDeviceManager.class);
    BJob job;
    MgrColumn colKeyname = new MgrColumn.PropPath(new Property[]{BEdeDiscoveryDevice.edeRecord, BEdeRecord.keyName});
    private static final Lexicon lex = Lexicon.make(BEdeBacnetDeviceManager.class);
    private static final String LBL_CONFIG_TITLE = lex.getText("edeconfig.labels.filechooser.title");

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    public void started() throws Exception {
        super.started();
        WbServiceManager manager = BWbEdeService.getManager();
        if (!manager.isRunning(BWbEdeService.TYPE.getTypeInfo())) {
            manager.start(BWbEdeService.TYPE.getTypeInfo());
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        BJob job;
        if (event.getSourceComponent().getType().is(BDeviceDiscoveryJob.TYPE) && (job = (BJob)event.getSourceComponent()).getJobState().isComplete()) {
            ((Learn)this.getLearn()).setJobComplete(true);
            this.bacLearn().jobComplete(job);
        }
    }

    public class Learn
    extends BacnetDeviceLearn {
        public Learn(BBacnetDeviceManager mgr) {
            super(mgr);
        }

        protected MgrColumn[] makeColumns() {
            MgrColumn[] baseCols = super.makeColumns();
            MgrColumn[] learnCols = new MgrColumn[baseCols.length + 1];
            System.arraycopy(baseCols, 0, learnCols, 0, baseCols.length);
            learnCols[baseCols.length] = BEdeBacnetDeviceManager.this.colKeyname;
            return learnCols;
        }

        public void jobComplete(BJob job) {
            if (job instanceof BDeviceDiscoveryJob) {
                job.lease(1);
                Object[] lastLearn = (BDiscoveryDevice[])job.getChildren(BDiscoveryDevice.class);
                this.updateRoots(lastLearn);
            }
        }

        public boolean getJobComplete() {
            return this.jobComplete;
        }

        public void setJobComplete(boolean v) {
            this.jobComplete = v;
        }
    }

    private class Controller
    extends BacnetDeviceController {
        public Controller(BBacnetDeviceManager mgr) {
            super(mgr);
        }

        public void updateCommands() {
            BComponent[] sel = this.getSelectedComponentsWithoutFolders();
            this.edit.setEnabled(sel.length > 0);
            this.cancel.setEnabled(BEdeBacnetDeviceManager.this.job != null && BEdeBacnetDeviceManager.this.job.getJobState().isRunning());
            this.discover.setEnabled(BEdeBacnetDeviceManager.this.job == null || !BEdeBacnetDeviceManager.this.job.getJobState().isRunning());
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.edit, this.learnMode, this.discover, this.cancel, this.add};
        }

        public BWidget makeActionBar() {
            MgrController.IMgrCommand[] cmds1 = this.makeCommands();
            return this.makeActionPane(cmds1);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            this.learnMode.setSelected(true);
            BEdeConfigSelector content = new BEdeConfigSelector();
            int result = BDialog.open((BWidget)this.getManager(), (String)LBL_CONFIG_TITLE, (Object)((Object)content), (int)3);
            if (result == 1) {
                try {
                    BEdeConfig config = content.getSelectedConfig();
                    if (null == config) {
                        throw new BajaRuntimeException("No configuration selected. Please select a configuration to process EDE.");
                    }
                    BBacnetNetwork network = BEdeBacnetDeviceManager.this.getNetwork();
                    BWbEdeService service = BWbEdeService.getService();
                    BOrd jobOrd = service.submitDeviceDiscovery(config, network, cx);
                    BJob job = (BJob)jobOrd.get();
                    job.lease();
                    BEdeBacnetDeviceManager.this.registerForComponentEvents((BComponent)job);
                    BEdeBacnetDeviceManager.this.getJobBar().load(job);
                    BEdeBacnetDeviceManager.this.getLearn().setJob(job);
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            return null;
        }
    }

    public class Model
    extends BacnetDeviceModel {
        public Model(BBacnetDeviceManager mgr) {
            super(mgr);
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            CommandArtifact artifact = super.addInstances(rows, cx);
            if (rows.length > 0) {
                BComponent parent = (BComponent)this.getManager().getCurrentValue();
                parent.lease();
                for (int i = 0; i < rows.length; ++i) {
                    MgrEditRow row = rows[i];
                    BEdeDiscoveryDevice disc = (BEdeDiscoveryDevice)((Object)row.getDiscovery());
                    BEdeRecord record = disc.getEdeRecord();
                    String objectName = record.getObjectName();
                    String slotName = SlotPath.escape((String)objectName);
                    BValue bValue = parent.get(slotName);
                    if (null == bValue || !bValue.getType().is(BDevice.TYPE)) continue;
                    BDevice dev = (BDevice)bValue;
                    Property propertyInParent = dev.getPropertyInParent();
                    String keyName = record.getKeyName();
                    parent.setDisplayName(propertyInParent, BFormat.make((String)keyName), cx);
                }
            }
            return artifact;
        }
    }
}

