/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetEde.jobs;

import com.tridium.bacnetEde.BEdeConfig;
import com.tridium.bacnetEde.BEdeReader;
import com.tridium.bacnetEde.BEdeRecord;
import com.tridium.bacnetEde.EdeCursor;
import com.tridium.bacnetEde.jobs.BEdeDiscoveryLog;
import com.tridium.bacnetEde.wb.BWbEdeService;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BHistoryImportDiscoveryJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BHistoryImportDiscoveryJob.class);
    private static final Lexicon bacnetLex = Lexicon.make((String)"bacnet");
    private static final Lexicon lex = Lexicon.make(BHistoryImportDiscoveryJob.class);
    private BEdeConfig config;
    private int deviceId;

    public Type getType() {
        return TYPE;
    }

    public BHistoryImportDiscoveryJob() {
    }

    public BHistoryImportDiscoveryJob(BEdeConfig config, int deviceId) {
        this.config = config;
        this.deviceId = deviceId;
    }

    public void run(Context cx) throws Exception {
        if (null == this.config || null == this.config.getEdePath()) {
            this.failed((Throwable)new BajaRuntimeException(lex.getText("edeimport.discover.job.failure.fileNotSpecified")));
        }
        try {
            BWbEdeService service = BWbEdeService.getService();
            BEdeReader reader = service.getReader(this.config);
            EdeCursor cursor = (EdeCursor)reader.cursor();
            this.log().message(lex.getText("edeimport.discover.history.job.iterateThroughEDE"));
            while (cursor.next()) {
                BEdeRecord record = (BEdeRecord)((Object)cursor.get());
                BBacnetObjectType objType = record.getObjectType();
                if (objType != BBacnetObjectType.trendLog || record.getDeviceObjInstant() != this.deviceId) continue;
                String ht = bacnetLex.getText("historyType.unknown");
                String keyName = record.getKeyName();
                String objectName = record.getObjectName();
                int instanceNumber = record.getObjInstance();
                BBacnetObjectIdentifier id = BBacnetObjectIdentifier.make((int)objType.getOrdinal(), (int)instanceNumber);
                BEdeDiscoveryLog dl = new BEdeDiscoveryLog(objectName, keyName, id, ht);
                String desc = record.getDescription();
                dl.setDescription(desc);
                this.add(null, (BValue)dl);
                this.log().message(lex.getText("edeimport.discover.history.job.addingHistory", new Object[]{objectName}));
            }
        }
        catch (Exception e) {
            this.failed(e);
        }
    }
}

