/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.virtual;

import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.virtual.VirtualPath;

public abstract class BVirtualGateway
extends BComponent {
    public static final Type TYPE = Sys.loadType(BVirtualGateway.class);
    private static final BIcon icon = BIcon.std("navOnly/virtual.png");
    static final Logger log = Logger.getLogger("virtual.gateway");
    BComponentSpace space;

    @Override
    public Type getType() {
        return TYPE;
    }

    public final BComponentSpace getVirtualSpace() {
        return this.space;
    }

    protected BVirtualComponentSpace makeVirtualSpace() {
        BVirtualComponentSpace vSpace = new BVirtualComponentSpace("virtual", LexiconText.make("baja", "nav.virtual"), BOrd.make("virtual:"), this);
        BVirtualComponent root = this.makeVirtualRoot();
        if (root == null) {
            throw new IllegalStateException("makeVirtualRoot() returned null.  Must return a valid root component for the virtual space.");
        }
        vSpace.setRootComponent(root);
        return vSpace;
    }

    protected BVirtualComponent makeVirtualRoot() {
        return new BVirtualComponent();
    }

    public Slot loadVirtualSlot(BVirtualComponent parent, String virtualPathName) {
        String nameAssigned;
        String virtualSlotName;
        if (parent == null) {
            return null;
        }
        Slot result = null;
        if (virtualPathName != null && (result = parent.getSlot(virtualSlotName = VirtualPath.toSlotPathName(virtualPathName))) == null && (result = this.addVirtualSlot(parent, virtualPathName)) != null && !(nameAssigned = result.getName()).equals(virtualSlotName)) {
            log.warning("Name of virtual slot added is inconsistent: \"" + nameAssigned + "\" was expected to be \"" + virtualSlotName + "\"");
        }
        return result;
    }

    protected abstract Property addVirtualSlot(BVirtualComponent var1, String var2);

    public abstract void loadVirtualSlots(BVirtualComponent var1);

    public void ensureVirtualsLoaded(BOrd[] virtualOrds) {
    }

    @Override
    public final BOrd getNavOrd() {
        BOrd navOrd = super.getNavOrd();
        if (navOrd != null) {
            navOrd = BOrd.make(navOrd, "virtual:/");
        }
        return navOrd;
    }

    @Override
    public boolean hasNavChildren() {
        if (this.space != null) {
            return this.space.hasNavChildren();
        }
        return super.hasNavChildren();
    }

    @Override
    public BINavNode getNavChild(String navName) {
        if (this.space != null) {
            return this.space.getNavChild(navName);
        }
        return super.getNavChild(navName);
    }

    @Override
    public BINavNode resolveNavChild(String navName) {
        if (this.space != null) {
            return this.space.resolveNavChild(navName);
        }
        return super.resolveNavChild(navName);
    }

    @Override
    public BINavNode[] getNavChildren() {
        if (this.space != null) {
            return this.space.getNavChildren();
        }
        return super.getNavChildren();
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.remove("pxEditor:PxEditor");
        list.remove("wiresheet:WireSheet");
        list.remove("workbench:LinkSheet");
        list.remove("tagdictionary:TagManager");
        return list;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle("VirtualSpace", 2);
        out.prop((Object)"virtualSpaceType", this.space != null ? this.space.getType() : null);
        out.endProps();
        if (this.space != null) {
            this.space.spy(out);
        }
        out.startProps();
        out.trTitle("VirtualGateway", 2);
        out.endProps();
        super.spy(out);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 108: {
                this.setSpace((BComponentSpace)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    void fwStarted() {
        BVirtualComponentSpace vSpace = this.makeVirtualSpace();
        this.setSpace(vSpace);
        vSpace.start();
    }

    void fwStopped() {
        if (this.space != null) {
            try {
                if (this.space instanceof BVirtualComponentSpace) {
                    ((BVirtualComponentSpace)this.space).stop();
                }
            }
            finally {
                this.space = null;
            }
        }
    }

    void setSpace(BComponentSpace space) {
        this.space = space;
    }
}

