/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.util.Arrays;
import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    public static Version ZERO;
    public static Version NULL;
    private int[] versions;

    public Version(int[] versions) {
        this.versions = new int[versions.length];
        System.arraycopy(versions, 0, this.versions, 0, versions.length);
    }

    public Version(String s) {
        try {
            int[] buf = new int[16];
            int c = 0;
            StringTokenizer st = new StringTokenizer(s, ".");
            while (st.hasMoreTokens()) {
                int x = Integer.parseInt(st.nextToken());
                if (x < 0) {
                    throw new IllegalArgumentException();
                }
                buf[c++] = x;
            }
            this.versions = new int[c];
            System.arraycopy(buf, 0, this.versions, 0, c);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid version string \"" + s + "\"");
        }
    }

    public int major() {
        if (this.versions.length < 1) {
            return -1;
        }
        return this.versions[0];
    }

    public int minor() {
        if (this.versions.length < 2) {
            return -1;
        }
        return this.versions[1];
    }

    public int build() {
        if (this.versions.length < 3) {
            return -1;
        }
        return this.versions[2];
    }

    public int patch() {
        if (this.versions.length < 4) {
            return -1;
        }
        return this.versions[3];
    }

    public int get(int index) {
        return this.versions[index];
    }

    public int size() {
        return this.versions.length;
    }

    public boolean isNull() {
        if (this.versions.length == 1) {
            return this.versions[0] == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Version ver) {
        Version v = ver;
        int len = this.versions.length;
        int vLen = v.versions.length;
        for (int i = 0; i < len && i < vLen; ++i) {
            if (this.versions[i] > v.versions[i]) {
                return 1;
            }
            if (this.versions[i] >= v.versions[i]) continue;
            return -1;
        }
        if (len == vLen) {
            return 0;
        }
        if (len > vLen) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Version) {
            Version v = (Version)obj;
            if (this.versions.length != v.versions.length) {
                return false;
            }
            for (int i = 0; i < this.versions.length; ++i) {
                if (this.versions[i] == v.versions[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.versions.length; ++i) {
            hash += this.versions[i];
            hash <<= 8;
        }
        return hash += this.versions.length;
    }

    public String toString() {
        return this.toString(this.versions.length);
    }

    public String toString(int len) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < len && i < this.versions.length; ++i) {
            if (i > 0) {
                s.append('.');
            }
            s.append(this.versions[i]);
        }
        return s.toString();
    }

    public Version toMinorVersion() {
        return new Version(Arrays.copyOfRange(this.versions, 0, 2));
    }

    public static void main(String[] args) {
        Version v1 = new Version(args[0]);
        Version v2 = new Version(args[1]);
        System.out.println("v1: " + v1);
        System.out.println("v2: " + v2);
        System.out.println("v1.equals(v2):    " + v1.equals(v2));
        System.out.println("v1.compareTo(v2): " + v1.compareTo(v2));
        System.out.println("str:              " + v1.toString().compareTo(v2.toString()));
    }

    static {
        NULL = ZERO = new Version("0");
    }
}

