/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.text.MessageFormat;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.owasp.encoder.Encode;

public class LexiconText {
    public final BModule module;
    public final String key;
    private String defaultLang = "???";
    private String defaultContext;

    public static LexiconText make(Type typeInModule, String key) {
        return LexiconText.make(typeInModule.getModule(), key);
    }

    public static LexiconText make(BModule module, String key) {
        return new LexiconText(module, key);
    }

    public static LexiconText make(String module, String key) {
        return LexiconText.make(Lexicon.module(module), key);
    }

    protected LexiconText(BModule module, String key) {
        this.module = module;
        this.key = key;
    }

    public String get(Context cx, String def) {
        if (cx == null) {
            if (!this.defaultLang.equals(Sys.getLanguage())) {
                this.defaultLang = Sys.getLanguage();
                this.defaultContext = Lexicon.make(this.module, cx).get(this.key);
            }
            if (this.defaultContext == null) {
                return def;
            }
            return this.defaultContext;
        }
        String value = Lexicon.make(this.module, cx).get(this.key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public String getText(Context cx) {
        return this.get(cx, this.key);
    }

    public String getText(Context cx, Object[] args) {
        String value = this.get(cx, null);
        if (value == null) {
            return this.key;
        }
        return MessageFormat.format(value, args);
    }

    public String getHtmlSafeText(Context cx) {
        return Encode.forHtml((String)this.getText(cx));
    }

    public String getHtmlSafeText(Context cx, Object ... args) {
        return Encode.forHtml((String)this.getText(cx, args));
    }

    public Localizable toLocalizable(Object ... args) {
        return context -> this.getText(context, args);
    }

    public static Localizable toLocalizable(Type typeInModule, String key, Object ... args) {
        return LexiconText.make(typeInModule.getModule(), key).toLocalizable(args);
    }

    public static Localizable toLocalizable(BModule module, String key, Object ... args) {
        return new LexiconText(module, key).toLocalizable(args);
    }

    public static Localizable toLocalizable(String module, String key, Object ... args) {
        return LexiconText.make(Lexicon.module(module), key).toLocalizable(args);
    }
}

