/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.util.CompUtil;
import com.tridium.util.ObjectUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.space.BComponentSpace;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BNameMap;

public class BServiceContainer
extends BComponent
implements BIService,
BIRestrictedComponent {
    public static final Type TYPE = Sys.loadType(BServiceContainer.class);
    private static final BIcon icon = BIcon.std("services.png");
    static final Logger log = Logger.getLogger("sys.service");

    @Override
    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    @Override
    public void serviceStarted() throws Exception {
    }

    @Override
    public void serviceStopped() throws Exception {
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkContextForSuperUser(this, cx);
        Property prop = this.getPropertyInParent();
        BComponentSpace space = parent.getComponentSpace();
        if (!(space != null && space.isProxyComponentSpace() || BServiceContainer.isParentAncestryLegal(this.getStation(parent), parent, prop))) {
            throw new IllegalChildException("baja", "RestrictedToServiceContainer", new Object[]{parent.getType(), this.getType()});
        }
    }

    private static boolean isParentAncestryLegal(BStation station, BComplex parent, Property prop) {
        if (station == null || parent == null || prop == null) {
            return false;
        }
        if (parent.getType().equals(TYPE)) {
            return BServiceContainer.isParentAncestryLegal(station, parent.getParent(), parent.getPropertyInParent());
        }
        return parent == station && BStation.Services.equals(prop);
    }

    @Override
    public final boolean completesStarted() {
        BComponent parent = this.getParent().asComponent();
        Property propInParent = this.getPropertyInParent();
        return !BServiceContainer.isParentAncestryLegal(this.getStation(parent), parent, propInParent);
    }

    @Override
    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: 
            case 15: {
                Logger logger = log;
                if (a instanceof Logger) {
                    logger = (Logger)a;
                }
                this.fwServiceStarted(logger);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fwServiceStarted(Logger logger) {
        BComponent parent = this.getParent().asComponent();
        Property propInParent = this.getPropertyInParent();
        BStation station = this.getStation(parent);
        if (!BServiceContainer.isParentAncestryLegal(station, parent, propInParent)) {
            boolean remove = true;
            try {
                if (!Sys.isStationStarted()) {
                    BServiceContainer serviceContainer = station.getServices();
                    ArrayList<BValue> values = new ArrayList<BValue>();
                    ArrayList<String> names = new ArrayList<String>();
                    ArrayList<Integer> flags = new ArrayList<Integer>();
                    ArrayList<BFacets> facets = new ArrayList<BFacets>();
                    if (parent == station && serviceContainer.getDynamicPropertiesArray().length == 0) {
                        BFormat displayNameFormat = station.getDisplayNameFormat(propInParent);
                        if (displayNameFormat == null) {
                            displayNameFormat = BFormat.make(this.getDisplayName(null));
                        }
                        station.setDisplayName(BStation.Services, displayNameFormat, null);
                        Property[] props = this.getDynamicPropertiesArray();
                        int len = props.length;
                        if (len > 0) {
                            for (int i = 0; i < len; ++i) {
                                Property property = props[i];
                                String name = property.getName();
                                BValue value = this.get(property);
                                int slotFlags = this.getFlags(property);
                                BFacets slotFacets = this.getSlotFacets(property);
                                if (!value.isComplex()) {
                                    BValue existing;
                                    if (name.equals("displayNames") && value.getType().is(BNameMap.TYPE) && (existing = serviceContainer.get("displayNames")) != null && existing.getType().is(BNameMap.TYPE)) {
                                        value = BNameMap.make((BNameMap)existing, (BNameMap)value);
                                    }
                                    CompUtil.setOrAdd(serviceContainer, name, value, slotFlags, slotFacets, null);
                                    continue;
                                }
                                names.add(name);
                                values.add(value);
                                flags.add(slotFlags);
                                facets.add(slotFacets);
                                if (!value.isComponent()) continue;
                                logger.warning("The component at '" + value.asComponent().toDisplayPathString(null) + "' is located in an illegal dynamic ServiceContainer. It is being moved to a new location under the station's frozen Services container.");
                            }
                        }
                    } else {
                        remove = false;
                        names.add(propInParent.getName());
                        values.add(this);
                        flags.add(parent.getFlags(propInParent));
                        facets.add(parent.getSlotFacets(propInParent));
                        logger.warning("The ServiceContainer at '" + this.toDisplayPathString(null) + "' is located in an illegal location. It is being moved to a new location under the station's frozen Services container.");
                    }
                    BObject[] vals = values.toArray(new BObject[values.size()]);
                    String[] propNames = names.toArray(new String[names.size()]);
                    new Mark(vals, propNames).moveTo(serviceContainer, null);
                    for (int i = 0; i < facets.size(); ++i) {
                        Property property = serviceContainer.getProperty((String)names.get(i));
                        serviceContainer.setFlags(property, (Integer)flags.get(i));
                        serviceContainer.setFacets(property, (BFacets)facets.get(i));
                    }
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Error during ServiceContainer migration.", t);
            }
            finally {
                if (remove) {
                    logger.warning("Found an illegal dynamic ServiceContainer at '" + this.toDisplayPathString(null) + "'. It will now be removed.");
                    parent.remove(propInParent);
                }
            }
            new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
    }

    private BStation getStation(BComponent parent) {
        BComponentSpace space = parent.getComponentSpace();
        if (space != null) {
            return ObjectUtil.getStation(space);
        }
        if (parent instanceof BStation) {
            return (BStation)parent;
        }
        return null;
    }
}

