/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.naming.BOrd;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Knob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BCompositeAction
extends BAction {
    public static final Type TYPE = Sys.loadType(BCompositeAction.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public Mirror getMirror() {
        try {
            BComponent parent = this.getParentComponent();
            if (parent == null) {
                return null;
            }
            BComponentSpace space = parent.getComponentSpace();
            if (space == null) {
                return null;
            }
            Knob[] knobs = parent.getKnobs(this.getPropertyInParent());
            if (knobs.length == 0) {
                return null;
            }
            Knob knob = knobs[0];
            BOrd ord = knob.getTargetOrd();
            String slotName = knob.getTargetSlotName();
            BComponent c = (BComponent)ord.get(space);
            Slot slot = c.getSlot(slotName);
            if (slot == this.getPropertyInParent()) {
                return null;
            }
            if (!(slot instanceof Action)) {
                return null;
            }
            return new Mirror(knob, c, (Action)slot);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Type getParameterType() {
        Mirror mirror = this.getMirror();
        if (mirror != null) {
            return mirror.action.getParameterType();
        }
        return null;
    }

    @Override
    public BValue getParameterDefault() {
        Mirror mirror = this.getMirror();
        if (mirror != null) {
            mirror.component.lease();
            return mirror.component.getActionParameterDefault(mirror.action);
        }
        return null;
    }

    @Override
    public BFacets getFacets() {
        Mirror mirror = this.getMirror();
        if (mirror != null) {
            return mirror.component.getSlotFacets(mirror.action);
        }
        return null;
    }

    @Override
    public BValue invoke(BComponent target, BValue arg) {
        return null;
    }

    @Override
    public Type getReturnType() {
        return null;
    }

    public static class Mirror {
        public Knob knob;
        public BComponent component;
        public Action action;

        public Mirror(Knob knob, BComponent component, Action action) {
            this.knob = knob;
            this.component = component;
            this.action = action;
        }

        public String toString() {
            return this.component.toPathString() + "." + this.action.getName();
        }
    }
}

