/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.units;

import com.tridium.sys.Nre;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class UnitDatabase {
    private static UnitDatabase db;
    private Quantity[] quantities;

    public static BUnit getUnit(String name) {
        UnitDatabase.getDefault();
        return BUnit.getUnit(name);
    }

    public static UnitDatabase getDefault() {
        if (db == null) {
            db = new UnitDatabase();
            try {
                db.load();
            }
            catch (Exception e) {
                Logger.getLogger("sys.unitdb").log(Level.SEVERE, "Cannot load database", e);
            }
        }
        return db;
    }

    public Quantity[] getQuantities() {
        Quantity[] copy = new Quantity[this.quantities.length];
        System.arraycopy(this.quantities, 0, copy, 0, copy.length);
        return copy;
    }

    public Quantity getQuantity(BUnit unit) {
        return unit.quantity;
    }

    public void dump() {
        Quantity[] q = this.getQuantities();
        for (int i = 0; i < q.length; ++i) {
            System.out.println(q[i].getName());
            BUnit[] u = q[i].getUnits();
            for (int j = 0; j < u.length; ++j) {
                System.out.println("   " + u[j].encodeToString());
            }
        }
    }

    private void load() throws Exception {
        AccessController.doPrivileged(new LoadUnitsPrivilegedAction());
    }

    private BUnit parseUnit(BDimension dim, XElem u) throws Exception {
        String name = u.get("n");
        try {
            String sym = u.get("s", null);
            double scale = 1.0;
            String scaleStr = u.get("scale", null);
            if (scaleStr != null) {
                scale = Double.parseDouble(scaleStr);
            }
            double offset = 0.0;
            String offsetStr = u.get("offset", null);
            if (offsetStr != null) {
                offset = Double.parseDouble(offsetStr);
            }
            boolean prefix = false;
            String prefixStr = u.get("prefix", null);
            if (prefixStr != null) {
                prefix = prefixStr.equalsIgnoreCase("true");
            }
            return BUnit.make(name, sym, dim, scale, offset, prefix);
        }
        catch (Exception e) {
            Logger.getLogger("sys.unitdb").log(Level.WARNING, "Error parsing unit \"" + name + "\" [line " + u.line() + "] ", e);
            return null;
        }
    }

    static /* synthetic */ Quantity[] access$102(UnitDatabase x0, Quantity[] x1) {
        x0.quantities = x1;
        return x1;
    }

    public static class Quantity {
        final String name;
        final BDimension dim;
        final BUnit[] units;

        Quantity(String name, BDimension dim, BUnit[] units) {
            this.name = name;
            this.dim = dim;
            this.units = units;
        }

        public String getName() {
            return this.name;
        }

        public BUnit[] getUnits() {
            BUnit[] copy = new BUnit[this.units.length];
            System.arraycopy(this.units, 0, copy, 0, copy.length);
            return copy;
        }

        public String toString() {
            return this.name + " (" + this.dim + ")";
        }
    }

    private class LoadUnitsPrivilegedAction
    implements PrivilegedExceptionAction<Object> {
        private LoadUnitsPrivilegedAction() {
        }

        @Override
        public Object run() throws Exception {
            XElem unitdb = XParser.make((InputStream)Nre.bootEnv.read("/defaults/units.xml")).parse();
            XElem[] q = unitdb.elems("quantity");
            UnitDatabase.access$102(UnitDatabase.this, new Quantity[q.length]);
            for (int i = 0; i < q.length; ++i) {
                int j;
                String qname = q[i].get("n");
                BDimension dim = null;
                try {
                    dim = (BDimension)BDimension.DEFAULT.decodeFromString(q[i].get("dim"));
                }
                catch (Exception e) {
                    throw new Exception("Error parsing quanitity \"" + qname + "\" [line " + q[i].line() + "] " + e);
                }
                XElem[] u = q[i].elems("unit");
                BUnit[] units = new BUnit[u.length];
                for (j = 0; j < u.length; ++j) {
                    units[j] = UnitDatabase.this.parseUnit(dim, u[j]);
                }
                ((UnitDatabase)UnitDatabase.this).quantities[i] = new Quantity(qname, dim, units);
                for (j = 0; j < units.length; ++j) {
                    if (units[j] == null) continue;
                    units[j].quantity = UnitDatabase.this.quantities[i];
                }
            }
            return null;
        }
    }
}

