/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.units;

import com.tridium.sys.Nre;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class BUnitConversion
extends BFrozenEnum {
    public static final int NONE = 0;
    public static final int METRIC = 1;
    public static final int ENGLISH = 2;
    public static final BUnitConversion none = new BUnitConversion(0);
    public static final BUnitConversion metric = new BUnitConversion(1);
    public static final BUnitConversion english = new BUnitConversion(2);
    public static final Type TYPE = Sys.loadType(BUnitConversion.class);
    public static final BUnitConversion DEFAULT = none;
    private static Map<String, BUnit> byMetric = new HashMap<String, BUnit>();
    private static Map<String, BUnit> byEnglish = new HashMap<String, BUnit>();
    private static List<Entry> entries;
    private static volatile boolean loaded;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BUnitConversion make(int ordinal) {
        return (BUnitConversion)none.getRange().get(ordinal, false);
    }

    public static BUnitConversion make(String tag) {
        return (BUnitConversion)none.getRange().get(tag);
    }

    private BUnitConversion(int ordinal) {
        super(ordinal);
    }

    public BUnit getDesiredUnit(BUnit unit) {
        BUnit desired;
        if (unit == null) {
            return null;
        }
        if (this == none) {
            return unit;
        }
        if (!loaded) {
            BUnitConversion.load();
        }
        if (this == metric) {
            BUnit desired2 = byEnglish.get(unit.getUnitName());
            if (desired2 != null) {
                return desired2;
            }
        } else if (this == english && (desired = byMetric.get(unit.getUnitName())) != null) {
            return desired;
        }
        return unit;
    }

    static void load() {
        ArrayList<Entry> entries;
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            XElem root;
            try {
                root = AccessController.doPrivileged(() -> XParser.make((InputStream)Nre.bootEnv.read("/defaults/unitConversion.xml")).parse());
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            XElem[] converts = root.elems();
            entries = new ArrayList(converts.length);
            for (XElem x : converts) {
                try {
                    BUnit metric = UnitDatabase.getUnit(x.get("metric"));
                    BUnit english = UnitDatabase.getUnit(x.get("english"));
                    byMetric.put(metric.getUnitName(), english);
                    byEnglish.put(english.getUnitName(), metric);
                    entries.add(new Entry(metric, english));
                }
                catch (Exception e) {
                    Logger.getLogger("sys.unitConversion").log(Level.WARNING, "Parsing convert [line " + x.line() + "]", e);
                }
            }
        }
        catch (Exception e) {
            entries = new ArrayList<Entry>();
            Logger.getLogger("sys.unitConversion").log(Level.SEVERE, "Error parsing unitConversion.xml", e);
        }
        BUnitConversion.entries = Collections.unmodifiableList(entries);
    }

    public static List<Entry> getEntries() {
        BUnitConversion.load();
        return entries;
    }

    static {
        loaded = false;
    }

    public static final class Entry {
        private BUnit metric;
        private BUnit english;

        Entry(BUnit metric, BUnit english) {
            this.metric = metric;
            this.english = english;
        }

        public BUnit getMetric() {
            return this.metric;
        }

        public BUnit getEnglish() {
            return this.english;
        }
    }
}

