/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.units;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.UnitDatabase;
import javax.baja.units.UnitDifferentialConverter;
import javax.baja.units.UnitException;

public final class BUnit
extends BSimple
implements BIDataValue {
    private static final Map<String, BUnit> cache = new HashMap<String, BUnit>();
    public static final BUnit NULL;
    public static final BUnit DEFAULT;
    public static final Type TYPE;
    private BDimension dimension;
    private String unitName;
    private String symbol;
    private double scale;
    private double offset;
    private String string;
    private boolean prefix;
    UnitDatabase.Quantity quantity;

    public static BUnit getUnit(String unitName) {
        BUnit unit = cache.get(unitName);
        if (unit == null) {
            UnitDatabase.getDefault();
            unit = cache.get(unitName);
            if (unit == null) {
                throw new UnitException("Unknown unit: " + unitName);
            }
        }
        return unit;
    }

    public static BUnit make(String unitName, BDimension dimension) {
        return BUnit.make(unitName, null, dimension, 1.0, 0.0);
    }

    public static BUnit make(String unitName, String symbol, BDimension dimension) {
        return BUnit.make(unitName, symbol, dimension, 1.0, 0.0);
    }

    public static BUnit make(String unitName, String symbol, BDimension dimension, double scale) {
        return BUnit.make(unitName, symbol, dimension, scale, 0.0);
    }

    public static BUnit make(String unitName, BDimension dimension, double scale) {
        return BUnit.make(unitName, null, dimension, scale, 0.0);
    }

    public static BUnit make(String unitName, String symbol, BDimension dimension, double scale, double offset) {
        return BUnit.make(unitName, symbol, dimension, scale, offset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BUnit make(String unitName, String symbol, BDimension dimension, double scale, double offset, boolean prefix) {
        if (unitName == null || dimension == null) {
            throw new NullPointerException();
        }
        if (unitName.indexOf(59) >= 0) {
            throw new UnitException("Invalid unitName: " + unitName);
        }
        if (symbol == null) {
            symbol = unitName;
        } else if (symbol.indexOf(59) >= 0) {
            throw new UnitException("Invalid symbol: " + symbol);
        }
        Map<String, BUnit> map = cache;
        synchronized (map) {
            BUnit unit = cache.get(unitName);
            if (unit != null) {
                if (!unit.dimension.equals(dimension)) {
                    throw new UnitException("Duplicate unit is incompatible: " + unitName);
                }
                return unit;
            }
            unit = new BUnit();
            unit.unitName = unitName;
            unit.symbol = symbol;
            unit.dimension = dimension;
            unit.scale = scale;
            unit.offset = offset;
            unit.prefix = prefix;
            cache.put(unitName, unit);
            return unit;
        }
    }

    private BUnit() {
    }

    public final BDimension getDimension() {
        return this.dimension;
    }

    public final String getUnitName() {
        return this.unitName;
    }

    public final String getUnitName(Context context) {
        return this.unitName;
    }

    public final String getSymbol() {
        return this.symbol;
    }

    public final String getSymbol(Context context) {
        return this.symbol;
    }

    public final double getScale() {
        return this.scale;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final boolean getIsPrefix() {
        return this.prefix;
    }

    public final boolean isConvertible(BUnit unit) {
        return this.dimension.equals(unit.dimension);
    }

    public final double toNormal(double scalar) {
        return scalar * this.scale + this.offset;
    }

    public final double fromNormal(double scalar) {
        return (scalar - this.offset) / this.scale;
    }

    public final double convertTo(BUnit toUnit, double scalar) {
        if (!this.dimension.equals(toUnit.dimension)) {
            throw new UnitException("Not convertible: " + this + " -> " + toUnit);
        }
        return (scalar * this.scale + this.offset - toUnit.offset) / toUnit.scale;
    }

    public BUnit getDifferentialUnit() {
        return UnitDifferentialConverter.getInstance().getDifferential(this);
    }

    public BUnit getAbsoluteUnit() {
        return UnitDifferentialConverter.getInstance().getAbsolute(this);
    }

    @Override
    public final boolean isNull() {
        return this == NULL;
    }

    @Override
    public String toString(Context context) {
        return this.getSymbol(context);
    }

    @Override
    public final int hashCode() {
        return this.unitName.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public final void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public final BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public final String encodeToString() {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            s.append(this.unitName).append(';');
            if (this.symbol != this.unitName) {
                s.append(this.symbol);
            }
            s.append(';');
            s.append(this.dimension.encodeToString()).append(';');
            if (this.scale != 1.0) {
                s.append('*').append(this.scale);
            }
            if (this.offset != 0.0) {
                s.append('+').append(this.offset);
            }
            s.append(';');
            this.string = s.toString();
        }
        return this.string;
    }

    @Override
    public final BObject decodeFromString(String s) throws IOException {
        try {
            int x = 0;
            int y = s.indexOf(59);
            String unitName = s.substring(x, y);
            x = y;
            y = s.indexOf(59, y + 1);
            String symbol = x + 1 == y ? null : s.substring(x + 1, y);
            x = y;
            y = s.indexOf(59, y + 1);
            BDimension dimension = (BDimension)this.dimension.decodeFromString(s.substring(x + 1, y));
            x = y;
            y = s.indexOf(59, y + 1);
            String eq = s.substring(x + 1, y);
            double scale = 1.0;
            double offset = 0.0;
            int eqLength = eq.length();
            if (eqLength > 0) {
                int z = 0;
                if (eq.charAt(0) == '*') {
                    z = eq.indexOf(43);
                    if (z < 0) {
                        z = eqLength;
                    }
                    scale = Double.parseDouble(eq.substring(1, z));
                }
                if (z < eqLength && eq.charAt(z) == '+') {
                    offset = Double.parseDouble(eq.substring(z + 1, eqLength));
                }
            }
            return BUnit.make(unitName, symbol, dimension, scale, offset);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException(s);
        }
    }

    @Override
    public BIDataValue toDataValue() {
        return this;
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = BUnit.make("null", BDimension.DEFAULT);
        TYPE = Sys.loadType(BUnit.class);
    }
}

