/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.timezone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.AccessController;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.DstRule;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.timezone.TimeZoneException;

public final class BTimeZone
extends BSimple
implements BIDataValue {
    public static final BTimeZone UTC = BTimeZone.makeIgnoringCache("UTC", 0);
    public static final BTimeZone GMT = BTimeZone.makeIgnoringCache("GMT", 0);
    public static final BTimeZone NULL = BTimeZone.makeIgnoringCache("NULL", 0);
    public static final BTimeZone DEFAULT = UTC;
    private static TimeZone JAVA_UTC = null;
    private static BTimeZone localTimeZone;
    private static final Logger logger;
    private String id;
    private String stringEncoding;
    private TimeZone jzone;
    private DstRule jzoneStartRule;
    private DstRule jzoneEndRule;
    private boolean isJavaTimeZone;
    private String fixedStdName;
    private String fixedStdShort;
    private String fixedDstName;
    private String fixedDstShort;
    private int fixedUtcOffset;
    private int fixedDstDelta;
    private DstRule fixedStartRule;
    private DstRule fixedEndRule;
    private int hashCode = -1;
    public static final Comparator<BTimeZone> OFFSET_COMPARATOR;
    public static final Type TYPE;

    private BTimeZone() {
    }

    public static BTimeZone getTimeZone(String id) {
        TimeZone javaTimeZone = TimeZone.getTimeZone(id);
        if (javaTimeZone != null && javaTimeZone.getID().equalsIgnoreCase(id)) {
            return BTimeZone.makeFromJavaTimeZone(javaTimeZone);
        }
        logger.fine("Could not find definition for time zone: " + id);
        throw new TimeZoneException("Unknown time zone: " + id);
    }

    public static BTimeZone make(String id, int utcOffset) {
        return BTimeZone.make(id, id, id, id, id, utcOffset, 0, null, null);
    }

    public static BTimeZone make(String id, int utcOffset, int daylightAdj, DstRule startRule, DstRule endRule) {
        return BTimeZone.make(id, id, id, id, id, utcOffset, daylightAdj, startRule, endRule);
    }

    public static BTimeZone make(String id, String stdName, String stdShort, String dstName, String dstShort, int utcOffset, int daylightAdj, DstRule startRule, DstRule endRule) {
        try {
            BTimeZone previouslyExisting = BTimeZone.getTimeZone(id);
            if (previouslyExisting != null && id.equals(previouslyExisting.id)) {
                return previouslyExisting;
            }
        }
        catch (TimeZoneException timeZoneException) {
            // empty catch block
        }
        return BTimeZone.makeIgnoringCache(id, stdName, stdShort, dstName, dstShort, utcOffset, daylightAdj, startRule, endRule);
    }

    public static BTimeZone makeIgnoringCache(String id, int utcOffset) {
        return BTimeZone.makeIgnoringCache(id, id, id, id, id, utcOffset, 0, null, null);
    }

    public static BTimeZone makeIgnoringCache(String id, String stdName, String stdShort, String dstName, String dstShort, int utcOffset, int daylightAdj, DstRule startRule, DstRule endRule) {
        BTimeZone tz = new BTimeZone();
        tz.id = id;
        tz.fixedUtcOffset = utcOffset;
        tz.fixedStdName = stdName == null ? id : stdName;
        tz.fixedStdShort = stdShort == null ? tz.fixedStdName : stdShort;
        tz.fixedDstName = dstName == null ? id : dstName;
        tz.fixedDstShort = dstShort == null ? tz.fixedDstName : dstShort;
        tz.fixedDstDelta = daylightAdj;
        tz.fixedStartRule = startRule;
        tz.fixedEndRule = endRule;
        return tz;
    }

    private static BTimeZone makeFromJavaTimeZone(TimeZone RHS) {
        BTimeZone tz = new BTimeZone();
        tz.jzone = RHS;
        tz.isJavaTimeZone = true;
        tz.jzoneStartRule = (DstRule)DstRule.fw(1104, tz.jzone, Boolean.TRUE, null, null);
        tz.jzoneEndRule = (DstRule)DstRule.fw(1104, tz.jzone, Boolean.FALSE, null, null);
        tz.id = RHS.getID();
        return tz;
    }

    @Override
    public boolean isNull() {
        return this.equals(NULL);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName(BAbsTime time, Context cx) {
        return this.getDisplayName(time.inDaylightTime(), cx);
    }

    public String getDisplayName(boolean daylightTime, Context cx) {
        if (this.isJavaTimeZone) {
            return this.jzone.getDisplayName(daylightTime, 1);
        }
        return daylightTime ? this.fixedDstName : this.fixedStdName;
    }

    public String getShortDisplayName(BAbsTime time, Context cx) {
        return this.getShortDisplayName(time.inDaylightTime(), cx);
    }

    public String getShortDisplayName(boolean daylightTime, Context cx) {
        if (this.isJavaTimeZone) {
            return this.jzone.getDisplayName(daylightTime, 0);
        }
        return daylightTime ? this.fixedDstShort : this.fixedStdShort;
    }

    public int getUtcOffset() {
        if (this.isJavaTimeZone) {
            return this.jzone.getRawOffset();
        }
        return this.fixedUtcOffset;
    }

    public int getDaylightAdjustment() {
        if (this.isJavaTimeZone) {
            return this.jzone.getDSTSavings();
        }
        return this.fixedDstDelta;
    }

    public int getCurrentUtcOffset(long millis) {
        if (this.isJavaTimeZone) {
            return this.jzone.getOffset(millis);
        }
        return this.getJavaTimeZone().getOffset(millis);
    }

    public DstRule getDaylightStartRule() {
        return this.isJavaTimeZone ? this.jzoneStartRule : this.fixedStartRule;
    }

    public DstRule getDaylightEndRule() {
        return this.isJavaTimeZone ? this.jzoneEndRule : this.fixedEndRule;
    }

    public TimeZone getJavaTimeZone() {
        return (TimeZone)this.tzSupport();
    }

    public Object tzSupport() {
        if (this.jzone == null) {
            if (this.fixedDstDelta == 0) {
                this.jzone = new SimpleTimeZone(this.fixedUtcOffset, this.id);
            } else {
                int rawOffset = this.fixedUtcOffset;
                int dstAdjustment = this.fixedDstDelta;
                DstRule startRuleWall = this.fixedStartRule.asWallTimeRule(0, this);
                if (startRuleWall != null) {
                    int startDayOfWeek;
                    int startDay;
                    int startMonth = startRuleWall.getMonth().getOrdinal();
                    int startTime = (int)startRuleWall.getTime().getTimeOfDayMillis();
                    if (startRuleWall.getDayMode() == 0) {
                        startDay = startRuleWall.getDay();
                        startDayOfWeek = 0;
                    } else if (startRuleWall.getDayMode() == -1) {
                        startDayOfWeek = startRuleWall.getWeekday().getOrdinal() + 1;
                        if (startRuleWall.getWeek() == 5) {
                            startDay = -1;
                        } else {
                            startDay = startRuleWall.getWeek() * 7 + 1;
                            startDayOfWeek *= -1;
                        }
                    } else if (startRuleWall.getDayMode() == 2) {
                        startDay = -1 * startRuleWall.getDay();
                        startDayOfWeek = -1 * (startRuleWall.getWeekday().getOrdinal() + 1);
                    } else {
                        startDay = startRuleWall.getDay();
                        startDayOfWeek = -1 * (startRuleWall.getWeekday().getOrdinal() + 1);
                    }
                    DstRule endRuleWall = this.fixedEndRule.asWallTimeRule(1, this);
                    if (endRuleWall != null) {
                        int endDayOfWeek;
                        int endDay;
                        int endMonth = endRuleWall.getMonth().getOrdinal();
                        int endTime = (int)endRuleWall.getTime().getTimeOfDayMillis();
                        if (endRuleWall.getDayMode() == 0) {
                            endDay = endRuleWall.getDay();
                            endDayOfWeek = 0;
                        } else if (endRuleWall.getDayMode() == -1) {
                            endDayOfWeek = endRuleWall.getWeekday().getOrdinal() + 1;
                            if (endRuleWall.getWeek() == 5) {
                                endDay = -1;
                            } else {
                                endDay = endRuleWall.getWeek() * 7 + 1;
                                endDayOfWeek *= -1;
                            }
                        } else if (endRuleWall.getDayMode() == 2) {
                            endDay = -1 * endRuleWall.getDay();
                            endDayOfWeek = -1 * (endRuleWall.getWeekday().getOrdinal() + 1);
                        } else {
                            endDay = endRuleWall.getDay();
                            endDayOfWeek = -1 * (endRuleWall.getWeekday().getOrdinal() + 1);
                        }
                        try {
                            this.jzone = new SimpleTimeZone(rawOffset, this.id, startMonth, startDay, startDayOfWeek, startTime, endMonth, endDay, endDayOfWeek, endTime, dstAdjustment);
                        }
                        catch (IllegalArgumentException iae) {
                            System.out.println("rawOffset=" + rawOffset);
                            System.out.println("id=" + this.id);
                            System.out.println("startMonth=" + startMonth);
                            System.out.println("startDay=" + startDay);
                            System.out.println("startDayOfWeek=" + startDayOfWeek);
                            System.out.println("startTime=" + startTime);
                            System.out.println("endMonth=" + endMonth);
                            System.out.println("endDay=" + endDay);
                            System.out.println("endDayOfWeek=" + endDayOfWeek);
                            System.out.println("endTime=" + endTime);
                            System.out.println("dstSavings=" + dstAdjustment);
                            iae.printStackTrace();
                        }
                    }
                }
            }
            if (this.jzone == null) {
                this.jzone = new Support();
            }
        }
        return this.jzone;
    }

    @Override
    public BIDataValue toDataValue() {
        return this;
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        try {
            DstRule RHSEnd;
            DstRule RHSStart;
            long RHSAdj;
            long RHSUtc;
            DstRule thisEnd;
            DstRule thisStart;
            long thisAdj;
            long thisUtc;
            if (!(o instanceof BTimeZone)) {
                return false;
            }
            BTimeZone tz = (BTimeZone)o;
            if (this.isJavaTimeZone) {
                thisUtc = this.jzone.getRawOffset();
                thisAdj = this.jzone.getDSTSavings();
                thisStart = this.jzoneStartRule;
                thisEnd = this.jzoneEndRule;
            } else {
                thisAdj = this.fixedDstDelta;
                thisUtc = this.fixedUtcOffset;
                thisStart = this.fixedStartRule;
                thisEnd = this.fixedEndRule;
            }
            if (tz.isJavaTimeZone) {
                RHSUtc = tz.jzone.getRawOffset();
                RHSAdj = tz.jzone.getDSTSavings();
                RHSStart = tz.jzoneStartRule;
                RHSEnd = tz.jzoneEndRule;
            } else {
                RHSAdj = tz.fixedDstDelta;
                RHSUtc = tz.fixedUtcOffset;
                RHSStart = tz.fixedStartRule;
                RHSEnd = tz.fixedEndRule;
            }
            return tz.id.equals(this.id) && RHSUtc == thisUtc && RHSAdj == thisAdj && DstRule.equals(RHSStart, thisStart) && DstRule.equals(RHSEnd, thisEnd);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean isEquivalent(BTimeZone tz) {
        DstRule RHSEnd;
        DstRule RHSStart;
        int RHSAdj;
        int RHSUtc;
        DstRule thisEnd;
        DstRule thisStart;
        int thisAdj;
        int thisUtc;
        if (this.isJavaTimeZone) {
            thisUtc = this.jzone.getRawOffset();
            thisAdj = this.jzone.getDSTSavings();
            thisStart = this.jzoneStartRule;
            thisEnd = this.jzoneEndRule;
        } else {
            thisAdj = this.fixedDstDelta;
            thisUtc = this.fixedUtcOffset;
            thisStart = this.fixedStartRule;
            thisEnd = this.fixedEndRule;
        }
        if (tz.isJavaTimeZone) {
            RHSUtc = tz.jzone.getRawOffset();
            RHSAdj = tz.jzone.getDSTSavings();
            RHSStart = tz.jzoneStartRule;
            RHSEnd = tz.jzoneEndRule;
        } else {
            RHSAdj = tz.fixedDstDelta;
            RHSUtc = tz.fixedUtcOffset;
            RHSStart = tz.fixedStartRule;
            RHSEnd = tz.fixedEndRule;
        }
        return RHSUtc == thisUtc && RHSAdj == thisAdj && DstRule.isEquivalent(RHSStart, thisStart, this, 0) && DstRule.isEquivalent(RHSEnd, thisEnd, this, 1);
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        int thisAdj = 0;
        int thisUtc = 0;
        DstRule thisStart = null;
        DstRule thisEnd = null;
        out.writeUTF(this.id);
        if (this.isJavaTimeZone) {
            thisUtc = this.jzone.getRawOffset();
            thisAdj = this.jzone.getDSTSavings();
            thisStart = this.jzoneStartRule;
            thisEnd = this.jzoneEndRule;
        } else {
            thisUtc = this.fixedUtcOffset;
            thisAdj = this.fixedDstDelta;
            thisStart = this.fixedStartRule;
            thisEnd = this.fixedEndRule;
        }
        out.writeInt(thisUtc);
        out.writeInt(thisAdj);
        out.writeBoolean(thisStart != null);
        if (thisStart != null) {
            thisStart.encode(out);
        }
        out.writeBoolean(thisEnd != null);
        if (thisEnd != null) {
            thisEnd.encode(out);
        }
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        String id = in.readUTF();
        int utcOffset = in.readInt();
        int dstDelta = in.readInt();
        DstRule startRule = in.readBoolean() ? DstRule.decode(in) : null;
        DstRule endRule = in.readBoolean() ? DstRule.decode(in) : null;
        return BTimeZone.make(id, id, id, id, id, utcOffset, dstDelta, startRule, endRule);
    }

    @Override
    public String encodeToString() throws IOException {
        if (this.stringEncoding == null) {
            StringBuilder s = new StringBuilder(128);
            int thisAdj = 0;
            int thisUtc = 0;
            DstRule thisStart = null;
            DstRule thisEnd = null;
            if (this.isJavaTimeZone) {
                thisUtc = this.jzone.getRawOffset();
                thisAdj = this.jzone.getDSTSavings();
                thisStart = this.jzoneStartRule;
                thisEnd = this.jzoneEndRule;
            } else {
                thisUtc = this.fixedUtcOffset;
                thisAdj = this.fixedDstDelta;
                thisStart = this.fixedStartRule;
                thisEnd = this.fixedEndRule;
            }
            s.append(this.id);
            s.append(';');
            s.append(thisUtc);
            s.append(';');
            s.append(thisAdj);
            s.append(';');
            s.append(thisStart != null ? thisStart.encodeToString() : "null");
            s.append(';');
            s.append(thisEnd != null ? thisEnd.encodeToString() : "null");
            this.stringEncoding = s.toString();
        }
        return this.stringEncoding;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        StringTokenizer t = new StringTokenizer(s, ";");
        String id = t.nextToken();
        if (!t.hasMoreTokens()) {
            return BTimeZone.getTimeZone(id);
        }
        int utcOffset = Integer.parseInt(t.nextToken());
        int dstDelta = Integer.parseInt(t.nextToken());
        String rule = t.nextToken();
        DstRule startRule = !rule.equals("null") ? DstRule.decodeFromString(rule) : null;
        rule = t.nextToken();
        DstRule endRule = !rule.equals("null") ? DstRule.decodeFromString(rule) : null;
        return BTimeZone.make(id, id, id, id, id, utcOffset, dstDelta, startRule, endRule);
    }

    @Override
    public String toString(Context cx) {
        int thisAdj;
        int thisUtc;
        if (this.isJavaTimeZone) {
            thisUtc = this.jzone.getRawOffset();
            thisAdj = this.jzone.getDSTSavings();
        } else {
            thisUtc = this.fixedUtcOffset;
            thisAdj = this.fixedDstDelta;
        }
        long utcOffsetHours = (long)thisUtc / 3600000L;
        long buffer = (long)thisUtc % 3600000L;
        long utcOffsetMinutes = Math.abs(buffer / 60000L);
        StringBuilder result = new StringBuilder(this.getId());
        result.append(" (");
        if (thisUtc >= 0) {
            result.append("+");
        }
        result.append(String.valueOf(utcOffsetHours));
        if (utcOffsetMinutes != 0L) {
            result.append(":");
            if (utcOffsetMinutes < 10L) {
                result.append("0");
            }
            result.append(String.valueOf(utcOffsetMinutes));
        }
        if (thisAdj != 0) {
            result.append("/");
            if (thisUtc + thisAdj >= 0) {
                result.append("+");
            }
            long daylightOffsetHours = (long)(thisUtc + thisAdj) / 3600000L;
            buffer = (long)(thisUtc + thisAdj) % 3600000L;
            long daylightOffsetMinutes = Math.abs(buffer / 60000L);
            result.append(String.valueOf(daylightOffsetHours));
            if (daylightOffsetMinutes != 0L) {
                result.append(":");
                if (daylightOffsetMinutes < 10L) {
                    result.append("0");
                }
                result.append(String.valueOf(daylightOffsetMinutes));
            }
        }
        result.append(")");
        return result.toString();
    }

    public boolean isJavaTimeZone() {
        return this.isJavaTimeZone;
    }

    public static TimeZone getJavaUTCInstance() {
        if (JAVA_UTC == null) {
            JAVA_UTC = TimeZone.getTimeZone("UTC");
        }
        return JAVA_UTC;
    }

    public static BTimeZone getLocal() {
        return localTimeZone;
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        logger = Logger.getLogger("timezone");
        TimeZoneDatabase.get();
        String loadProp = AccessController.doPrivileged(() -> System.getProperty("timezonedb.load", "true"));
        if (loadProp.equals("true")) {
            TimeZone defaultZone = TimeZone.getDefault();
            boolean olsonSupport = false;
            for (String id : TimeZone.getAvailableIDs()) {
                if (!defaultZone.getID().equals(id)) continue;
                olsonSupport = true;
                break;
            }
            if (!olsonSupport) {
                if (defaultZone.hasSameRules(TimeZone.getTimeZone("UTC"))) {
                    defaultZone = TimeZone.getTimeZone("UTC");
                } else {
                    TimeZone olsonEquivalent = null;
                    for (String currentId : TimeZone.getAvailableIDs()) {
                        if (!defaultZone.hasSameRules(TimeZone.getTimeZone(currentId))) continue;
                        olsonEquivalent = TimeZone.getTimeZone(currentId);
                        break;
                    }
                    if (olsonEquivalent != null) {
                        logger.warning("JVM Default Time Zone \"" + defaultZone + "\" not supported by TZDB, using TZDB equivalent  \"" + olsonEquivalent + "\"");
                        defaultZone = olsonEquivalent;
                    } else {
                        logger.warning("JVM Default Time Zone \"" + defaultZone + "\" not supported by TZDB");
                    }
                }
            }
            try {
                localTimeZone = BTimeZone.getTimeZone(defaultZone.getID());
            }
            catch (TimeZoneException e) {
                e.printStackTrace();
                logger.warning("Error occurred obtaining JVM Time Zone \"" + defaultZone.getID() + "\", approximating value");
                localTimeZone = BTimeZone.make(TimeZone.getDefault().getID(), TimeZone.getDefault().getOffset(System.currentTimeMillis()));
            }
        } else {
            logger.warning("timezonedb.load=false, Using UTC for local timezone.");
            localTimeZone = BTimeZone.makeIgnoringCache("UTC", 0);
        }
        OFFSET_COMPARATOR = (t1, t2) -> {
            if (t1.getUtcOffset() == t2.getUtcOffset()) {
                return t1.getId().compareTo(t2.getId());
            }
            if (t1.getUtcOffset() < t2.getUtcOffset()) {
                return -1;
            }
            return 1;
        };
        TYPE = Sys.loadType(BTimeZone.class);
    }

    private class Support
    extends TimeZone {
        private Support() {
        }

        @Override
        public String getDisplayName(boolean daylight, int style, Locale locale) {
            if (style == 0) {
                return BTimeZone.this.getShortDisplayName(daylight, null);
            }
            return BTimeZone.this.getDisplayName(daylight, null);
        }

        @Override
        public String getID() {
            return BTimeZone.this.id;
        }

        @Override
        public int getRawOffset() {
            return BTimeZone.this.getUtcOffset();
        }

        @Override
        public boolean useDaylightTime() {
            return BTimeZone.this.getDaylightAdjustment() != 0;
        }

        @Override
        public int getDSTSavings() {
            return BTimeZone.this.getDaylightAdjustment();
        }

        @Override
        public int getOffset(long date) {
            int thisUtc = BTimeZone.this.fixedUtcOffset;
            int thisAdj = BTimeZone.this.fixedDstDelta;
            if (thisAdj == 0) {
                return thisUtc;
            }
            if (this.inDaylightTime(new Date(date))) {
                return thisUtc + thisAdj;
            }
            return thisUtc;
        }

        @Override
        public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
            GregorianCalendar cal = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
            cal.clear();
            cal.set(0, era);
            cal.set(year, month, day);
            int thisUtc = BTimeZone.this.fixedUtcOffset;
            int thisAdj = BTimeZone.this.fixedDstDelta;
            long targetTime = cal.getTimeInMillis() + (long)milliseconds - (long)BTimeZone.this.fixedUtcOffset;
            if (thisAdj == 0) {
                return thisUtc;
            }
            if (this.inDaylightTime(new Date(targetTime))) {
                return thisUtc + thisAdj;
            }
            return thisUtc;
        }

        @Override
        public boolean hasSameRules(TimeZone other) {
            if (other instanceof Support) {
                ((Support)other).getBTimeZone().isEquivalent(this.getBTimeZone());
            }
            return false;
        }

        @Override
        public boolean inDaylightTime(Date date) {
            if (BTimeZone.this.fixedStartRule == null || BTimeZone.this.fixedEndRule == null) {
                return false;
            }
            GregorianCalendar cal = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
            cal.clear();
            cal.setTime(date);
            DstRule startRule = BTimeZone.this.getDaylightStartRule();
            if (startRule == null) {
                return false;
            }
            BAbsTime daylightStart = startRule.getTime(cal.get(1), BTimeZone.this, 0);
            if (daylightStart.isNull()) {
                return false;
            }
            DstRule endRule = BTimeZone.this.getDaylightEndRule();
            if (endRule == null) {
                return false;
            }
            BAbsTime daylightEnd = endRule.getTime(cal.get(1), BTimeZone.this, 1);
            if (daylightEnd.isNull()) {
                return false;
            }
            if (daylightStart.getMillis() < daylightEnd.getMillis()) {
                return date.getTime() >= daylightStart.getMillis() && date.getTime() < daylightEnd.getMillis();
            }
            return date.getTime() >= daylightStart.getMillis() || date.getTime() < daylightEnd.getMillis();
        }

        @Override
        public void setID(String ID) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRawOffset(int offsetMillis) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            try {
                return BTimeZone.this.encodeToString();
            }
            catch (IOException e) {
                return null;
            }
        }

        private BTimeZone getBTimeZone() {
            return BTimeZone.this;
        }
    }
}

