/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.TagDictionaryService;

public class ImpliedRelations
implements Relations {
    private final TagDictionaryService service;
    private final Entity entity;

    public ImpliedRelations(TagDictionaryService service, Entity entity) {
        this.service = service;
        this.entity = entity;
    }

    private static RuntimeException immutable() {
        return new UnsupportedOperationException("Immutable Relation set");
    }

    @Override
    public Collection<Relation> set(Id id, Collection<? extends Entity> endpoints) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public Collection<Relation> set(Id id, Collection<? extends Entity> endpoints, boolean isInbound) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public Relation set(Id id, Entity endpoint) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public Relation add(Relation relation) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public Relation add(Id id, Entity endpoint) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public Relation add(Id id, Entity endpoint, boolean isInbound) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public Collection<Relation> add(Id id, Collection<? extends Entity> endpoints) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public Collection<Relation> add(Id id, Collection<? extends Entity> endpoints, boolean isInbound) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public boolean remove(Relation relation) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public boolean remove(Id id, Entity endpoint) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public boolean removeAll(Id id) {
        throw ImpliedRelations.immutable();
    }

    @Override
    public Collection<Relation> filter(Predicate<Relation> condition, int direction) {
        ArrayList<Relation> result = new ArrayList<Relation>();
        for (Relation relation : this) {
            if (!condition.test(relation) || !ImpliedRelations.isMatchingDirection(relation, direction)) continue;
            result.add(relation);
        }
        return result;
    }

    @Override
    public Collection<Relation> getAll() {
        ArrayList<Relation> result = new ArrayList<Relation>();
        this.service.addAllImpliedRelations(this.entity, result);
        return result;
    }

    @Override
    public Optional<Relation> get(Id id) {
        return this.service.getImpliedRelation(id, this.entity);
    }

    @Override
    public Optional<Relation> get(Id id, int direction) {
        for (Relation relation : this.getAll(id)) {
            if (!ImpliedRelations.isMatchingDirection(relation, direction)) continue;
            return Optional.of(relation);
        }
        return Optional.empty();
    }

    @Override
    public Collection<Relation> getAll(Id id) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        this.service.addImpliedRelations(id, this.entity, relations);
        return relations;
    }

    @Override
    public Collection<Relation> getAll(Id id, int direction) {
        ArrayList<Relation> result = new ArrayList<Relation>();
        for (Relation relation : this.getAll(id)) {
            if (!ImpliedRelations.isMatchingDirection(relation, direction)) continue;
            result.add(relation);
        }
        return result;
    }

    @Override
    public Optional<Relation> get(Id id, Entity endpoint) {
        for (Relation relation : this.getAll(id)) {
            if (!relation.getEndpoint().equals(endpoint)) continue;
            return Optional.of(relation);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Relation> get(Id id, Entity endpoint, int direction) {
        for (Relation relation : this.getAll(id)) {
            if (!relation.getEndpoint().equals(endpoint) || !ImpliedRelations.isMatchingDirection(relation, direction)) continue;
            return Optional.of(relation);
        }
        return Optional.empty();
    }

    @Override
    public Iterator<Relation> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public static boolean isMatchingDirection(Relation relation, int direction) {
        return direction == 3 || direction == 1 && relation.isInbound() || direction == 2 && relation.isOutbound();
    }
}

