/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag.util;

import java.util.Objects;
import java.util.Optional;
import javax.baja.naming.BOrd;
import javax.baja.tag.Entity;
import javax.baja.tag.Relations;
import javax.baja.tag.Tags;
import javax.baja.tag.util.RelationSet;
import javax.baja.tag.util.TagSet;

public class BasicEntity
implements Entity {
    private final BOrd ord;
    private final Tags tags;
    private final Relations relations;

    public BasicEntity() {
        this(null);
    }

    public BasicEntity(BOrd ord) {
        this(ord, new TagSet());
    }

    public BasicEntity(BOrd ord, Tags tags) {
        this(ord, tags, new RelationSet());
    }

    public BasicEntity(BOrd ord, Tags tags, Relations relations) {
        Objects.requireNonNull(tags);
        Objects.requireNonNull(relations);
        this.ord = ord;
        this.tags = tags;
        this.relations = relations;
    }

    @Override
    public Optional<BOrd> getOrdToEntity() {
        return Optional.ofNullable(this.ord);
    }

    @Override
    public Relations relations() {
        return this.relations;
    }

    @Override
    public Tags tags() {
        return this.tags;
    }

    public String toString() {
        return "BasicEntity; ord: " + (this.ord != null ? this.ord : BOrd.NULL);
    }
}

