/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.Objects;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BMarker;
import javax.baja.sys.BString;
import javax.baja.tag.Id;

public final class Tag {
    private final Id id;
    private final BIDataValue value;

    public static Tag newTag(String qname) {
        return new Tag(qname, (BIDataValue)BMarker.MARKER);
    }

    public static Tag newTag(String qname, String value) {
        return new Tag(qname, (BIDataValue)BString.make(value));
    }

    public static Tag newTag(String qname, int value) {
        return new Tag(qname, (BIDataValue)BInteger.make(value));
    }

    public static Tag newTag(String qname, float value) {
        return new Tag(qname, (BIDataValue)BFloat.make(value));
    }

    public static Tag newTag(String qname, long value) {
        return new Tag(qname, (BIDataValue)BLong.make(value));
    }

    public static Tag newTag(String qname, double value) {
        return new Tag(qname, (BIDataValue)BDouble.make(value));
    }

    public static Tag newTag(String qname, boolean value) {
        return new Tag(qname, (BIDataValue)BBoolean.make(value));
    }

    public Tag(String qname, BIDataValue value) {
        this(Id.newId(qname), value);
    }

    public Tag(Id id, BIDataValue value) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(value);
        this.id = id;
        this.value = value;
    }

    public Id getId() {
        return this.id;
    }

    public BIDataValue getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (!this.id.equals(tag.id)) {
            return false;
        }
        return this.value.equals(tag.value);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

