/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relations;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;

public class EntityWrapper
implements Entity {
    private Tags tags;
    private Entity entity;

    public EntityWrapper(Entity entity, BFacets facets) {
        this.entity = entity;
        this.tags = new FacetTags(entity == null ? null : entity.tags(), facets);
    }

    @Override
    public Optional<BOrd> getOrdToEntity() {
        if (this.entity == null) {
            return Optional.empty();
        }
        return this.entity.getOrdToEntity();
    }

    @Override
    public Tags tags() {
        return this.tags;
    }

    @Override
    public Relations relations() {
        return this.entity.relations();
    }

    private class FacetTags
    implements Tags {
        private Tags entityTags;
        private BFacets facets;

        public FacetTags(Tags entityTags, BFacets facets) {
            this.entityTags = entityTags;
            this.facets = facets;
        }

        @Override
        public boolean isEmpty() {
            return (this.entityTags == null || this.entityTags.isEmpty()) && this.facets.isEmpty();
        }

        @Override
        public boolean contains(Id id) {
            return this.entityTags != null && this.entityTags.contains(id) || this.facets.get(Id.idToFacetKey(id)) != null;
        }

        @Override
        public boolean isMulti(Id id) {
            return false;
        }

        @Override
        public boolean set(Tag tag) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public boolean set(Id id, BIDataValue value) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public boolean setMulti(Id id, Collection<? extends BIDataValue> values) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public boolean addMulti(Id id, Collection<? extends BIDataValue> values) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public boolean addMulti(Tag tag) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public boolean addMulti(Id id, BIDataValue value) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public boolean merge(Collection<Tag> tags) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public boolean remove(Id id, BIDataValue value) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public boolean removeAll(Id id) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public boolean remove(Tag tag) {
            throw new UnsupportedOperationException("The tag set is readonly.");
        }

        @Override
        public Collection<Tag> filter(Predicate<Tag> condition) {
            ArrayList<Tag> result = new ArrayList<Tag>();
            for (Tag t : this.getAll()) {
                if (!condition.test(t)) continue;
                result.add(t);
            }
            return result;
        }

        @Override
        public Collection<Tag> getAll() {
            HashMap<Id, Tag> map = new HashMap<Id, Tag>();
            if (this.entityTags != null) {
                for (Tag t : this.entityTags.getAll()) {
                    map.put(t.getId(), t);
                }
            }
            if (!this.facets.isEmpty()) {
                String[] keys = this.facets.list();
                for (int k = 0; k < keys.length; ++k) {
                    Id facetId = Id.facetKeyToId(keys[k]);
                    map.put(Id.facetKeyToId(keys[k]), new Tag(facetId, (BIDataValue)((Object)this.facets.get(keys[k]))));
                }
            }
            return map.values();
        }

        @Override
        public Optional<BIDataValue> get(Id id) {
            BIDataValue value;
            if (!this.facets.isEmpty() && (value = (BIDataValue)((Object)this.facets.get(Id.idToFacetKey(id)))) != null) {
                return Optional.of(value);
            }
            if (this.entityTags == null) {
                return Optional.empty();
            }
            return this.entityTags.get(id);
        }

        @Override
        public Collection<BIDataValue> getValues(Id id) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

