/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.text.MessageFormat;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.util.Lexicon;

public class LocalizableException
extends BajaException
implements Localizable {
    private String lexiconModule;
    private String lexiconKey;
    private Object[] lexiconArgs;

    public LocalizableException(String lexiconModule, String lexiconKey, Object[] lexiconArgs, Throwable cause) {
        super(LocalizableException.format(lexiconModule, lexiconKey, lexiconArgs, null), cause);
        this.lexiconModule = lexiconModule;
        this.lexiconKey = lexiconKey;
        this.lexiconArgs = lexiconArgs;
    }

    public LocalizableException(String lexiconModule, String lexiconKey, Object[] lexiconArgs) {
        this(lexiconModule, lexiconKey, lexiconArgs, null);
    }

    public LocalizableException(String lexiconModule, String lexiconKey, Throwable cause) {
        this(lexiconModule, lexiconKey, null, cause);
    }

    public LocalizableException(String lexiconModule, String lexiconKey) {
        this(lexiconModule, lexiconKey, null, null);
    }

    public LocalizableException(Lexicon lexicon, String lexiconKey) {
        this(lexicon.module.getModuleName(), lexiconKey, null, null);
    }

    public String getLexiconModule() {
        return this.lexiconModule;
    }

    public String getLexiconKey() {
        return this.lexiconKey;
    }

    public Object[] getLexiconArguments() {
        return this.lexiconArgs;
    }

    @Override
    public String toString(Context context) {
        return LocalizableException.format(this.lexiconModule, this.lexiconKey, this.lexiconArgs, context);
    }

    public static String format(String lexiconModule, String lexiconKey, Object[] lexiconArgs, Context context) {
        try {
            String value = Lexicon.make(lexiconModule, context).get(lexiconKey, null);
            if (value != null) {
                return MessageFormat.format(value, lexiconArgs);
            }
            StringBuffer s = new StringBuffer(lexiconKey);
            if (lexiconArgs != null) {
                s.append(" {");
                for (int i = 0; i < lexiconArgs.length; ++i) {
                    if (i > 0) {
                        s.append(", ");
                    }
                    s.append(lexiconArgs[i]);
                }
                s.append(" }");
            }
            return s.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return lexiconKey;
        }
    }
}

