/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public final class BWeekday
extends BFrozenEnum {
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final BWeekday sunday = new BWeekday(0);
    public static final BWeekday monday = new BWeekday(1);
    public static final BWeekday tuesday = new BWeekday(2);
    public static final BWeekday wednesday = new BWeekday(3);
    public static final BWeekday thursday = new BWeekday(4);
    public static final BWeekday friday = new BWeekday(5);
    public static final BWeekday saturday = new BWeekday(6);
    public static final Type TYPE = Sys.loadType(BWeekday.class);
    public static final BWeekday DEFAULT = sunday;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BWeekday make(int ordinal) {
        return (BWeekday)sunday.getRange().get(ordinal, false);
    }

    public static BWeekday make(String tag) {
        return (BWeekday)sunday.getRange().get(tag);
    }

    private BWeekday(int ordinal) {
        super(ordinal);
    }

    public static BWeekday getFirstDayOfWeek(Context cx) {
        Lexicon lex = Lexicon.make(TYPE.getModule(), cx);
        String tag = lex.get("weekday.firstDayOfWeek", null);
        if (tag == null) {
            return sunday;
        }
        return BWeekday.make(tag);
    }

    public String getShortDisplayTag(Context cx) {
        return Lexicon.make(Sys.getBajaModule(), cx).getText(this.getTag() + ".short");
    }

    public BWeekday next() {
        int ord = this.getOrdinal();
        ord = (ord + 1) % 7;
        return BWeekday.make(ord);
    }

    public BWeekday previous() {
        int ord = this.getOrdinal();
        if (--ord == -1) {
            ord = 6;
        }
        return BWeekday.make(ord);
    }
}

