/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.schema.SimpleType;
import com.tridium.sys.station.Station;
import javax.baja.agent.AgentList;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BServiceContainer;

public final class BStation
extends BComponent {
    public static final Property stationName = BStation.newProperty(257, "", null);
    public static final Property sysInfo = BStation.newProperty(0, BFacets.DEFAULT, null);
    public static final Property Services = BStation.newProperty(0, new BServiceContainer(), null);
    public static final Action save = BStation.newAction(0, null);
    public static final Type TYPE = Sys.loadType(BStation.class);
    private static final BIcon icon = BIcon.std("navOnly/systemDbService.png");

    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    public BFacets getSysInfo() {
        return (BFacets)this.get(sysInfo);
    }

    public void setSysInfo(BFacets v) {
        this.set(sysInfo, (BValue)v, null);
    }

    public BServiceContainer getServices() {
        return (BServiceContainer)this.get(Services);
    }

    public void setServices(BServiceContainer v) {
        this.set(Services, (BValue)v, null);
    }

    public void save() {
        this.invoke(save, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void doSave(Context cx) throws Exception {
        Station.saveAsync(cx);
    }

    public String getStationDisplayName(Context cx) {
        BValue displayName = this.get("displayName");
        if (displayName == null) {
            return this.getStationName();
        }
        if (displayName instanceof BString) {
            String val = ((BString)displayName).getString();
            if (val.isEmpty()) {
                return null;
            }
            return val;
        }
        if (displayName instanceof BFormat) {
            BFormat format = (BFormat)displayName;
            if (format.getFormat().isEmpty()) {
                return null;
            }
            try {
                String val = format.format(this, cx);
                if (val.isEmpty()) {
                    return null;
                }
                return val;
            }
            catch (Exception ex) {
                return "Error: " + ex.getClass().getName() + ": " + ex.getMessage();
            }
        }
        return "Error: displayName must be one of { BString, BFormat }";
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public final boolean isParentLegal(BComponent parent) {
        return false;
    }

    @Override
    public void changed(Property property, Context cx) {
        if (this.isRunning() && property.equals(sysInfo)) {
            this.checkInternFacet();
        }
        super.changed(property, cx);
    }

    @Override
    public void started() throws Exception {
        this.checkInternFacet();
        super.started();
    }

    private void checkInternFacet() {
        boolean internDisabled = this.getSysInfo().getb("disableSimpleIntern", SimpleType.internDisabledOnVm);
        SimpleType.setInterningEnabled(!internDisabled);
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toBottom("wbutil:MetadataBrowser");
        return list;
    }
}

