/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.tag.RelationTags;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tags;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="relationId", type="BString", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"workbench:RelationIdFE\"")}), @NiagaraProperty(name="inbound", type="boolean", flags=5, defaultValue="false"), @NiagaraProperty(name="relationTags", type="BFacets", defaultValue="BFacets.NULL"), @NiagaraProperty(name="sourceOrd", type="BOrd", defaultValue="BOrd.NULL")})
public class BRelation
extends BStruct
implements Relation {
    public static final Property relationId = BRelation.newProperty(0, "", BFacets.make("fieldEditor", "workbench:RelationIdFE"));
    public static final Property inbound = BRelation.newProperty(5, false, null);
    public static final Property relationTags = BRelation.newProperty(0, BFacets.NULL, null);
    public static final Property sourceOrd = BRelation.newProperty(0, BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BRelation.class);
    protected BComponent direct;
    protected BComponent indirect;
    private boolean active;
    private RelationKnob relationKnob;

    public String getRelationId() {
        return this.getString(relationId);
    }

    public void setRelationId(String v) {
        this.setString(relationId, v, null);
    }

    public boolean getInbound() {
        return this.getBoolean(inbound);
    }

    public void setInbound(boolean v) {
        this.setBoolean(inbound, v, null);
    }

    public BFacets getRelationTags() {
        return (BFacets)this.get(relationTags);
    }

    public void setRelationTags(BFacets v) {
        this.set(relationTags, (BValue)v, null);
    }

    public BOrd getSourceOrd() {
        return (BOrd)this.get(sourceOrd);
    }

    public void setSourceOrd(BOrd v) {
        this.set(sourceOrd, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BRelation() {
    }

    public BRelation(Id id, BOrd endPoint) {
        this.setRelationId(id.getQName());
        this.setEndpointOrd(endPoint);
    }

    public BRelation(Id id, BComponent endPoint) {
        this.setRelationId(id.getQName());
        this.direct = endPoint;
    }

    public BRelation(Id id, BComponent endPoint, boolean isInbound) {
        this.setRelationId(id.getQName());
        this.direct = endPoint;
        this.setInbound(isInbound);
    }

    @Override
    public boolean isInbound() {
        return this.getInbound();
    }

    @Override
    public boolean isOutbound() {
        return !this.getInbound();
    }

    @Override
    public BOrd getEndpointOrd() {
        return (BOrd)this.get(sourceOrd);
    }

    public void setEndpointOrd(BOrd v) {
        this.set(sourceOrd, (BValue)v, null);
    }

    @Override
    public Id getId() {
        return Id.newId(this.getRelationId());
    }

    @Override
    public Entity getEndpoint() {
        if (this.direct != null) {
            return this.direct;
        }
        if (!this.active) {
            this.activateRelation();
        }
        return this.indirect;
    }

    public BComponent getRelationComponent() {
        return (BComponent)this.getParent();
    }

    @Override
    public Tags tags() {
        return new RelationTags(this);
    }

    @Override
    public String toString(Context context) {
        String s = "null";
        BComponent sc = null;
        try {
            sc = this.getParent().asComponent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sc != null) {
            SlotPath sp = sc.getSlotPath();
            s = sp == null ? sc.toString() : sp.toString();
        }
        String t = this.direct != null ? "Direct: " + this.direct.toDebugString() : "Indirect: " + this.getEndpointOrd();
        String dir = " (OUT) ";
        if (this.isInbound()) {
            dir = " (IN) ";
        }
        return dir + s + "-<" + this.getRelationId() + ">-" + t;
    }

    public final boolean isDirect() {
        return this.direct != null;
    }

    public final boolean isIndirect() {
        return this.direct == null;
    }

    public final void activateRelation() {
        if (this.active) {
            return;
        }
        BComponent thisEndpoint = (BComponent)this.getParent();
        if (thisEndpoint == null) {
            throw new IllegalStateException("not mounted in component");
        }
        BComponent endPoint = this.isDirect() ? this.direct : this.resolve();
        this.active = true;
        this.relationKnob = ((ComponentSlotMap)endPoint.getSlotMap()).installRelationKnob(this);
    }

    public final void deactivateRelation() {
        if (!this.active) {
            return;
        }
        try {
            BComponent endpoint = (BComponent)this.getEndpoint();
            if (endpoint != null) {
                ((ComponentSlotMap)endpoint.getSlotMap()).uninstallRelationKnob(this);
            }
        }
        finally {
            this.active = false;
            this.relationKnob = null;
        }
    }

    public RelationKnob getRelationKnob() {
        return this.relationKnob;
    }

    private BComponent resolve() {
        return this.resolve(this.getParentComponent());
    }

    private BComponent resolve(BObject base) {
        this.indirect = null;
        try {
            BObject obj = this.getEndpointOrd().resolve(base).get();
            if (!(obj instanceof BComponent)) {
                throw new BajaRuntimeException("Target ord must resolve to a component");
            }
            this.indirect = (BComponent)obj;
        }
        catch (UnresolvedException e) {
            throw new UnresolvedException("Cannot resolve source component");
        }
        return this.indirect;
    }
}

