/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.schema.ComponentSlotMap;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIUnlinkableSource;
import javax.baja.sys.BIUnlinkableTarget;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public class BLink
extends BRelation {
    public static final Property relationId = BLink.newProperty(5, "n:dataLink", null);
    public static final Property relationTags = BLink.newProperty(5, BFacets.NULL, null);
    public static final Property inbound = BLink.newProperty(5, true, null);
    public static final Property sourceOrd = BLink.newProperty(0, BOrd.NULL, BFacets.make("targetType", "baja:Component"));
    public static final Property sourceSlotName = BLink.newProperty(0, "");
    public static final Property targetSlotName = BLink.newProperty(0, "");
    public static final Property enabled = BLink.newProperty(0, true);
    private static final BIcon icon = BIcon.std("link.png");
    public static final Type TYPE = Sys.loadType(BLink.class);
    private static final Logger log = Logger.getLogger("sys.link");
    private static final Context SKIP_CRITICAL_CX = BDataRecoveryComponentRecorder.SKIP_CRITICAL_CX;
    private Slot sourceSlot;
    private Slot targetSlot;
    private boolean active;
    private Knob knob;
    private boolean fatalFault = false;

    public BLink(BOrd sourceOrd, String sourceSlot, String targetSlot, boolean enabled) {
        this.setSourceOrd(sourceOrd);
        this.setSourceSlotName(sourceSlot);
        this.setTargetSlotName(targetSlot);
        this.setEnabled(enabled);
    }

    public BLink(BComponent source, Slot sourceSlot, Slot targetSlot) {
        if (source.getSlot(sourceSlot.getName()) == null) {
            log.warning("No Such Slot: " + source.getType() + "." + sourceSlot.getName());
        }
        this.direct = source;
        this.setSourceSlotName(sourceSlot.getName());
        this.setTargetSlotName(targetSlot.getName());
        this.sourceSlot = sourceSlot;
        this.targetSlot = targetSlot;
    }

    public BLink() {
    }

    public final String getSourceSlotName() {
        return this.getString(sourceSlotName);
    }

    public final void setSourceSlotName(String name) {
        this.setString(sourceSlotName, name, null);
    }

    public final String getTargetSlotName() {
        return this.getString(targetSlotName);
    }

    public final void setTargetSlotName(String name) {
        this.setString(targetSlotName, name, null);
    }

    public final boolean isEnabled() {
        return this.getBoolean(enabled);
    }

    public final boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public final void setEnabled(boolean e) {
        this.setBoolean(enabled, e, null);
    }

    public final BComponent getSourceComponent() {
        if (this.direct != null) {
            return this.direct;
        }
        if (!this.active) {
            throw new UnresolvedException();
        }
        return this.indirect;
    }

    public final Slot getSourceSlot() {
        if (this.direct != null) {
            return this.sourceSlot;
        }
        if (!this.active) {
            throw new UnresolvedException();
        }
        return this.sourceSlot;
    }

    public final BComponent getTargetComponent() {
        return (BComponent)this.getParent();
    }

    public final Slot getTargetSlot() {
        if (this.direct != null) {
            return this.targetSlot;
        }
        if (!this.active) {
            throw new UnresolvedException();
        }
        return this.targetSlot;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final void activate() {
        if (BLink.runningInStation() && !Metrics.incrementLink()) {
            this.fatalFault = true;
            log.severe("Exceeded link limit for globalCapacity");
        }
        if (this.active) {
            return;
        }
        BComponent target = (BComponent)this.getParent();
        if (target == null) {
            throw new IllegalStateException("not mounted in component");
        }
        BComponent source = this.isDirect() ? this.direct : this.resolve();
        Slot targetSlot = target.getSlot(this.getTargetSlotName());
        if (targetSlot != null && LinkCheck.isInvalidSlotForLink(target, targetSlot, BIUnlinkableTarget.TYPE, null)) {
            String propType = targetSlot.isProperty() ? " (" + targetSlot.asProperty().getType() + ')' : "";
            log.warning("Link target is not allowed: " + target.toPathString() + '/' + targetSlot.getName() + propType);
            if (this.getParent().isComponent()) {
                this.getParent().asComponent().remove(this.getPropertyInParent());
            }
            return;
        }
        Slot sourceSlot = source.getSlot(this.getSourceSlotName());
        if (sourceSlot != null && LinkCheck.isInvalidSlotForLink(source, sourceSlot, BIUnlinkableSource.TYPE, null)) {
            String propType = sourceSlot.isProperty() ? " (" + sourceSlot.asProperty().getType() + ')' : "";
            log.warning("Link source is not allowed: " + source.toPathString() + '/' + sourceSlot.getName() + propType);
            if (this.getParent().isComponent()) {
                this.getParent().asComponent().remove(this.getPropertyInParent());
            }
            return;
        }
        try {
            this.active = true;
            this.knob = ((ComponentSlotMap)source.getSlotMap()).installKnob(this);
        }
        catch (RuntimeException e) {
            this.active = false;
            throw e;
        }
        finally {
            if (this.active) {
                try {
                    target.setFlags(targetSlot, target.getFlags(targetSlot) | 0x8000, SKIP_CRITICAL_CX);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            } else {
                this.recomputeSlotFlags(target, targetSlot);
            }
        }
        if (sourceSlot.isProperty() && targetSlot.isProperty()) {
            this.propagate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate() {
        if (!this.active) {
            return;
        }
        BComponent targetComp = null;
        Slot tSlot = null;
        try {
            try {
                tSlot = this.getTargetSlot();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.active) {
                ((ComponentSlotMap)this.getSourceComponent().getSlotMap()).uninstallKnob(this);
                targetComp = this.getTargetComponent();
                ((ComponentSlotMap)targetComp.getSlotMap()).deactivating(this);
            }
        }
        finally {
            this.active = false;
            this.knob = null;
            if (this.indirect != null) {
                this.indirect = null;
                this.sourceSlot = null;
                this.targetSlot = null;
            }
            this.recomputeSlotFlags(targetComp, tSlot);
        }
    }

    private void recomputeSlotFlags(BComponent comp, Slot slot) {
        if (comp == null) {
            return;
        }
        try {
            if (slot != null) {
                this.computeLinkTargetFlag(comp, slot);
            } else {
                SlotCursor<Slot> c = comp.getSlots();
                while (c.nextObject()) {
                    this.computeLinkTargetFlag(comp, c.slot());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void computeLinkTargetFlag(BComponent comp, Slot slot) {
        try {
            int flags = comp.getFlags(slot);
            BLink[] links = comp.getLinks(slot);
            int len = links != null ? links.length : 0;
            boolean activeLinkFound = false;
            for (int i = 0; i < len; ++i) {
                if (!links[i].isActive()) continue;
                activeLinkFound = true;
                break;
            }
            if (activeLinkFound) {
                comp.setFlags(slot, flags | 0x8000, SKIP_CRITICAL_CX);
            } else {
                comp.setFlags(slot, flags & 0xFFFF7FFF, SKIP_CRITICAL_CX);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public Knob getKnob() {
        if (!this.active) {
            throw new UnresolvedException();
        }
        return this.knob;
    }

    private BComponent resolve() {
        this.indirect = null;
        try {
            BObject obj = this.getSourceOrd().resolve(this.getParentComponent()).get();
            if (!(obj instanceof BComponent)) {
                throw new BajaRuntimeException("Source ord must resolve to a component");
            }
            this.indirect = (BComponent)obj;
        }
        catch (UnresolvedException e) {
            throw new UnresolvedException("Cannot resolve source component");
        }
        this.sourceSlot = this.indirect.getSlot(this.getSourceSlotName());
        if (this.sourceSlot == null) {
            throw new UnresolvedException("Source slot does not exist");
        }
        this.targetSlot = this.getParent().getSlot(this.getTargetSlotName());
        if (this.targetSlot == null) {
            throw new UnresolvedException("Target slot does not exist");
        }
        return this.indirect;
    }

    @Override
    public String toString(Context context) {
        String t = "null";
        BComponent tc = this.getTargetComponent();
        if (tc != null) {
            SlotPath tp = tc.getSlotPath();
            t = tp == null ? tc.toString() : tp.toString();
        }
        String s = this.direct != null ? "Direct: " + this.direct.toDebugString() : "Indirect: " + this.getSourceOrd();
        return s + "." + this.getSourceSlotName() + " -> " + t + "." + this.getTargetSlotName();
    }

    public void propagate(BValue arg) {
        if (this.fatalFault) {
            return;
        }
        if (this.getTargetComponent() == this.getSourceComponent() && this.getTargetSlot() == this.getSourceSlot()) {
            System.out.println("WARNING: Infinite link: " + this);
            return;
        }
        if (this.sourceSlot.isAction()) {
            if (this.targetSlot.isAction()) {
                this.propagateActionToAction(arg);
                return;
            }
            if (this.targetSlot.isTopic()) {
                this.propagateActionToTopic(arg);
                return;
            }
        } else if (this.sourceSlot.isTopic()) {
            if (this.targetSlot.isAction()) {
                this.propagateTopicToAction(arg);
                return;
            }
            if (this.targetSlot.isTopic()) {
                this.propagateTopicToTopic(arg);
                return;
            }
        } else if (this.sourceSlot.isProperty()) {
            if (this.targetSlot.isAction()) {
                this.propagatePropertyToAction();
                return;
            }
            if (this.targetSlot.isProperty()) {
                this.propagatePropertyToProperty();
                return;
            }
        }
        throw new IllegalStateException("Invalid link config");
    }

    public void propagatePropertyToAction() {
        if (this.fatalFault) {
            return;
        }
        Action targetAction = this.getTargetSlot().asAction();
        BValue arg = null;
        if (targetAction.getParameterType() != null) {
            arg = this.getSourceComponent().get(this.getSourceSlot().asProperty());
        }
        this.getTargetComponent().invoke(targetAction, arg);
    }

    public void propagatePropertyToProperty() {
        if (this.fatalFault) {
            return;
        }
        BComponent s = this.getSourceComponent();
        BComponent t = this.getTargetComponent();
        Property sProp = this.sourceSlot.asProperty();
        Property tProp = this.targetSlot.asProperty();
        switch (sProp.getTypeAccess()) {
            case 0: {
                t.setBoolean(tProp, s.getBoolean(sProp), null);
                break;
            }
            case 2: {
                t.setInt(tProp, s.getInt(sProp), null);
                break;
            }
            case 3: {
                t.setLong(tProp, s.getLong(sProp), null);
                break;
            }
            case 4: {
                t.setFloat(tProp, s.getFloat(sProp), null);
                break;
            }
            case 5: {
                t.setDouble(tProp, s.getDouble(sProp), null);
                break;
            }
            case 6: {
                t.setString(tProp, s.getString(sProp), null);
                break;
            }
            case 7: {
                BValue value = s.get(sProp);
                if (value.isSimple()) {
                    t.set(tProp, value, null);
                    break;
                }
                t.get(tProp).asComplex().copyFrom(value.asComplex());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void propagateActionToAction(BValue arg) {
        if (this.fatalFault) {
            return;
        }
        Action targetAction = this.getTargetSlot().asAction();
        this.getTargetComponent().invoke(targetAction, arg);
    }

    public void propagateActionToTopic(BValue event) {
        if (this.fatalFault) {
            return;
        }
        Topic targetTopic = this.getTargetSlot().asTopic();
        this.getTargetComponent().fire(targetTopic, event);
    }

    public void propagateTopicToAction(BValue event) {
        if (this.fatalFault) {
            return;
        }
        Action targetAction = this.getTargetSlot().asAction();
        BValue arg = null;
        if (targetAction.getParameterType() != null) {
            arg = event;
        }
        this.getTargetComponent().invoke(targetAction, arg);
    }

    public void propagateTopicToTopic(BValue event) {
        if (this.fatalFault) {
            return;
        }
        Topic targetTopic = this.getTargetSlot().asTopic();
        this.getTargetComponent().fire(targetTopic, event);
    }

    public boolean isFatalFault() {
        return this.fatalFault;
    }

    private static boolean runningInStation() {
        return Sys.getStation() != null;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

