/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.util.HashMap;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BModule;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public abstract class BBitString
extends BSimple {
    public static final Type TYPE = Sys.loadType(BBitString.class);

    public abstract boolean getBit(int var1);

    public abstract boolean getBit(String var1);

    public abstract int[] getOrdinals();

    public abstract boolean isOrdinal(int var1);

    public abstract String getTag(int var1);

    public abstract String getDisplayTag(int var1, Context var2);

    public abstract BBitString getInstance(int[] var1);

    public abstract boolean isTag(String var1);

    public abstract int tagToOrdinal(String var1);

    public abstract boolean isEmpty();

    public abstract String getEmptyTag();

    @Override
    public Type getType() {
        return TYPE;
    }

    public static class Support {
        private BBitString instance;
        private IntHashMap byOrdinal = new IntHashMap();
        private HashMap<String, Integer> byTag = new HashMap();
        private int[] ordinals;

        public Support(BBitString instance) {
            this.instance = instance;
        }

        public int[] getOrdinals() {
            if (this.ordinals == null) {
                int[] temp = new int[this.byOrdinal.size()];
                IntHashMap.Iterator it = this.byOrdinal.iterator();
                int i = 0;
                while (it.hasNext()) {
                    it.next();
                    temp[i] = it.key();
                    ++i;
                }
                this.ordinals = temp;
            }
            int[] copy = new int[this.ordinals.length];
            System.arraycopy(this.ordinals, 0, copy, 0, copy.length);
            return copy;
        }

        public boolean isOrdinal(int ordinal) {
            return this.byOrdinal.get(ordinal) != null;
        }

        public String getTag(int ordinal) {
            String t = (String)this.byOrdinal.get(ordinal);
            if (t == null) {
                throw new IllegalArgumentException("" + ordinal);
            }
            return t;
        }

        public String getDisplayTag(int ordinal, Context cx) {
            Type type = this.instance.getType();
            BModule module = type.getModule();
            Lexicon lex = Lexicon.make(module, cx);
            return lex.getText(type.getTypeName() + "." + this.getTag(ordinal));
        }

        public boolean isTag(String tag) {
            return this.byTag.get(tag) != null;
        }

        public int tagToOrdinal(String tag) {
            Integer o = this.byTag.get(tag);
            if (o == null) {
                throw new IllegalArgumentException(tag);
            }
            return o;
        }

        public void add(int ordinal, String tag) {
            this.byOrdinal.put(ordinal, (Object)tag);
            this.byTag.put(tag, ordinal);
        }
    }
}

