/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.nre.util.IElement;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class RenameOp
extends SyncOp {
    String oldName;
    String newName;

    public RenameOp(BComponent c, String oldName, String newName) {
        super(c);
        this.oldName = oldName;
        this.newName = newName;
    }

    public RenameOp() {
    }

    @Override
    public int getId() {
        return 114;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    void commit(SyncBuffer parent, BComponentSpace space, Context context) throws Exception {
        Property prop = this.component.getProperty(this.oldName);
        if (prop != null) {
            this.component.rename(prop, this.newName, context);
        }
    }

    @Override
    void encode(SyncEncoder out) throws Exception {
        super.encode(out);
        out.attr("o", this.oldName);
        out.attr("n", this.newName).end().newLine();
    }

    @Override
    void decode(SyncBuffer buffer, BComponentSpace space, SyncDecoder in) throws Exception {
        super.decode(buffer, space, in);
        IElement elem = in.elem();
        this.oldName = elem.get("o");
        this.newName = elem.get("n");
    }

    @Override
    public String toString() {
        return "Rename: " + this.componentToString() + "." + this.oldName + " -> " + this.newName;
    }
}

