/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.spy;

import com.tridium.util.EscUtil;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.file.FilePath;
import javax.baja.io.HtmlWriter;
import javax.baja.session.CsrfException;
import javax.baja.session.INiagaraSuperSession;
import javax.baja.session.SessionUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import org.owasp.encoder.Encode;

public class SpyWriter
extends HtmlWriter {
    static final String CSRF_TOKEN_PREFIX = EscUtil.slot.escape("?token=");
    static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss dd-MMM-yy zzz");
    private SpyWriter unsafe;
    private boolean closed;
    FilePath path;
    Context cx;

    public SpyWriter(Writer out, FilePath path) {
        this(out, path, null);
    }

    public SpyWriter(Writer out, FilePath path, Context cx) {
        super(out);
        this.path = path;
        this.cx = cx;
    }

    public SpyWriter(OutputStream out, FilePath path) {
        this(out, path, null);
    }

    public SpyWriter(OutputStream out, FilePath path, Context cx) {
        super(out);
        this.path = path;
        this.cx = cx;
    }

    private SpyWriter(SpyWriter actual) {
        super(actual);
        this.unsafe = this;
    }

    public SpyWriter unsafe() {
        if (!this.closed && this.unsafe == null) {
            this.unsafe = this.makeUnsafeSpyWriter();
        }
        return this.unsafe;
    }

    protected SpyWriter makeUnsafeSpyWriter() {
        return new SpyWriter(this);
    }

    public FilePath getPath() {
        return this.path;
    }

    public Context getContext() {
        return this.cx;
    }

    @Override
    public SpyWriter w(Object o) {
        if (o instanceof BAbsTime) {
            BAbsTime x = (BAbsTime)o;
            if (x == null || x.isNull()) {
                this.print("null");
            } else {
                this.print(timeFormat.format(new Date(x.getMillis())));
            }
        } else {
            this.print(o);
        }
        return this;
    }

    public SpyWriter startProps() {
        this.w("<table class='spy-props'>\n");
        return this;
    }

    public SpyWriter startProps(String title) {
        this.w("<table class='spy-props'>\n");
        this.w("<tr><th class='spy-prop-title' nowrap='true' colspan='2'>").w(this.encode(title)).w("</th></tr>\n");
        return this;
    }

    public SpyWriter prop(Object name, Object value) {
        return this.writeProp(name, String.valueOf(value));
    }

    public SpyWriter prop(Object name, boolean value) {
        return this.writeProp(name, String.valueOf(value));
    }

    public SpyWriter prop(Object name, int value) {
        return this.writeProp(name, String.valueOf(value));
    }

    public SpyWriter prop(Object name, double value) {
        return this.writeProp(name, String.valueOf(value));
    }

    public SpyWriter propNameLink(Object href, Object linkTitle, Object value) {
        this.unsafe().prop((Object)this.createLink(String.valueOf(href), linkTitle), this.encode(value));
        return this;
    }

    public SpyWriter propValueLink(Object name, Object href, Object linkTitle) {
        this.unsafe().prop((Object)this.encode(name), this.createLink(String.valueOf(href), linkTitle));
        return this;
    }

    private SpyWriter writeProp(Object name, String value) {
        return this.w("<tr class='spy-prop'><td class='spy-prop-name'>").w(this.encode(name)).w("</td><td class='spy-prop-value'>").w(this.encode(value)).w("</td></tr>\n");
    }

    public SpyWriter endProps() {
        this.endTable();
        return this;
    }

    @Override
    public String href(String href) {
        return this.encode(href);
    }

    @Override
    public SpyWriter trTitle(Object title, int colspan) {
        return (SpyWriter)super.trTitle(this.encode(title), colspan);
    }

    @Override
    public SpyWriter thTitle(Object title) {
        return (SpyWriter)super.thTitle(this.encode(title));
    }

    @Override
    public SpyWriter th(Object s) {
        return (SpyWriter)super.th(this.encode(s));
    }

    @Override
    public SpyWriter td(Object s) {
        return (SpyWriter)super.td(this.encode(s));
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.isUnsafeProxy()) {
            super.close();
        } else if (this.unsafe != null && !this.unsafe.closed) {
            this.unsafe.closed = true;
            this.unsafe.close();
        } else {
            super.close();
        }
    }

    public static String addCsrfToken(String hrefName) {
        INiagaraSuperSession session = SessionUtil.getCurrentNiagaraSuperSession();
        if (session != null) {
            return hrefName + CSRF_TOKEN_PREFIX + EscUtil.slot.escape(session.getCsrfToken());
        }
        return hrefName;
    }

    public static boolean verifyNameAndCsrfToken(String hrefNameAndToken, String expectedHrefName) {
        String namePart;
        INiagaraSuperSession session = SessionUtil.getCurrentNiagaraSuperSession();
        int idx = hrefNameAndToken.indexOf(CSRF_TOKEN_PREFIX);
        if (idx >= 0 && expectedHrefName.equals(namePart = hrefNameAndToken.substring(0, idx))) {
            if (session != null) {
                String token = EscUtil.slot.unescape(hrefNameAndToken.substring(idx + CSRF_TOKEN_PREFIX.length()));
                session.verifyCsrfToken(token);
            }
            return true;
        }
        if (hrefNameAndToken.startsWith(expectedHrefName)) {
            if (session != null) {
                throw new CsrfException("csrf token missing");
            }
            return true;
        }
        return false;
    }

    public static String getNameWithoutCsrfToken(String hrefNameAndToken) {
        int idx = hrefNameAndToken.indexOf(CSRF_TOKEN_PREFIX);
        if (idx >= 0) {
            String namePart = hrefNameAndToken.substring(0, idx);
            SpyWriter.verifyNameAndCsrfToken(hrefNameAndToken, namePart);
            return namePart;
        }
        if (SessionUtil.getCurrentNiagaraSuperSession() != null) {
            throw new CsrfException("csrf token missing");
        }
        return hrefNameAndToken;
    }

    private String encode(Object s) {
        String str = String.valueOf(s);
        return this.isUnsafeProxy() ? str : Encode.forHtml((String)String.valueOf(s));
    }

    private boolean isUnsafeProxy() {
        return this.unsafe == this;
    }
}

