/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.spy;

import javax.baja.file.FilePath;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.space.BSpace;
import javax.baja.space.BSpaceScheme;
import javax.baja.spy.BSpySpace;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BSpyScheme
extends BSpaceScheme {
    public static final BSpyScheme INSTANCE = new BSpyScheme();
    public static final Type TYPE = Sys.loadType(BSpyScheme.class);

    private BSpyScheme() {
        super("spy");
    }

    @Override
    public OrdQuery parse(String queryBody) {
        return new FilePath("spy", queryBody);
    }

    @Override
    public Type getSpaceType() {
        return BSpySpace.TYPE;
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query, BSpace space) {
        if (base.getUser() == null || base.getUser().getPermissions().isSuperUser()) {
            FilePath path = (FilePath)query;
            BSpySpace ss = (BSpySpace)space;
            return new OrdTarget(base, ss.resolveSpy(path));
        }
        Lexicon lexicon = Lexicon.make("baja", base.getLanguage());
        throw new UnresolvedException(lexicon.getText("NonSuperUserUnresolvedSpyOrdException"));
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

