/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.space;

import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.sys.Nre;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.station.Station;
import com.tridium.sys.transfer.DeleteOp;
import com.tridium.sys.transfer.IntraCompSpaceMove;
import com.tridium.util.ArrayUtil;
import com.tridium.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.category.BCategoryMask;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.space.BSpace;
import javax.baja.space.LoadCallbacks;
import javax.baja.space.Mark;
import javax.baja.space.SubscribeCallbacks;
import javax.baja.space.TrapCallbacks;
import javax.baja.spy.SpyWriter;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIPropertySpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeSubscriber;
import javax.baja.tag.BIEntitySpace;
import javax.baja.tag.TagDictionaryService;
import javax.baja.util.LexiconText;

public class BComponentSpace
extends BSpace
implements BIProtected,
BIPropertySpace,
BIDataRecoverySource,
BIEntitySpace {
    public static final Type TYPE = Sys.loadType(BComponentSpace.class);
    static Logger mixInLog = Logger.getLogger("sys.mixin");
    static TypeInfo nullProxyExt = null;
    Map<Object, BComponent> map = new ConcurrentHashMap<Object, BComponent>();
    long nextHandle = 1L;
    LoadCallbacks loadCallbacks = new LoadCallbacks();
    TrapCallbacks trapCallbacks = new TrapCallbacks();
    SubscribeCallbacks subscribeCallbacks = new SubscribeCallbacks();
    BComponent root;
    BOrd ordInSession;
    Type[] mixIns = new Type[0];
    boolean holdMixInUpdates;
    private BDataRecoveryComponentRecorder dataRecoveryRestorer = null;
    long nextHandleOnCriticalStart = 1L;
    List<Object> reassignedHandles = null;
    private TagDictionaryService tagDictionaryService;
    final Map<Type, List<List<TypeSubscriber>>> typeSubscriptionMap = new HashMap<Type, List<List<TypeSubscriber>>>();
    private static final int COMPONENT_EVENT_COUNT = 25;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BComponentSpace(String name, LexiconText lexText, BOrd ordInSession) {
        super(name, lexText);
        this.ordInSession = ordInSession;
    }

    public BComponent getRootComponent() {
        return this.root;
    }

    public synchronized void setRootComponent(BComponent root) {
        this.root = root;
        this.map.clear();
        if (root != null && root.getComponentSpace() == null) {
            ((ComponentSlotMap)root.fw(1)).mount(this, null, null);
        }
    }

    public boolean isSpaceReadonly() {
        return false;
    }

    public int getComponentCount() {
        return this.map.size();
    }

    public BComponent[] getAllComponents() {
        return this.map.values().toArray(new BComponent[this.map.size()]);
    }

    public long getDefaultLeaseTime() {
        return 60000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Type[] t, TypeSubscriber s) {
        for (Type type : t) {
            List<List<TypeSubscriber>> eventSubscribers;
            Object object = this.typeSubscriptionMap;
            synchronized (object) {
                this.typeSubscriptionMap.putIfAbsent(type, new ArrayList<Object>(Collections.nCopies(25, null)));
                eventSubscribers = this.typeSubscriptionMap.get(type);
            }
            object = eventSubscribers;
            synchronized (object) {
                int bits = s.getMask().getBits();
                for (int j = 0; j < 25; ++j) {
                    if ((bits >> j & 1) == 0) continue;
                    if (eventSubscribers.get(j) == null) {
                        eventSubscribers.set(j, new ArrayList(2));
                    }
                    if (eventSubscribers.get(j).contains(s)) continue;
                    eventSubscribers.get(j).add(s);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Type[] t, TypeSubscriber s) {
        for (Type type : t) {
            List<List<TypeSubscriber>> eventSubscribers = this.typeSubscriptionMap.get(type);
            if (eventSubscribers == null) continue;
            List<List<TypeSubscriber>> list = eventSubscribers;
            synchronized (list) {
                for (int j = 0; j < eventSubscribers.size(); ++j) {
                    if (eventSubscribers.get(j) == null) continue;
                    eventSubscribers.get(j).remove(s);
                    if (!eventSubscribers.get(j).isEmpty()) continue;
                    eventSubscribers.set(j, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubscription(Type[] t, TypeSubscriber s) {
        for (Type type : t) {
            List<List<TypeSubscriber>> eventSubscribers;
            Object object = this.typeSubscriptionMap;
            synchronized (object) {
                this.typeSubscriptionMap.putIfAbsent(type, new ArrayList<Object>(Collections.nCopies(25, null)));
                eventSubscribers = this.typeSubscriptionMap.get(type);
            }
            object = eventSubscribers;
            synchronized (object) {
                int bits = s.getMask().getBits();
                for (int j = 0; j < eventSubscribers.size(); ++j) {
                    if ((bits >> j & 1) != 0) {
                        if (eventSubscribers.get(j) == null) {
                            eventSubscribers.set(j, new ArrayList(2));
                        }
                        if (eventSubscribers.get(j).contains(s)) continue;
                        eventSubscribers.get(j).add(s);
                        continue;
                    }
                    if (eventSubscribers.get(j) == null) continue;
                    eventSubscribers.get(j).remove(s);
                    if (!eventSubscribers.get(j).isEmpty()) continue;
                    eventSubscribers.set(j, null);
                }
            }
        }
    }

    public boolean isSubscribed(Type t) {
        if (t == null) {
            return false;
        }
        if (this.typeSubscriptionMap.containsKey(t)) {
            for (List<TypeSubscriber> eventSubscriber : this.typeSubscriptionMap.get(t)) {
                if (eventSubscriber == null || eventSubscriber.isEmpty()) continue;
                return true;
            }
        }
        return this.isSubscribed(t.getSuperType());
    }

    public boolean isSubscribed(Type t, int componentEventId) {
        if (t == null) {
            return false;
        }
        if (componentEventId == -1) {
            return false;
        }
        if (!this.typeSubscriptionMap.containsKey(t)) {
            return this.isSubscribed(t.getSuperType(), componentEventId);
        }
        List<List<TypeSubscriber>> eventSubscribers = this.typeSubscriptionMap.get(t);
        return eventSubscribers.get(componentEventId) != null && !eventSubscribers.get(componentEventId).isEmpty() || this.isSubscribed(t.getSuperType(), componentEventId);
    }

    public void event(BComponentEvent event) {
        this.event(event, event.getSourceComponent().getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void event(BComponentEvent event, Type type) {
        if (type == null || type.getModule().getModuleName().equals("event")) {
            return;
        }
        List<List<TypeSubscriber>> eventSubscribers = this.typeSubscriptionMap.get(type);
        if (eventSubscribers != null) {
            List<List<TypeSubscriber>> list = eventSubscribers;
            synchronized (list) {
                if (eventSubscribers.get(event.getId()) != null && !eventSubscribers.get(event.getId()).isEmpty()) {
                    for (int i = 0; i < eventSubscribers.get(event.getId()).size(); ++i) {
                        eventSubscribers.get(event.getId()).get(i).event(event);
                    }
                }
            }
        }
        this.event(event, type.getSuperType());
    }

    @Override
    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    public LoadCallbacks getLoadCallbacks() {
        return this.loadCallbacks;
    }

    public void setLoadCallbacks(LoadCallbacks loadCallbacks) {
        this.loadCallbacks = loadCallbacks;
    }

    public TrapCallbacks getTrapCallbacks() {
        return this.trapCallbacks;
    }

    public void setTrapCallbacks(TrapCallbacks trapCallbacks) {
        this.trapCallbacks = trapCallbacks;
    }

    public SubscribeCallbacks getSubscribeCallbacks() {
        return this.subscribeCallbacks;
    }

    public void setSubscribeCallbacks(SubscribeCallbacks subscribeCallbacks) {
        this.subscribeCallbacks = subscribeCallbacks;
    }

    public final void update(BComponent c, int depth) {
        this.getSubscribeCallbacks().update(c, depth);
    }

    public final Transaction newTransaction() {
        return this.newTransaction(null);
    }

    public Transaction newTransaction(Context cx) {
        return new Transaction(this, this.getEncodingContext(cx)){};
    }

    public Context getEncodingContext(Context base) {
        return PasswordEncodingContext.updateForNone(base);
    }

    public void modified(BComponent c, Context context) {
    }

    public void childParented(BComponent c, Property property, BValue newChild, Context context) {
    }

    public void childUnparented(BComponent c, Property property, BValue oldChild, Context context) {
    }

    public boolean fireDirectCallbacks() {
        return true;
    }

    public boolean isProxyComponentSpace() {
        return false;
    }

    public void sync() throws Exception {
    }

    public final BComponent findByHandle(Object handle) {
        return this.findByHandle(handle, true);
    }

    public BComponent findByHandle(Object handle, boolean autoLoad) {
        return this.doFindByHandle(handle, autoLoad);
    }

    protected BComponent doFindByHandle(Object handle, boolean autoLoad) {
        return this.map.get(handle);
    }

    public final BComponent resolveByHandle(Object handle) {
        BComponent c = this.findByHandle(handle);
        if (c != null) {
            return c;
        }
        throw new UnresolvedException(String.valueOf(handle));
    }

    public SlotPath handleToSlotPath(Object handle) {
        BComponent c = this.map.get(handle);
        if (c == null) {
            return null;
        }
        return c.getSlotPath();
    }

    public SlotPath[] handlesToSlotPaths(Object[] handles) {
        SlotPath[] paths = new SlotPath[handles.length];
        for (int i = 0; i < handles.length; ++i) {
            paths[i] = this.handleToSlotPath(handles[i]);
        }
        return paths;
    }

    public Iterator<BComponent> iterateAllComponents() {
        return this.map.values().iterator();
    }

    public Type[] getEnabledMixIns() {
        return (Type[])this.mixIns.clone();
    }

    public synchronized void enableMixIn(Type mixInType) {
        if (this.isProxyComponentSpace()) {
            throw new IllegalStateException("Cannot call on proxy space");
        }
        if (!mixInType.is(BIMixIn.TYPE)) {
            throw new IllegalArgumentException(mixInType.toString() + " does not implement baja:IMixIn");
        }
        for (Type mixIn : this.mixIns) {
            if (mixIn != mixInType) continue;
            return;
        }
        this.mixIns = ArrayUtil.addOne(this.mixIns, mixInType);
        this.updateMixIns();
        if (Sys.getStation() == this.root) {
            Station.broadcastStationMixIns();
        }
    }

    public synchronized void disableMixIn(Type mixInType) {
        if (this.isProxyComponentSpace()) {
            throw new IllegalStateException("Cannot call on proxy space");
        }
        int index = -1;
        for (int i = 0; i < this.mixIns.length; ++i) {
            if (this.mixIns[i] != mixInType) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        this.mixIns = ArrayUtil.removeOne(this.mixIns, index);
        if (Sys.getStation() == this.root) {
            Station.broadcastStationMixIns();
        }
    }

    private synchronized void updateMixIns() {
        if (this.holdMixInUpdates) {
            return;
        }
        long t1 = Clock.ticks();
        if (this.isProxyComponentSpace()) {
            throw new IllegalStateException("Cannot call on proxy space");
        }
        BComponent[] comps = new BComponent[this.map.size()];
        this.map.values().toArray(comps);
        for (BComponent comp : comps) {
            this.updateMixIns(comp);
        }
        long t2 = Clock.ticks();
        mixInLog.info("Updated [" + (t2 - t1) + "ms]");
    }

    private synchronized void updateMixIns(BComponent c) {
        if (this.holdMixInUpdates) {
            return;
        }
        TypeInfo cType = c.getType().getTypeInfo();
        Registry reg = Sys.getRegistry();
        for (Type mixIn : this.mixIns) {
            if (!reg.isAgent(mixIn.getTypeInfo(), cType)) continue;
            this.addMixInIfNeeded(c, mixIn);
        }
    }

    private void addMixInIfNeeded(BComponent c, Type mixInType) {
        try {
            if (c.getMixIn(mixInType) != null) {
                return;
            }
            if (mixInLog.isLoggable(Level.FINE)) {
                mixInLog.fine("Add " + mixInType + " to " + c.toPathString());
            }
            BValue value = (BValue)mixInType.getInstance();
            c.add(mixInType.toString().replace(':', '_'), value);
        }
        catch (Exception e) {
            mixInLog.log(Level.SEVERE, "Cannot add mix in " + mixInType + " to " + c.toPathString(), e);
        }
    }

    private synchronized void setHoldMixInUpdates(boolean hold) {
        this.holdMixInUpdates = hold;
        if (!hold && this.mixIns.length > 0) {
            this.updateMixIns();
        }
    }

    @Override
    public BCategoryMask getCategoryMask() {
        BCategoryMask mask = this.root.getCategoryMask();
        if (mask == null || mask.isNull()) {
            return BCategoryMask.make("1");
        }
        return mask;
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        return this.getCategoryMask();
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null) {
            return cx.getUser().getPermissionsFor(this);
        }
        return BPermissions.all;
    }

    @Override
    public boolean canRead(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorRead();
    }

    @Override
    public boolean canWrite(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorWrite();
    }

    @Override
    public boolean canInvoke(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorInvoke();
    }

    @Override
    public Cursor<? extends BIObject> findObjects(Type objectType, BOrd baseOrd, String propertyName, Context cx) {
        return this.findObjects(objectType, baseOrd, propertyName, (Type)null, cx);
    }

    @Override
    public Cursor<? extends BIObject> findObjects(Type objectType, BOrd baseOrd, String propertyName, Type propertyType, Context cx) {
        return new ContainerCursor(this.findContainers(objectType, baseOrd, cx), propertyName, propertyType, cx);
    }

    @Override
    public Cursor<? extends BIObject> findObjects(Type objectType, BOrd baseOrd, String propertyName, BValue propertyValue, Context cx) {
        return new ContainerCursor(this.findContainers(objectType, baseOrd, cx), propertyName, propertyValue, cx);
    }

    @Override
    public Cursor<? extends BIObject> findDistinctValues(Type objectType, BOrd baseOrd, String propertyName, Context cx) {
        return this.findDistinctValues(objectType, baseOrd, propertyName, null, cx);
    }

    @Override
    public Cursor<? extends BIObject> findDistinctValues(Type objectType, BOrd baseOrd, String propertyName, Type propertyType, Context cx) {
        return new DistinctPropertyCursor(this.findContainers(objectType, baseOrd, cx), propertyName, propertyType, cx);
    }

    @Override
    public boolean addIndex(String propertyName, Context cx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeIndex(String propertyName, Context cx) {
        throw new UnsupportedOperationException();
    }

    private Cursor<BObject> findContainers(Type objectType, BOrd baseOrd, Context cx) {
        Type t = objectType != null ? objectType : BComponent.TYPE;
        boolean useNavOrd = this.isProxyComponentSpace() && t.is(BComponent.TYPE);
        StringBuilder sb = new StringBuilder();
        sb.append("bql:select ");
        if (useNavOrd) {
            sb.append("navOrd");
        } else {
            sb.append("*");
        }
        sb.append(" from ").append(t.toString());
        BOrd query = baseOrd == null || baseOrd.isNull() ? BOrd.make(this.getNavOrd(), sb.toString()) : BOrd.make(baseOrd, sb.toString());
        BITable table = (BITable)((Object)query.resolve(this).get());
        Column col = table.getColumns().get(0);
        IterableCursor c = table.cursor();
        if (!useNavOrd) {
            return c;
        }
        Array arr = new Array(BOrd.class);
        while (c.next()) {
            arr.add((Object)BOrd.make(c.cell(col).toString(null)).relativizeToSession());
        }
        BOrd[] ords = (BOrd[])arr.trim();
        BatchResolve targets = new BatchResolve(ords).resolve(this);
        BObject[] comps = targets.getTargetComponents();
        BComponent.lease((BComponent[])comps, 0);
        return new ArrayCursor(comps, cx);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 101: {
                this.mount(a);
                return null;
            }
            case 102: {
                this.unmount(a);
                return null;
            }
            case 103: {
                return this.generateHandles((Integer)a);
            }
            case 111: {
                return this.generateUniqueName((String)a, (ObjectUtil.NameContainer)b);
            }
            case 104: {
                return null;
            }
            case 105: {
                this.setHoldMixInUpdates((Boolean)a);
                return null;
            }
            case 112: {
                return DeleteOp.make((Mark)a, (Context)b);
            }
            case 106: {
                return ((DeleteOp)a).doDelete();
            }
            case 107: {
                return ((DeleteOp)a).doUndelete();
            }
            case 113: {
                return new IntraCompSpaceMove();
            }
            case 1002: {
                this.dataRecoveryRestorer = (BDataRecoveryComponentRecorder)a;
                if (this.dataRecoveryRestorer != null) {
                    this.nextHandleOnCriticalStart = this.nextHandle;
                    this.reassignedHandles = new ArrayList<Object>();
                } else {
                    this.reassignedHandles = null;
                }
                return null;
            }
            case 116: {
                return this.map.get(a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    protected synchronized void mount(Object support) {
        ComponentSlotMap c = (ComponentSlotMap)support;
        BComponent comp = (BComponent)c.getInstance();
        this.nextHandle = BComponentSpace.solveForNextHandle(comp, this.nextHandle);
        if (c.getSpace() != null) {
            throw new IllegalStateException("Component already mounted: " + c.getInstance());
        }
        Object handle = c.getHandle();
        if (handle == null || handle.toString().startsWith("copy-")) {
            handle = this.generateHandle();
        }
        c.setHandle(handle);
        BComponent dup = this.map.get(handle);
        if (dup != null) {
            boolean reassignHandle;
            block13: {
                reassignHandle = false;
                try {
                    long h;
                    if (this.dataRecoveryRestorer == null || (h = Long.parseLong((String)handle, 16)) >= this.nextHandleOnCriticalStart && !this.reassignedHandles.contains(handle)) break block13;
                    boolean bl = reassignHandle = dup.getType().getTypeInfo() == nullProxyExt;
                    if (!reassignHandle) {
                        BComplex parent;
                        Property prop = dup.getPropertyInParent();
                        Property newProp = c.getPropertyInParent();
                        if (parent == c.getParent() && prop != null && newProp != null && prop.equals(newProp)) {
                            reassignHandle = true;
                        } else {
                            for (parent = dup.getParent(); parent != null && prop != null; parent = parent.getParent()) {
                                int pflags = parent.getFlags(prop);
                                boolean bl2 = reassignHandle = (pflags & 2) != 0;
                                if (reassignHandle) break;
                                prop = parent.getPropertyInParent();
                            }
                        }
                    }
                    if (!reassignHandle) break block13;
                    Object newHandle = this.generateHandle();
                    ((ComponentSlotMap)dup.fw(1)).setHandle(newHandle);
                    this.map.put(newHandle, dup);
                    this.reassignedHandles.remove(handle);
                    this.reassignedHandles.add(newHandle);
                    try {
                        if (BDataRecoveryComponentRecorder.LOG.isLoggable(Level.FINE)) {
                            BDataRecoveryComponentRecorder.LOG.fine("Reassigned handle for " + dup.toPathString() + ", old=" + handle + ", new=" + newHandle + " due to conflict with data recovery restore for component " + comp.toPathString());
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new IllegalStateException("Duplicate handle: " + handle + " " + dup.toDebugString() + " ; " + comp.toDebugString());
                }
            }
            if (!reassignHandle) {
                throw new IllegalStateException("Duplicate handle: " + handle + " " + dup.toDebugString() + " ; " + comp.toDebugString());
            }
        }
        this.map.put(handle, comp);
        this.updateMixIns(comp);
    }

    protected synchronized void unmount(Object support) {
        ComponentSlotMap c = (ComponentSlotMap)support;
        if (c.getSpace() != this) {
            throw new IllegalStateException("Component not mounted: " + c);
        }
        this.map.remove(c.getHandle());
    }

    synchronized Object[] generateHandles(int count) {
        Object[] handles = new Object[count];
        for (int i = 0; i < count; ++i) {
            handles[i] = this.generateHandle();
        }
        return handles;
    }

    synchronized Object generateHandle() {
        if (this.isProxyComponentSpace()) {
            throw new IllegalStateException("generateHandle in proxy space");
        }
        return Long.toHexString(this.nextHandle++);
    }

    String generateUniqueName(String defName, ObjectUtil.NameContainer container) {
        return ObjectUtil.generateUniqueSlotName(defName, container);
    }

    @Override
    public boolean hasNavChildren() {
        return this.root != null;
    }

    @Override
    public BINavNode getNavChild(String name) {
        if (this.root == null) {
            return null;
        }
        return this.root.getNavChild(name);
    }

    @Override
    public BINavNode[] getNavChildren() {
        if (this.root == null) {
            return new BINavNode[0];
        }
        return this.root.getNavChildren();
    }

    @Override
    public BIcon getNavIcon() {
        if (this.root == null) {
            return this.getIcon();
        }
        return this.root.getNavIcon();
    }

    @Override
    public BOrd getNavOrd() {
        if (this.root == null) {
            return super.getNavOrd();
        }
        return this.root.getNavOrd();
    }

    @Override
    public TagDictionaryService getTagDictionaryService() {
        return this.tagDictionaryService;
    }

    @Override
    public void setTagDictionaryService(TagDictionaryService service) {
        this.tagDictionaryService = service;
    }

    @Override
    public void removeTagDictionaryService(TagDictionaryService service) {
        if (this.tagDictionaryService == service) {
            this.tagDictionaryService = null;
        }
    }

    private static long solveForNextHandle(BComponent comp, long next) {
        Object handle = comp.getHandle();
        if (handle != null && !handle.toString().startsWith("copy-")) {
            try {
                long h = Long.parseLong(handle.toString(), 16);
                if (h >= next) {
                    next = h + 1L;
                }
            }
            catch (Exception h) {
                // empty catch block
            }
        }
        SlotCursor<Property> c = comp.getProperties();
        while (c.nextComponent()) {
            next = Math.max(next, BComponentSpace.solveForNextHandle(c.get().asComponent(), next));
        }
        return next;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle("ComponentSpace", 2);
        out.prop((Object)"map.size", this.map.size());
        out.prop((Object)"nextHandle", Long.toHexString(this.nextHandle));
        out.prop((Object)"categoryMask", this.getCategoryMask());
        out.prop((Object)"defaultLeaseTime", this.getDefaultLeaseTime());
        out.trTitle("Enabled MixIns [" + this.mixIns.length + "]", 2);
        out.w("<tr>").th("MixIn").th("On").w("</tr>\n");
        for (Type mixIn : this.mixIns) {
            out.tr(mixIn, this.mixInOn(mixIn));
        }
        out.endProps();
        super.spy(out);
    }

    String mixInOn(Type t) {
        try {
            StringBuilder s = new StringBuilder("{");
            TypeInfo[] on = t.getTypeInfo().getAgentInfo().getAgentOn();
            for (int i = 0; i < on.length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(on[i]);
            }
            s.append("}");
            return s.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    void dumpMap() {
        System.out.println("ComponentSpace.map");
        for (Map.Entry<Object, BComponent> entry : this.map.entrySet()) {
            BComponent value = entry.getValue();
            System.out.println("  " + entry.getKey() + " = " + value);
        }
    }

    @Override
    public boolean dataRecoveryRestore(IDataRecoveryRecord rec) throws Exception {
        return this.dataRecoveryRestorer != null && this.dataRecoveryRestorer.restore(this, rec);
    }

    @Override
    public void dataRecoveryRestoreComplete() {
    }

    @Override
    public void dataRecoverySpy(SpyWriter out, Iterator<IDataRecoveryRecord> recoveryData) throws Exception {
        BDataRecoveryComponentRecorder dataRecoveryRecorder = Nre.getServiceManager().getDataRecoveryComponentRecorder(this);
        if (dataRecoveryRecorder != null) {
            dataRecoveryRecorder.dataRecoverySpy(this, out, recoveryData);
        }
    }

    static {
        try {
            nullProxyExt = Sys.getRegistry().getType("control:NullProxyExt");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class DistinctPropertyCursor<T extends BObject>
    implements IterableCursor<T> {
        Cursor<? extends BIObject> iterator;
        String propertyName;
        Type propertyType = null;
        Array<BValue> propertyValues = new Array(BValue.class);
        Context cx;
        T current = null;

        DistinctPropertyCursor(Cursor<? extends BIObject> iterator, String propertyName, Type propertyType, Context cx) {
            this.iterator = iterator;
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.cx = cx;
        }

        @Override
        public void close() {
            this.iterator.close();
        }

        @Override
        public Context getContext() {
            return this.cx;
        }

        @Override
        public boolean next() {
            return this.next(null);
        }

        public boolean nextComponent() {
            return this.next(BComponent.class);
        }

        public boolean next(Class<?> cls) {
            while (this.iterator.next()) {
                BValue val;
                BIObject comp = this.iterator.get();
                if (!(comp instanceof BIPropertyContainer) || (val = ((BIPropertyContainer)comp).get(this.propertyName)) == null || cls != null && !cls.isInstance(val) || this.propertyType != null && !val.getType().is(this.propertyType) || this.propertyValues.contains((Object)val)) continue;
                this.propertyValues.add((Object)val);
                BValue temp = val;
                this.current = temp;
                return true;
            }
            return false;
        }

        @Override
        public T get() {
            return this.current;
        }
    }

    static class ContainerCursor
    implements IterableCursor<BIPropertyContainer> {
        Cursor<? extends BIObject> iterator;
        String propertyName;
        Type propertyType = null;
        BValue propertyValue = null;
        Context cx;
        BIPropertyContainer current = null;

        ContainerCursor(Cursor<? extends BIObject> iterator, String propertyName, Type propertyType, Context cx) {
            this.iterator = iterator;
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.cx = cx;
        }

        ContainerCursor(Cursor<? extends BIObject> iterator, String propertyName, BValue propertyValue, Context cx) {
            this(iterator, propertyName, propertyValue.getType(), cx);
            this.propertyValue = propertyValue;
        }

        @Override
        public void close() {
            this.iterator.close();
        }

        @Override
        public Context getContext() {
            return this.cx;
        }

        @Override
        public boolean next() {
            return this.next(null);
        }

        public boolean nextComponent() {
            return this.next(BComponent.class);
        }

        public boolean next(Class<?> cls) {
            while (this.iterator.next()) {
                BValue val;
                BIObject comp = this.iterator.get();
                if (!(comp instanceof BIPropertyContainer) || cls != null && !cls.isInstance(comp) || (val = ((BIPropertyContainer)comp).get(this.propertyName)) == null || this.propertyType != null && !val.getType().is(this.propertyType) || this.propertyValue != null && !val.equals(this.propertyValue)) continue;
                this.current = (BIPropertyContainer)comp;
                return true;
            }
            return false;
        }

        @Override
        public BIPropertyContainer get() {
            return this.current;
        }
    }

    static class ArrayCursor
    implements IterableCursor<BObject> {
        private final BObject[] a;
        private final Context cx;
        private int current;

        ArrayCursor(BObject[] a, Context cx) {
            this.a = a;
            this.cx = cx;
            this.current = -1;
        }

        @Override
        public void close() {
            this.current = this.a.length;
        }

        @Override
        public BObject get() {
            return this.a[this.current];
        }

        @Override
        public Context getContext() {
            return this.cx;
        }

        @Override
        public boolean next() {
            if (this.current < this.a.length) {
                ++this.current;
            }
            return this.current != this.a.length;
        }

        public boolean next(Class<?> cls) {
            while (this.next()) {
                BObject o = this.get();
                if (!cls.isInstance(o)) continue;
                return true;
            }
            return false;
        }

        public boolean nextComponent() {
            while (this.next()) {
                if (!(this.get() instanceof BComponent)) continue;
                return true;
            }
            return false;
        }
    }
}

