/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:ClientCredentials"})})
@NiagaraProperty(name="x509Certificate", type="BX509Certificate", flags=1, defaultValue="BX509Certificate.DEFAULT")
public class BX509CertificateCredential
extends BStruct
implements BIUserCredentials,
BIAgent {
    public static final Property x509Certificate = BX509CertificateCredential.newProperty(1, BX509Certificate.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BX509CertificateCredential.class);
    public static final BX509CertificateCredential DEFAULT = new BX509CertificateCredential();
    private boolean isNewUser = false;

    public BX509Certificate getX509Certificate() {
        return (BX509Certificate)this.get(x509Certificate);
    }

    public void setX509Certificate(BX509Certificate v) {
        this.set(x509Certificate, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BX509CertificateCredential() {
    }

    public BX509CertificateCredential(BX509Certificate bcert) {
        this.setX509Certificate(bcert);
    }

    public BX509CertificateCredential(X509Certificate cert) {
        this.setX509Certificate(BX509Certificate.make(cert));
    }

    public BX509CertificateCredential(String encoded) {
        this.setX509Certificate(BX509Certificate.make(encoded));
    }

    @Override
    public String getUsername() {
        BX509Certificate cert = this.getX509Certificate();
        if (cert == null) {
            return null;
        }
        return cert.getUsername();
    }

    @Override
    public boolean isNewUser() {
        return this.isNewUser;
    }

    public void setNewUser(boolean newUser) {
        this.isNewUser = newUser;
    }

    @Override
    public byte[] encodeCredentials(Context context) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        this.getX509Certificate().encode(out);
        out.flush();
        return bout.toByteArray();
    }

    @Override
    public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
        DataInputStream in = new DataInputStream(bin);
        BX509CertificateCredential x = (BX509CertificateCredential)this.newCopy();
        x.set(x509Certificate, (BValue)BX509Certificate.DEFAULT.decode(in));
        return x;
    }
}

