/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryMode;
import javax.baja.category.BCategoryService;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPermissions;
import javax.baja.sys.BIUnlinkable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BPermissionsMap
extends BSimple
implements BIUnlinkable {
    public static final BPermissionsMap SUPER_USER = new BPermissionsMap(new BPermissions[0], "super");
    public static final BPermissionsMap DEFAULT = new BPermissionsMap(new BPermissions[0], "");
    public static final Type TYPE = Sys.loadType(BPermissionsMap.class);
    private BPermissions[] permissions;
    private int size = -1;
    private String string;
    private int hashCode = -1;

    public static BPermissionsMap make(BPermissions[] permissions) {
        if (permissions.length <= 1) {
            return DEFAULT;
        }
        permissions = (BPermissions[])permissions.clone();
        return (BPermissionsMap)new BPermissionsMap(permissions, null).intern();
    }

    public BPermissionsMap or(BPermissionsMap other) {
        if (this.isSuperUser() || other.isSuperUser()) {
            return SUPER_USER;
        }
        BPermissions[] newPermissions = new BPermissions[Math.max(this.permissions.length, other.permissions.length)];
        for (int i = 0; i < newPermissions.length; ++i) {
            BPermissions p2;
            BPermissions p1 = i < this.permissions.length ? this.permissions[i] : BPermissions.none;
            BPermissions bPermissions = p2 = i < other.permissions.length ? other.permissions[i] : BPermissions.none;
            if (p1 == null) {
                p1 = BPermissions.none;
            }
            if (p2 == null) {
                p2 = BPermissions.none;
            }
            newPermissions[i] = p1.or(p2);
        }
        return BPermissionsMap.make(newPermissions);
    }

    public BPermissionsMap and(BPermissionsMap other) {
        if (this.isSuperUser() && other.isSuperUser()) {
            return SUPER_USER;
        }
        BPermissions[] newPermissions = new BPermissions[Math.max(this.permissions.length, other.permissions.length)];
        for (int i = 0; i < newPermissions.length; ++i) {
            BPermissions p2;
            BPermissions p1 = i < this.permissions.length ? this.permissions[i] : BPermissions.none;
            BPermissions bPermissions = p2 = i < other.permissions.length ? other.permissions[i] : BPermissions.none;
            if (this.isSuperUser()) {
                p1 = BPermissions.all;
            }
            if (other.isSuperUser()) {
                p2 = BPermissions.all;
            }
            if (p1 == null) {
                p1 = BPermissions.none;
            }
            if (p2 == null) {
                p2 = BPermissions.none;
            }
            newPermissions[i] = p1.and(p2);
        }
        return BPermissionsMap.make(newPermissions);
    }

    private BPermissionsMap(BPermissions[] permissions, String string) {
        this.permissions = permissions;
        this.string = string;
    }

    public boolean isSuperUser() {
        return this == SUPER_USER;
    }

    public int size() {
        if (this.size < 0) {
            BPermissions p;
            int x;
            for (x = this.permissions.length - 1; x > 0 && ((p = this.permissions[x]) == null || p.getMask() == 0); --x) {
            }
            this.size = x + 1;
        }
        return this.size;
    }

    public BPermissions getPermissions(int categoryIndex) {
        if (categoryIndex < 1) {
            throw new IllegalArgumentException("Category index < 1");
        }
        if (this == SUPER_USER) {
            return BPermissions.all;
        }
        if (categoryIndex >= this.permissions.length) {
            return BPermissions.none;
        }
        BPermissions p = this.permissions[categoryIndex];
        if (p == null) {
            return BPermissions.none;
        }
        return p;
    }

    public BPermissions getCategoryPermissions(BCategoryMask categoryMask) {
        if (this == SUPER_USER) {
            return BPermissions.all;
        }
        BCategoryService catService = null;
        try {
            catService = (BCategoryService)Sys.getService(BCategoryService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
        }
        catch (NotRunningException notRunningException) {
            // empty catch block
        }
        int orMask = 0;
        int andMask = -1;
        boolean applyAnd = false;
        boolean applyOr = false;
        int len = this.permissions.length;
        for (int i = 1; i < len; ++i) {
            if (!categoryMask.get(i)) continue;
            BCategoryMode mode = null;
            if (catService != null) {
                BCategory cat = null;
                try {
                    cat = catService.getCategory(i);
                }
                catch (NotRunningException notRunningException) {
                    // empty catch block
                }
                if (cat != null) {
                    mode = cat.getMode();
                }
            }
            BPermissions p = this.permissions[i];
            if (mode == null || mode == BCategoryMode.union) {
                if (p == null) continue;
                applyOr = true;
                orMask |= p.getMask();
                continue;
            }
            if (p == null) {
                return BPermissions.none;
            }
            applyAnd = true;
            andMask &= p.getMask();
        }
        if (applyAnd) {
            if (applyOr) {
                return BPermissions.make(orMask & andMask);
            }
            return BPermissions.make(andMask);
        }
        return BPermissions.make(orMask);
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BPermissionsMap) {
            BPermissionsMap x = (BPermissionsMap)obj;
            if (this.isSuperUser()) {
                return x.isSuperUser();
            }
            if (x.isSuperUser()) {
                return this.isSuperUser();
            }
            int max = Math.max(this.permissions.length, x.permissions.length);
            for (int i = 1; i < max; ++i) {
                if (this.getPermissions(i).equals(x.getPermissions(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            for (int i = 1; i < this.permissions.length; ++i) {
                BPermissions p = this.permissions[i];
                if (p == null || p.getMask() == 0) continue;
                if (s.length() > 0) {
                    s.append(';');
                }
                s.append(i).append('=').append(p.encodeToString());
            }
            this.string = s.toString();
        }
        return this.string;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        if (s.equals("super")) {
            return SUPER_USER;
        }
        if (s.equals("")) {
            return DEFAULT;
        }
        BPermissions[] permissions = new BPermissions[8];
        String[] tokens = TextUtil.split((String)s, (char)';');
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            int eq = token.indexOf(61);
            int index = Integer.parseInt(token.substring(0, eq));
            BPermissions p = BPermissions.make(token.substring(eq + 1));
            if (index >= permissions.length) {
                BPermissions[] temp = new BPermissions[Math.max(index + 4, permissions.length * 2)];
                System.arraycopy(permissions, 0, temp, 0, permissions.length);
                permissions = temp;
            }
            permissions[index] = p;
        }
        return new BPermissionsMap(permissions, s).intern();
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

