/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BPermissions
extends BSimple {
    static IntHashMap cache = new IntHashMap();
    public static final int OPERATOR_READ = 1;
    public static final int OPERATOR_WRITE = 2;
    public static final int OPERATOR_INVOKE = 4;
    public static final int ADMIN_READ = 16;
    public static final int ADMIN_WRITE = 32;
    public static final int ADMIN_INVOKE = 64;
    public static final BPermissions operatorRead = BPermissions.make(1);
    public static final BPermissions operatorWrite = BPermissions.make(2);
    public static final BPermissions operatorInvoke = BPermissions.make(4);
    public static final BPermissions adminRead = BPermissions.make(16);
    public static final BPermissions adminWrite = BPermissions.make(32);
    public static final BPermissions adminInvoke = BPermissions.make(64);
    private static final BPermissions[] allPermissions = new BPermissions[]{operatorRead, operatorWrite, operatorInvoke, adminRead, adminWrite, adminInvoke};
    public static final BPermissions all = BPermissions.make(119);
    public static final BPermissions none;
    public static final BPermissions DEFAULT;
    public static final Type TYPE;
    private int mask;
    private String string;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BPermissions make(int mask) {
        if ((mask & 2) != 0) {
            mask |= 1;
        }
        if ((mask & 0x10) != 0) {
            mask |= 1;
        }
        if ((mask & 0x20) != 0) {
            mask |= 0x13;
        }
        if ((mask & 0x40) != 0) {
            mask |= 4;
        }
        IntHashMap intHashMap = cache;
        synchronized (intHashMap) {
            BPermissions permissions = (BPermissions)cache.get(mask);
            if (permissions == null) {
                permissions = new BPermissions(mask);
                cache.put(mask, (Object)permissions);
            }
            return permissions;
        }
    }

    public BPermissions or(BPermissions other) {
        return BPermissions.make(this.mask | other.mask);
    }

    public BPermissions and(BPermissions other) {
        return BPermissions.make(this.mask & other.mask);
    }

    public static BPermissions make(String s) throws IOException {
        return (BPermissions)DEFAULT.decodeFromString(s);
    }

    private BPermissions(int mask) {
        this.mask = mask;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean has(int required) {
        return (this.mask & required) == required;
    }

    public boolean has(BPermissions permissions) {
        return (this.mask & permissions.mask) == permissions.mask;
    }

    public boolean hasOperatorRead() {
        return (this.mask & 1) != 0;
    }

    public boolean hasOperatorWrite() {
        return (this.mask & 2) != 0;
    }

    public boolean hasOperatorInvoke() {
        return (this.mask & 4) != 0;
    }

    public boolean hasAdminRead() {
        return (this.mask & 0x10) != 0;
    }

    public boolean hasAdminWrite() {
        return (this.mask & 0x20) != 0;
    }

    public boolean hasAdminInvoke() {
        return (this.mask & 0x40) != 0;
    }

    public static BPermissions[] getAllPermissions() {
        return allPermissions;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public String toString(Context context) {
        return this.encodeToString();
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            if (this.hasOperatorRead()) {
                s.append('r');
            }
            if (this.hasOperatorWrite()) {
                s.append('w');
            }
            if (this.hasOperatorInvoke()) {
                s.append('i');
            }
            if (this.hasAdminRead()) {
                s.append('R');
            }
            if (this.hasAdminWrite()) {
                s.append('W');
            }
            if (this.hasAdminInvoke()) {
                s.append('I');
            }
            this.string = s.toString();
        }
        return this.string;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            int mask = 0;
            block11: for (int i = 0; i < s.length(); ++i) {
                switch (s.charAt(i)) {
                    case 'i': {
                        mask |= 4;
                        continue block11;
                    }
                    case 'r': {
                        mask |= 1;
                        continue block11;
                    }
                    case 'w': {
                        mask |= 2;
                        continue block11;
                    }
                    case 'I': {
                        mask |= 0x40;
                        continue block11;
                    }
                    case 'R': {
                        mask |= 0x10;
                        continue block11;
                    }
                    case 'W': {
                        mask |= 0x20;
                    }
                }
            }
            return BPermissions.make(mask);
        }
        catch (IllegalNameException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Invalid BPermissions: " + s);
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = none = BPermissions.make(0);
        TYPE = Sys.loadType(BPermissions.class);
    }
}

