/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.util.Base64;
import javax.baja.io.BIContextEncodable;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BPasswordHistory
extends BSimple
implements BIContextEncodable {
    public static final BPasswordHistory DEFAULT = new BPasswordHistory();
    public static final Type TYPE = Sys.loadType(BPasswordHistory.class);
    private BPassword[] passwords = new BPassword[0];
    private String salt = null;
    private int iterationCount = 0;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPasswordHistory add(String username, BPassword password) {
        return this.add(username, password, this.passwords.length + 1);
    }

    public BPasswordHistory add(String username, BPassword password, int maximumHistorySize) {
        if (!password.getPasswordEncoder().isReversible()) {
            throw new BajaRuntimeException("Cannot add " + password.getEncodingType() + " encoded passwords to BPasswordHistory.");
        }
        if (maximumHistorySize < 0) {
            throw new InvalidParameterException("History size must be zero or greater.");
        }
        if (maximumHistorySize == 0) {
            return DEFAULT;
        }
        BPassword convertedPassword = this.getConvertedPassword(password);
        if (this.contains(username, password, convertedPassword, maximumHistorySize)) {
            throw new BajaRuntimeException("Duplicate password.");
        }
        BPasswordHistory newHistory = new BPasswordHistory();
        newHistory.passwords = new BPassword[Math.min(maximumHistorySize, this.passwords.length + 1)];
        newHistory.passwords[0] = convertedPassword;
        if (this.passwords.length > 0) {
            System.arraycopy(this.passwords, 0, newHistory.passwords, 1, Math.min(maximumHistorySize - 1, this.passwords.length));
        }
        newHistory.initSaltAndIterationCount();
        return newHistory;
    }

    private String getOldPasswordHash(String username, BPassword password) {
        String value;
        try {
            value = AccessController.doPrivileged(password.getPasswordEncoder()::getValue);
        }
        catch (Exception e1) {
            throw new SecurityException();
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(value.getBytes());
            md.update((TextUtil.bytesToHexString((byte[])md.digest()) + "H" + username).getBytes());
            return TextUtil.bytesToHexString((byte[])md.digest());
        }
        catch (Exception e) {
            return String.valueOf(value.hashCode());
        }
    }

    public boolean contains(String username, BPassword password) {
        return this.contains(username, password, this.passwords.length);
    }

    public boolean contains(String username, BPassword password, int historySize) {
        return this.contains(username, password, null, historySize);
    }

    public boolean contains(String username, BPassword password, BPassword prehashedPassword, int historySize) {
        if (password.getPasswordEncoder().isReversible()) {
            String encodedValue = null;
            if (prehashedPassword != null) {
                encodedValue = prehashedPassword.getPasswordEncoder().getEncodedValue();
            }
            for (int i = 0; i < Math.min(this.passwords.length, historySize); ++i) {
                if (this.passwords[i].getPasswordEncoder().isReversible()) {
                    try {
                        if (!AccessController.doPrivileged(this.passwords[i].getPasswordEncoder()::getValue).equals(this.getOldPasswordHash(username, password))) continue;
                        return true;
                    }
                    catch (Exception e) {
                        throw new SecurityException();
                    }
                }
                if (!this.passwords[i].getEncodingType().equals(BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE)) continue;
                if (encodedValue == null) {
                    encodedValue = this.getConvertedPassword(password).getPasswordEncoder().getEncodedValue();
                }
                if (!this.passwords[i].getPasswordEncoder().getEncodedValue().equals(encodedValue)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.passwords.length;
    }

    @Override
    public void encode(DataOutput encoder) throws IOException {
        this.encode(encoder, null);
    }

    @Override
    public void encode(DataOutput encoder, Context context) throws IOException {
        encoder.writeInt(this.passwords.length);
        for (BPassword password : this.passwords) {
            encoder.writeUTF(password.encodeToString(context));
        }
    }

    @Override
    public BObject decode(DataInput decoder) throws IOException {
        return this.decode(decoder, null);
    }

    @Override
    public BObject decode(DataInput decoder, Context context) throws IOException {
        BPasswordHistory passwordHistory = new BPasswordHistory();
        passwordHistory.passwords = new BPassword[decoder.readInt()];
        for (int i = 0; i < passwordHistory.passwords.length; ++i) {
            passwordHistory.passwords[i] = (BPassword)BPassword.DEFAULT.decodeFromString(decoder.readUTF());
        }
        passwordHistory.initSaltAndIterationCount();
        return passwordHistory;
    }

    @Override
    public String encodeToString() throws IOException {
        return this.encodeToString(null);
    }

    @Override
    public String encodeToString(Context context) throws IOException {
        StringBuilder buffer = new StringBuilder();
        if (this.passwords.length > 0) {
            for (BPassword password : this.passwords) {
                buffer.append(password.encodeToString(context)).append("|");
            }
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return Base64.getEncoder().encodeToString(buffer.toString().getBytes());
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        return this.decodeFromString(s, null);
    }

    @Override
    public BObject decodeFromString(String s, Context context) throws IOException {
        BPasswordHistory passwordHistory = new BPasswordHistory();
        String[] passwordStrs = TextUtil.split((String)new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8), (char)'|');
        passwordHistory.passwords = new BPassword[passwordStrs.length];
        for (int i = 0; i < passwordStrs.length; ++i) {
            try {
                passwordHistory.passwords[i] = (BPassword)BPassword.DEFAULT.decodeFromString(passwordStrs[i]);
                continue;
            }
            catch (IOException ioe) {
                passwordHistory.passwords[i] = BPassword.make(passwordStrs[i], context);
            }
        }
        passwordHistory.initSaltAndIterationCount();
        return passwordHistory;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BPasswordHistory)) {
            return false;
        }
        BPasswordHistory passwordHistory = (BPasswordHistory)obj;
        if (passwordHistory.passwords.length != this.passwords.length) {
            return false;
        }
        for (int i = 0; i < passwordHistory.passwords.length; ++i) {
            if (passwordHistory.passwords[i].equals(this.passwords[i])) continue;
            return false;
        }
        return true;
    }

    private void initSaltAndIterationCount() {
        if (this.salt == null) {
            for (BPassword password : this.passwords) {
                if (!password.getEncodingType().equals(BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE)) continue;
                BPbkdf2HmacSha256PasswordEncoder encoder = (BPbkdf2HmacSha256PasswordEncoder)password.getPasswordEncoder();
                this.salt = encoder.getSalt();
                this.iterationCount = encoder.getIterationCount();
                return;
            }
        }
    }

    private BPassword getConvertedPassword(BPassword password) {
        try {
            if (this.salt != null && this.iterationCount != 0) {
                BPbkdf2HmacSha256PasswordEncoder encoder = new BPbkdf2HmacSha256PasswordEncoder();
                encoder.encode(AccessController.doPrivileged(password.getPasswordEncoder()::getValue), this.salt, this.iterationCount);
                return BPassword.make(encoder);
            }
            return BPassword.make(AccessController.doPrivileged(password.getPasswordEncoder()::getValue), BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE);
        }
        catch (Exception e) {
            throw new SecurityException();
        }
    }
}

