/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.security.SecretChars;
import com.tridium.user.BUserPasswordConfiguration;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicReference;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordCache;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.CannotValidateException;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="passwordConfig", type="baja:UserPasswordConfiguration", defaultValue="new BUserPasswordConfiguration()")})
public class BPasswordAuthenticator
extends BPasswordCache {
    public static final Property password = BPasswordAuthenticator.newProperty(256, BPassword.DEFAULT, BFacets.make(BFacets.make("fieldEditor", "wbutil:UserPasswordFE"), BFacets.make("uxFieldEditor", "webEditors:UserPasswordEditor")));
    public static final Property passwordConfig = BPasswordAuthenticator.newProperty(0, new BUserPasswordConfiguration(), null);
    public static final Type TYPE = Sys.loadType(BPasswordAuthenticator.class);
    public static final Context pwConverted = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public String toString() {
            return "Context.pwConverted";
        }
    };
    public static final BPasswordAuthenticator DEFAULT = new BPasswordAuthenticator();

    public BUserPasswordConfiguration getPasswordConfig() {
        return (BUserPasswordConfiguration)this.get(passwordConfig);
    }

    public void setPasswordConfig(BUserPasswordConfiguration v) {
        this.set(passwordConfig, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPasswordAuthenticator() {
    }

    public BPasswordAuthenticator(BPassword value) {
        this.setPassword(value);
    }

    @Override
    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 2: {
                BComponentSpace space = this.getComponentSpace();
                if (space != null && !space.fireDirectCallbacks()) break;
                this.fwChanged((Property)a, (Context)b);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public void started() {
        if (this.isInUserService()) {
            this.convertToPbkdf2Password();
        }
    }

    @Override
    public void changed(Property property, Context context) {
        BComplex parent;
        if (!this.isRunning()) {
            return;
        }
        if (property == passwordConfig && (parent = this.getParent()) instanceof BComponent) {
            parent.asComponent().changed(this.getPropertyInParent(), context);
        }
        if (property.getType() == BPassword.TYPE) {
            this.invalidUserSessions((BUser)this.getParent());
        }
    }

    private void fwChanged(Property prop, Context cx) {
        if (this.isInUserService() && password.equals(prop) && cx != pwConverted) {
            this.convertToPbkdf2Password();
        }
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (property == password) {
            return new IPropertyValidator(){

                @Override
                public void validateSet(Validatable validatable, Context context) {
                    if (context != pwConverted) {
                        BPasswordAuthenticator.this.checkPassword((BPassword)validatable.getProposedValue(password), context);
                    }
                }
            };
        }
        return null;
    }

    public void checkPassword(BPassword newPassword, Context context) {
        BComplex parent = this.getParent();
        if (parent instanceof BUser) {
            BUser user = (BUser)parent;
            user.lease(1);
            BAuthenticationScheme scheme = user.getAuthenticationScheme();
            if (scheme instanceof BPasswordAuthenticationScheme) {
                scheme.lease(1);
                BPasswordAuthenticator.checkPassword(user, (BPasswordAuthenticationScheme)scheme, this.getPasswordConfig(), newPassword, context);
            }
        }
    }

    public static void checkPassword(BUser user, BPasswordAuthenticationScheme scheme, BUserPasswordConfiguration config, BPassword newPassword, Context context) {
        if (!newPassword.getPasswordEncoder().isReversible()) {
            return;
        }
        try {
            BPasswordStrength strength = scheme.getGlobalPasswordConfiguration().getPasswordStrength();
            try (SecretChars passChars = AccessController.doPrivileged(newPassword::getSecretChars);){
                AtomicReference messageRef = new AtomicReference();
                if (!strength.isPasswordValid(passChars.get(), messageRef::set)) {
                    throw new LocalizableRuntimeException("baja", ((Localizable)messageRef.get()).toString(context));
                }
            }
            if (user != null && scheme.isDuplicatePassword(newPassword, user)) {
                throw new LocalizableRuntimeException("baja", "user.strongPassword.alreadyUsed");
            }
            if (config != null) {
                config.changeIntervalCheck(scheme.getGlobalPasswordConfiguration());
            }
        }
        catch (LocalizableRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CannotValidateException(e);
        }
    }

    private boolean isInUserService() {
        if (this.getParent() != null) {
            BComplex parent = this.getParent().getParent();
            return parent instanceof BUserService;
        }
        return false;
    }

    @Override
    public boolean canLogin() {
        return true;
    }

    public boolean convertToPbkdf2Password() {
        BPassword oldPw = this.getPassword();
        if (oldPw.getPasswordEncoder().isReversible()) {
            this.getPasswordConfig().passwordModified();
            BPassword newPw = BPassword.make(AccessController.doPrivileged(oldPw::getValue), BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE);
            this.set("password", (BValue)newPw, pwConverted);
            return true;
        }
        return false;
    }
}

