/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.nre.security.NullAlgorithmBundle;
import com.tridium.nre.security.SecretChars;
import java.security.SecureRandom;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Password"})})
public final class BNullPasswordEncoder
extends BAbstractPasswordEncoder
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BNullPasswordEncoder.class);
    public static final NullAlgorithmBundle ALGORITHM_BUNDLE = NullAlgorithmBundle.getInstance();
    public static final String ENCODING_TYPE = ALGORITHM_BUNDLE.getAlgorithmName();

    @Override
    public Type getType() {
        return TYPE;
    }

    public static String getEncodedDefaultPassword() {
        return ALGORITHM_BUNDLE.encode(null);
    }

    @Override
    public boolean isReversible() {
        return false;
    }

    @Override
    public void encode(SecretChars password) throws Exception {
        if (password.get().length > 0) {
            throw new IllegalArgumentException("Null password encoder should not be used with nonempty passwords");
        }
    }

    @Override
    public void parse(String key) throws Exception {
    }

    @Override
    public String getValue() throws Exception {
        return new String(this.getSecretChars().get());
    }

    @Override
    public SecretChars getSecretChars() throws Exception {
        byte[] val = new byte[16];
        new SecureRandom().nextBytes(val);
        return SecretChars.fromString((String)ByteArrayUtil.toHexString((byte[])val));
    }

    @Override
    public String getEncodingType() {
        return ENCODING_TYPE;
    }

    @Override
    public boolean validate(SecretChars password) throws Exception {
        return false;
    }

    @Override
    public String getEncodedValue() {
        return "";
    }
}

