/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.nre.security.AbstractAesAlgorithmBundle;
import com.tridium.nre.security.Aes256PasswordManager;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.KeyRingPermission;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecurityInitializer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BReversiblePasswordEncoder;
import javax.baja.security.MissingEncodingKeyException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BAbstractAes256PasswordEncoder
extends BReversiblePasswordEncoder {
    public static final Type TYPE = Sys.loadType(BAbstractAes256PasswordEncoder.class);
    protected String cipher = null;
    protected String iv = null;
    protected String keyAlias = null;

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void encode(SecretBytes passwordBytes) throws Exception {
        byte[] ivBytes = new byte[16];
        new SecureRandom().nextBytes(ivBytes);
        this.iv = ByteArrayUtil.toHexString((byte[])ivBytes);
        String aesTransformation = this.getAesTransformation();
        if (this.usesExternalEncryptionKey()) {
            if (!this.getEncryptionKey().isPresent()) throw new MissingEncodingKeyException();
            this.cipher = ByteArrayUtil.toHexString((byte[])Aes256PasswordManager.encrypt((byte[])passwordBytes.get(), (byte[])ivBytes, (byte[])this.getEncryptionKey().get(), (String)aesTransformation));
            return;
        } else {
            this.cipher = AccessController.doPrivileged(() -> {
                ISecurityInfoProvider provider = SecurityInitializer.getInstance().getSecurityInfoProvider();
                return ByteArrayUtil.toHexString((byte[])Aes256PasswordManager.getManager((KeyRing)provider.getKeyRing(), (String)this.keyAlias).encrypt(passwordBytes.get(), ivBytes, aesTransformation));
            });
        }
    }

    @Override
    public SecretBytes getSecretBytes() throws Exception {
        String aesTransformation = this.getAesTransformation();
        if (this.usesExternalEncryptionKey()) {
            if (this.getEncryptionKey().isPresent()) {
                return Aes256PasswordManager.decryptSecret((byte[])this.getEncryptionKey().get(), (byte[])ByteArrayUtil.hexStringToBytes((String)this.cipher), (byte[])ByteArrayUtil.hexStringToBytes((String)this.iv), (String)aesTransformation);
            }
            throw new MissingEncodingKeyException();
        }
        ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
        try {
            return Aes256PasswordManager.getManager((KeyRing)provider.getKeyRing(), (String)this.keyAlias).decryptSecret(this.cipher, this.iv, aesTransformation);
        }
        catch (AccessControlException e) {
            String alternateOwner = this.getAlternateOwner();
            if (alternateOwner != null) {
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission((Permission)new KeyRingPermission(alternateOwner));
                    }
                    return AccessController.doPrivileged(() -> Aes256PasswordManager.getManager((KeyRing)provider.getKeyRing(), (String)this.keyAlias).decryptSecret(this.cipher, this.iv, aesTransformation));
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public boolean validate(SecretBytes secret) throws Exception {
        return AccessController.doPrivileged(() -> {
            try (SecretBytes myBytes = this.getSecretBytes();){
                Boolean bl = SecurityUtil.equals((byte[])secret.get(), (byte[])myBytes.get());
                return bl;
            }
            catch (SecurityException e) {
                return false;
            }
            catch (MissingEncodingKeyException meke) {
                return false;
            }
        });
    }

    @Override
    public void transcode(String encodedValue, Optional<ISecretBytesSupplier> key) throws Exception {
        try {
            String encodingType = CryptographicAlgorithmBundle.extractName((String)encodedValue);
            BAbstractAes256PasswordEncoder encoder = (BAbstractAes256PasswordEncoder)BAbstractPasswordEncoder.make(encodingType);
            encoder.parse(encodedValue);
            String[] data = this.getAlgorithmBundle().decode(encodedValue);
            Objects.requireNonNull(data);
            String oldIv = encoder.iv;
            byte[] oldIvBytes = ByteArrayUtil.hexStringToBytes((String)oldIv);
            String oldCipher = encoder.cipher;
            byte[] oldCipherBytes = ByteArrayUtil.hexStringToBytes((String)oldCipher);
            byte[] cipherBytes = null;
            this.keyAlias = encoder.keyAlias;
            if (!key.isPresent() && !this.usesExternalEncryptionKey() || this.usesExternalEncryptionKey() && key.isPresent() && this.validateExternalEncryptionKey(key)) {
                cipherBytes = oldCipherBytes;
            } else if (key.isPresent() && this.usesExternalEncryptionKey() && this.getEncryptionKey().isPresent()) {
                cipherBytes = Aes256PasswordManager.transcode((byte[])oldCipherBytes, (byte[])oldIvBytes, (byte[])((SecretBytes)key.get().get()).get(), (byte[])this.getEncryptionKey().get(), (String)encoder.getAesTransformation(), (String)this.getAesTransformation());
            } else {
                ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
                Aes256PasswordManager manager = Aes256PasswordManager.getManager((KeyRing)provider.getKeyRing(), (String)this.keyAlias);
                if (!key.isPresent() && this.usesExternalEncryptionKey() && this.getEncryptionKey().isPresent()) {
                    cipherBytes = manager.transcodeFromKeyring(oldCipherBytes, oldIvBytes, this.getEncryptionKey().get(), encoder.getAesTransformation(), this.getAesTransformation());
                } else if (key.isPresent() && !this.usesExternalEncryptionKey()) {
                    cipherBytes = manager.transcodeToKeyring(oldCipherBytes, oldIvBytes, ((SecretBytes)key.get().get()).get(), encoder.getAesTransformation(), this.getAesTransformation());
                }
            }
            if (cipherBytes == null) {
                throw new SecurityException();
            }
            this.cipher = ByteArrayUtil.toHexString((byte[])cipherBytes);
            this.iv = oldIv;
        }
        catch (AccessControlException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getAlternateOwner() {
        return null;
    }

    protected abstract EncryptionAlgorithmBundle getAlgorithmBundle();

    private String getAesTransformation() {
        EncryptionAlgorithmBundle bundle = this.getAlgorithmBundle();
        if (bundle instanceof AbstractAesAlgorithmBundle) {
            return ((AbstractAesAlgorithmBundle)bundle).getAesTransformation();
        }
        return "AES/GCM/NoPadding";
    }
}

