/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.query;

import com.tridium.sys.Nre;
import com.tridium.sys.tag.BEntityObjectWrapper;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BIQueryHandler;
import javax.baja.query.BQueryResult;
import javax.baja.space.BISpace;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIEntity;
import javax.baja.tag.BIEntitySpace;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.util.BasicEntity;

@NiagaraType
public abstract class BQueryScheme
extends BOrdScheme {
    public static final Type TYPE = Sys.loadType(BQueryScheme.class);
    public static final String QUERY_LIMIT_FACET_KEY = "queryLimit";
    public static final String ALTERNATE_SCOPE_FACET_KEY = "alternateQueryScope";
    public static final String MAKE_ENTITY_FOR_ALTERNATE_SCOPE_FACET_KEY = "makeEntityForAlternateScope";
    private static final SortedSet<PriorityHandler> priorityHandlers = Collections.synchronizedSortedSet(new TreeSet());

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BQueryScheme(String id) {
        super(id);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        BIQueryHandler handler;
        BObject baseObj;
        if (base.getFacet("namespace") == null && ((baseObj = base.get()) instanceof BISpaceNode || baseObj instanceof BISpace)) {
            String defaultNamespace;
            TagDictionaryService service;
            BISpace space = null;
            space = baseObj instanceof BISpace ? (BISpace)baseObj.as(BSpace.class) : baseObj.as(BISpaceNode.class).getSpace();
            if (space instanceof BIEntitySpace && (service = ((BIEntitySpace)space).getTagDictionaryService()) != null && (defaultNamespace = service.getDefaultNamespace()) != null) {
                base = OrdTarget.makeWithFacets(base, BFacets.make("namespace", defaultNamespace));
            }
        }
        OrdTarget scope = base;
        BObject alternateScopeOrd = base.getFacet(ALTERNATE_SCOPE_FACET_KEY);
        if (alternateScopeOrd != null) {
            BOrd ord = BOrd.make(alternateScopeOrd.toString());
            if (base.getFacet(MAKE_ENTITY_FOR_ALTERNATE_SCOPE_FACET_KEY) == BBoolean.TRUE) {
                BIEntity entity = BEntityObjectWrapper.makeEntityObject(new BasicEntity(ord));
                scope = new OrdTarget(base, (BObject)((Object)entity));
            } else {
                scope = ord.resolve(BLocalHost.INSTANCE, base);
            }
        }
        if ((handler = BQueryScheme.doFindQueryHandler(base, scope, (BQueryScheme)BOrdScheme.lookup(query.getScheme()))) == null) {
            throw new UnresolvedException("No available query handler for " + scope.get());
        }
        return new OrdTarget(base, new BQueryResult(query, scope, handler));
    }

    public static BIQueryHandler findQueryHandler(OrdTarget scope, BQueryScheme queryScheme) {
        return BQueryScheme.doFindQueryHandler(scope, scope, queryScheme);
    }

    private static BIQueryHandler doFindQueryHandler(OrdTarget base, OrdTarget scope, BQueryScheme queryScheme) {
        BIQueryHandler handler = null;
        BObject baseObj = base.get();
        if (baseObj instanceof BIQueryHandler && ((BIQueryHandler)((Object)baseObj)).canHandle(scope, queryScheme)) {
            handler = (BIQueryHandler)((Object)baseObj);
        }
        if (handler == null) {
            Iterator iterator = priorityHandlers.iterator();
            while (handler == null && iterator.hasNext()) {
                BIQueryHandler priorityHandler = ((PriorityHandler)iterator.next()).handler;
                if (!priorityHandler.canHandle(scope, queryScheme)) continue;
                handler = priorityHandler;
            }
            if (handler == null) {
                AgentList targetAgents = baseObj.getAgents().filter(AgentFilter.is(BIQueryHandler.TYPE));
                AgentList schemeAgents = queryScheme.getAgents().filter(AgentFilter.is(BIQueryHandler.TYPE));
                int taCount = targetAgents.size();
                for (int i = 0; i < taCount; ++i) {
                    AgentInfo agent = targetAgents.get(i);
                    if (schemeAgents.indexOf(agent) == -1) continue;
                    handler = (BIQueryHandler)((Object)agent.getInstance());
                    break;
                }
            }
        }
        return handler;
    }

    public static void registerPriorityQueryHandler(BIQueryHandler handler, int priority) {
        Objects.requireNonNull(handler, "Cannot register a null priority query handler");
        if (priorityHandlers.stream().anyMatch(pHandler -> priority == pHandler.priority || pHandler.handler.equals(handler))) {
            throw new IllegalStateException("Cannot re-register a priority query handler or register one with a priority level already in use");
        }
        PriorityHandler priorityHandler = new PriorityHandler(handler, priority);
        priorityHandlers.add(priorityHandler);
    }

    public static boolean unregisterPriorityQueryHandler(BIQueryHandler handler) {
        return priorityHandlers.removeIf(pHandler -> pHandler.handler.equals(handler));
    }

    public static void postInit() {
        if (Nre.spySysManagers.find("queryHandlers") == null) {
            Nre.spySysManagers.add("queryHandlers", new Page());
        }
    }

    private static class Page
    extends Spy {
        private Page() {
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            if (priorityHandlers.isEmpty()) {
                out.write("No priority query handlers registered");
                return;
            }
            out.startTable(true);
            out.w("<tr>");
            out.thTitle("Priority Level");
            out.thTitle("Registered Priority Query Handler");
            out.thTitle("Type");
            out.w("</tr>");
            priorityHandlers.forEach(pHandler -> {
                BComponent comp;
                BIQueryHandler handler = pHandler.handler;
                String objString = handler.toString();
                if (handler instanceof BComponent && (comp = (BComponent)((Object)handler)).getSlotPath() != null) {
                    objString = comp.toDisplayPathString(null);
                }
                out.w("<tr>");
                out.td(pHandler.priority);
                out.w("<td align='left' nowrap='true'>").safe(objString).w("</td>");
                out.w("<td align='left' nowrap='true'>").safe(handler.getType().toString()).w("</td>");
                out.w("</tr>");
            });
            out.endTable();
        }
    }

    private static class PriorityHandler
    implements Comparable<PriorityHandler> {
        BIQueryHandler handler;
        int priority;

        public PriorityHandler(BIQueryHandler handler, int priority) {
            this.handler = handler;
            this.priority = priority;
        }

        @Override
        public int compareTo(PriorityHandler o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

