/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavContainer;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public abstract class BNavContainer
extends BObject
implements BINavNode,
BINavContainer {
    public static final Type TYPE = Sys.loadType(BNavContainer.class);
    BINavNode parent;
    String name;
    LexiconText lexText;
    List<BINavNode> byOrder = new ArrayList<BINavNode>();
    Map<String, BINavNode> byName = new HashMap<String, BINavNode>();

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BNavContainer(String name, LexiconText lexText) {
        this.name = name;
        this.lexText = lexText;
    }

    protected BNavContainer(String name) {
        this.name = name;
    }

    public LexiconText getLexiconText() {
        return this.lexText;
    }

    public void setLexiconText(LexiconText lexText) {
        this.lexText = lexText;
    }

    @Override
    public String getNavName() {
        return this.name;
    }

    @Override
    public String getNavDisplayName(Context cx) {
        if (this.lexText != null) {
            return this.lexText.getText(cx);
        }
        return this.getNavName();
    }

    @Override
    public String getNavDescription(Context cx) {
        if (this.lexText != null) {
            return Lexicon.make(this.lexText.module, cx).get(this.lexText.key + ".description", null);
        }
        return null;
    }

    @Override
    public BINavNode getNavParent() {
        return this.parent;
    }

    @Override
    public boolean hasNavChildren() {
        return !this.byName.isEmpty();
    }

    @Override
    public BINavNode getNavChild(String navName) {
        return this.byName.get(navName);
    }

    @Override
    public BINavNode resolveNavChild(String navName) {
        BINavNode node = this.getNavChild(navName);
        if (node == null) {
            throw new UnresolvedException(navName);
        }
        return node;
    }

    @Override
    public BINavNode[] getNavChildren() {
        return this.byOrder.toArray(new BINavNode[this.byOrder.size()]);
    }

    @Override
    public BIcon getNavIcon() {
        return this.getIcon();
    }

    @Override
    public void addNavChild(BINavNode child) {
        String name = child.getNavName();
        if (this.byName.get(name) != null) {
            throw new IllegalArgumentException("duplicate name " + name);
        }
        this.byName.put(name, child);
        this.byOrder.add(child);
        if (child instanceof BNavContainer) {
            BNavContainer container = (BNavContainer)child;
            container.parent = this;
        }
        this.fireNavEvent(NavEvent.makeAdded(this, name, null));
    }

    @Override
    public void removeNavChild(BINavNode child) {
        String name = child.getNavName();
        if (this.byName.get(name) != child) {
            throw new IllegalArgumentException("not child " + name);
        }
        this.byName.remove(name);
        this.byOrder.remove(child);
        if (child instanceof BNavContainer) {
            BNavContainer container = (BNavContainer)child;
            container.parent = null;
        }
        this.fireNavEvent(NavEvent.makeRemoved(this, name, null));
    }

    protected void clearNavChildren() {
        this.byName.clear();
        this.byOrder.clear();
    }

    @Override
    public void reorderNavChildren(BINavNode[] children) {
        if (children.length != this.byOrder.size()) {
            throw new IllegalArgumentException("children.length != getNavChildren().length");
        }
        ArrayList<BINavNode> newList = new ArrayList<BINavNode>(children.length);
        String[] newNames = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            BINavNode child = children[i];
            String name = child.getNavName();
            if (this.byName.get(name) != child) {
                throw new IllegalStateException("children at " + i + " not in getNavChildren()");
            }
            newList.add(child);
            newNames[i] = name;
        }
        this.byOrder = newList;
        this.fireNavEvent(NavEvent.makeReordered(this, newNames, null));
    }

    protected void fireNavEvent(NavEvent event) {
        BNavRoot.INSTANCE.fireNavEvent(event);
    }

    @Override
    public String toString(Context cx) {
        return this.name;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle("NavContainer", 2);
        out.prop((Object)"navName", this.getNavName());
        out.prop((Object)"navDisplayName", this.getNavDisplayName(null));
        out.prop((Object)"navOrd", this.getNavOrd());
        out.endProps();
        BINavNode[] kids = this.getNavChildren();
        if (kids != null && kids.length > 0) {
            out.startTable(false);
            out.trTitle("Children", 1);
            for (int i = 0; i < kids.length; ++i) {
                BObject kid = (BObject)((Object)kids[i]);
                if (kid == null) {
                    out.tr("ERROR NULL");
                    continue;
                }
                String navName = kids[i].getNavName();
                out.tr().td().a(SlotPath.escape(navName), navName).w(" [").safe(kid.getType()).w("] ").safe(kid).endTd().endTr();
            }
            out.endTable();
        }
    }

    public static BINavNode[] filter(BINavNode[] nodes, Context cx) {
        try {
            if (cx == null || cx.getUser() == null) {
                return nodes;
            }
            ArrayList<BINavNode> acc = new ArrayList<BINavNode>(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                BPermissions p;
                BINavNode node = nodes[i];
                if (node instanceof BIProtected && !(p = ((BIProtected)((Object)node)).getPermissions(cx)).has(1)) continue;
                acc.add(node);
            }
            return acc.toArray(new BINavNode[acc.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return nodes;
        }
    }
}

