/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import com.tridium.util.EscUtil;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.SyntaxException;

public class TagPath
implements OrdQuery {
    private String namespace;
    private String tag;

    public TagPath(String body) throws SyntaxException {
        int index = body.indexOf(58);
        if (index > 0) {
            this.namespace = body.substring(0, index);
            this.tag = body.substring(index);
        }
        if (index == 0) {
            this.namespace = null;
            this.tag = body.substring(1);
        } else {
            this.namespace = null;
            this.tag = body;
        }
    }

    public TagPath(String namespace, String tag) throws SyntaxException {
        this.namespace = namespace;
        this.tag = tag;
    }

    protected boolean isValidTagName(String name) {
        return EscUtil.slot.isValid(name);
    }

    protected boolean isValidNamespace(String namespace) {
        if (namespace == null || namespace.isEmpty()) {
            return true;
        }
        return EscUtil.slot.isValid(namespace);
    }

    public static String escape(String s) {
        return EscUtil.slot.escape(s);
    }

    public static String unescape(String s) {
        return EscUtil.slot.unescape(s);
    }

    @Override
    public boolean isHost() {
        return false;
    }

    @Override
    public boolean isSession() {
        return false;
    }

    @Override
    public String getScheme() {
        return "tag";
    }

    @Override
    public String getBody() {
        if (this.namespace == null || this.namespace.isEmpty()) {
            return this.tag;
        }
        return this.namespace + ":" + this.tag;
    }

    @Override
    public void normalize(OrdQueryList list, int index) {
    }

    public String toDisplayString() {
        if (this.namespace == null || this.namespace.isEmpty()) {
            return TagPath.unescape(this.tag);
        }
        return TagPath.unescape(this.namespace) + ":" + TagPath.unescape(this.tag);
    }

    @Override
    public String toString() {
        if (this.namespace == null || this.namespace.isEmpty()) {
            return this.tag;
        }
        return this.namespace + ":" + this.tag;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTag() {
        return this.tag;
    }
}

