/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;

public class BServiceScheme
extends BOrdScheme {
    public static final BServiceScheme INSTANCE = new BServiceScheme();
    public static final Type TYPE = Sys.loadType(BServiceScheme.class);

    private BServiceScheme() {
        super("service");
    }

    @Override
    public OrdQuery parse(String queryBody) {
        if (queryBody.length() < 3 || queryBody.indexOf(58) <= 0) {
            throw new SyntaxException("Not a typespec: \"" + queryBody + "\"");
        }
        return new ServiceQuery(queryBody);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        BComponent service = null;
        try {
            BTypeSpec typeSpec = BTypeSpec.make(query.getBody());
            Type type = typeSpec.getResolvedType();
            BISession session = BOrd.toSession(base.get());
            if (session == null) {
                throw new InvalidOrdBaseException("" + base);
            }
            if (!(session instanceof ServiceSession)) {
                throw new InvalidOrdBaseException("Session does not support services");
            }
            service = ((ServiceSession)((Object)session)).getService(type);
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
        }
        catch (TypeNotFoundException typeNotFoundException) {
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        if (service == null) {
            throw new UnresolvedException("Service not found: " + query.getBody());
        }
        return new OrdTarget(base, service);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static class ServiceQuery
    implements OrdQuery {
        String body;

        ServiceQuery(String body) {
            this.body = body;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        @Override
        public boolean isSession() {
            return false;
        }

        @Override
        public void normalize(OrdQueryList list, int index) {
            list.shiftToSession(index);
        }

        @Override
        public String getScheme() {
            return "service";
        }

        @Override
        public String getBody() {
            return this.body;
        }

        @Override
        public String toString() {
            return "service:" + this.body;
        }
    }

    public static interface ServiceSession {
        public BComponent getService(Type var1);
    }
}

