/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.naming;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BLocalScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.BServiceScheme;
import javax.baja.nav.BNavRoot;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.space.BISpace;
import javax.baja.space.BISpaceContainer;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;

@NiagaraType
public class BLocalHost
extends BIpHost
implements BISession,
BServiceScheme.ServiceSession,
BISpaceContainer {
    public static final Type TYPE = Sys.loadType(BLocalHost.class);
    static final BIcon icon = BIcon.std("localhost.png");
    public static final BLocalHost INSTANCE = new BLocalHost();
    private String navNameSuffix;
    private HashMap<BISpace, BISpace> spaces = new HashMap();

    @Override
    public Type getType() {
        return TYPE;
    }

    private BLocalHost() {
        super("localhost");
    }

    @Override
    public BOrd getAbsoluteOrd() {
        return BLocalScheme.ORD;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void connect() throws Exception {
    }

    @Override
    public BHost getHost() {
        return this;
    }

    @Override
    public BOrd getOrdInHost() {
        return BOrd.make("");
    }

    @Override
    public Context getSessionContext() {
        return null;
    }

    @Override
    public BISpace mountSpace(BISpace space) {
        if (this.spaces.containsKey(space)) {
            throw new IllegalArgumentException("Space already mounted " + space);
        }
        this.spaces.put(space, space);
        space.setSpaceContainer(this);
        return space;
    }

    @Override
    public void unmountSpace(BISpace space) {
        if (!this.spaces.containsKey(space)) {
            throw new IllegalArgumentException("Space not mounted " + space);
        }
        this.spaces.remove(space);
        space.setSpaceContainer(null);
    }

    @Override
    public Iterator<BISpace> getSpaces() {
        Collection<BISpace> spaceCollection = this.spaces.values();
        return spaceCollection.iterator();
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 404: {
                if (a != null) {
                    try {
                        if (b == null) {
                            ModuleInfo[] info = Sys.getRegistry().getModules((String)a);
                            return info[0].getVendorVersion();
                        }
                        ModuleInfo info = Sys.getRegistry().getModule((String)a, RuntimeProfile.valueOf((String)((String)b)));
                        return info.getVendorVersion();
                    }
                    catch (ModuleNotFoundException mnfe) {
                        return Version.NULL;
                    }
                }
                return Sys.getBajaVersion();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public BComponent getService(Type type) {
        return Sys.getService(type);
    }

    @Override
    public String getDefaultNavDisplayName(Context cx) {
        if (this.getLexiconText() == null) {
            this.setLexiconText(LexiconText.make("baja", "nav.localHost"));
        }
        if (this.navNameSuffix == null) {
            try {
                this.navNameSuffix = " : " + Sys.getHostName();
            }
            catch (Exception e) {
                this.navNameSuffix = "";
            }
        }
        return this.appendStationName(this.getLexiconText().getText(cx) + this.navNameSuffix);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    static {
        BNavRoot.INSTANCE.addNavChild(INSTANCE);
        cache.put("localhost", INSTANCE);
        ++cachedLocalHostCount;
        try {
            String localhost = TextUtil.toLowerCase((String)Sys.getHostName());
            if (!localhost.equals("localhost")) {
                cache.put(localhost, INSTANCE);
                ++cachedLocalHostCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

