/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.log;

import com.tridium.logging.BILoggingService;
import com.tridium.logging.LogSettings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Sys;

public final class Log {
    public static final int NONE = 4;
    public static final int ERROR = 3;
    public static final int WARNING = 2;
    public static final int MESSAGE = 1;
    public static final int TRACE = 0;
    private static Hashtable<String, Log> logs = new Hashtable();
    private static Properties props;
    private final Logger delegate;
    private final String logName;

    public static String severityToString(int severity) {
        switch (severity) {
            case 0: {
                return "trace";
            }
            case 1: {
                return "message";
            }
            case 2: {
                return "warning";
            }
            case 3: {
                return "error";
            }
            case 4: {
                return "none";
            }
        }
        throw new IllegalArgumentException();
    }

    public static int severityFromString(String s) {
        if ("trace".equals(s)) {
            return 0;
        }
        if ("message".equals(s)) {
            return 1;
        }
        if ("warning".equals(s)) {
            return 2;
        }
        if ("error".equals(s)) {
            return 3;
        }
        if ("none".equals(s)) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    public static synchronized Log[] getLogs() {
        Object[] a = new Log[logs.size()];
        Object[] names = new String[a.length];
        Enumeration<Log> e = logs.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            a[i] = e.nextElement();
            names[i] = ((Log)a[i]).getLogName().toLowerCase();
            ++i;
        }
        SortUtil.sort((Object[])names, (Object[])a);
        return a;
    }

    public static synchronized boolean isLog(String logName) {
        return logs.containsKey(logName);
    }

    public static synchronized Log getLog(String logName) {
        Log log = logs.get(logName);
        if (log != null) {
            return log;
        }
        Logger logger = Logger.getLogger(logName);
        Level level = logger.getLevel();
        if (level == null) {
            for (Logger parentLogger = logger.getParent(); parentLogger != null && (level = parentLogger.getLevel()) == null; parentLogger = parentLogger.getParent()) {
            }
            if (level == null) {
                level = Logger.getLogger("").getLevel();
            }
        }
        int severity = Log.levelToSeverity(level);
        log = AccessController.doPrivileged(() -> new Log(logName, severity));
        logs.put(logName, log);
        return log;
    }

    public static synchronized void deleteLog(String logName) {
        Log log = logs.get(logName);
        if (log != null) {
            log.delegate.setLevel(Level.OFF);
            BILoggingService loggingService = Log.getLoggingService();
            try {
                LogSettings settings = new LogSettings(loggingService.readLogSettings());
                settings.removeLogSettings(logName);
                loggingService.reload(settings.getRawProperties());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logs.remove(logName);
    }

    public static int levelToSeverity(Level level) {
        if (level == null) {
            return 4;
        }
        int value = level.intValue();
        if (value >= Level.OFF.intValue()) {
            return 4;
        }
        if (value >= Level.SEVERE.intValue()) {
            return 3;
        }
        if (value >= Level.WARNING.intValue()) {
            return 2;
        }
        if (value >= Level.INFO.intValue()) {
            return 1;
        }
        return 0;
    }

    private Log(String logName, int maxSeverity) {
        this.delegate = Logger.getLogger(logName);
        this.delegate.setLevel(Log.severityToLevel(maxSeverity));
        this.logName = logName;
    }

    private static Level severityToLevel(int maxSeverity) {
        switch (maxSeverity) {
            case 4: {
                return Level.OFF;
            }
            case 3: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.WARNING;
            }
            case 1: {
                return Level.INFO;
            }
            case 0: {
                return Level.FINE;
            }
        }
        return Level.ALL;
    }

    private static BILoggingService getLoggingService() {
        BILoggingService loggingService = Sys.getStation() != null ? (BILoggingService)((Object)Sys.getService(BILoggingService.TYPE)) : (BILoggingService)((Object)BOrd.make("workbench:/tools/workbench:LoggerConfigurationTool").get());
        return loggingService;
    }

    public String getLogName() {
        return this.logName;
    }

    public boolean isLoggable(int severity) {
        return this.delegate.isLoggable(Log.severityToLevel(severity));
    }

    public boolean isTraceOn() {
        return this.delegate.isLoggable(Level.FINE);
    }

    public int getSeverity() {
        Level level = this.delegate.getLevel();
        for (Logger parent = this.delegate; level == null && parent != null; parent = parent.getParent()) {
            level = parent.getLevel();
        }
        return Log.levelToSeverity(level);
    }

    public String getSeverityString() {
        return Log.severityToString(this.getSeverity());
    }

    public void setSeverity(int maxSeverity) {
        this.delegate.setLevel(Log.severityToLevel(maxSeverity));
        if (this.delegate.getLevel().equals(Level.OFF)) {
            return;
        }
        BILoggingService loggingService = Log.getLoggingService();
        try {
            LogSettings logSettings = new LogSettings(loggingService.readLogSettings());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void error(String msg) {
        this.delegate.severe(msg);
    }

    public void error(String msg, Throwable ex) {
        this.delegate.log(Level.SEVERE, msg, ex);
    }

    public void warning(String msg) {
        this.delegate.warning(msg);
    }

    public void warning(String msg, Throwable ex) {
        this.delegate.log(Level.WARNING, msg, ex);
    }

    public void message(String msg) {
        this.delegate.info(msg);
    }

    public void message(String msg, Throwable ex) {
        this.delegate.log(Level.INFO, msg, ex);
    }

    public void trace(String msg) {
        this.delegate.fine(msg);
    }

    public void trace(String msg, Throwable ex) {
        this.delegate.log(Level.FINE, msg, ex);
    }

    public void trace(byte[] buf) {
        this.log(0, "", null, buf, 0, buf.length);
    }

    public void trace(byte[] buf, int offset, int length) {
        this.log(0, "", null, buf, offset, length);
    }

    public void trace(String msg, byte[] buf) {
        this.log(0, msg, null, buf, 0, buf.length);
    }

    public void trace(String msg, byte[] buf, int offset, int length) {
        this.log(0, msg, null, buf, offset, length);
    }

    public void log(int severity, String msg, Throwable ex) {
        this.delegate.log(Log.severityToLevel(severity), msg, ex);
    }

    public void log(int severity, String msg, Throwable ex, byte[] buf) {
        this.log(severity, msg, ex, buf, 0, buf.length);
    }

    public void log(int severity, String msg, Throwable ex, byte[] buf, int offset, int length) {
        String m;
        String string = m = msg == null ? "" : msg;
        if (buf != null && buf.length > 0) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ByteArrayUtil.hexDump((PrintWriter)pw, (byte[])buf, (int)offset, (int)length);
            m = m + '\n' + sw.toString();
        }
        this.delegate.log(Log.severityToLevel(severity), m, ex);
    }
}

