/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.job;

import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSimpleJob
extends BJob {
    public static final Type TYPE = Sys.loadType(BSimpleJob.class);
    JobThread thread;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doRun(Context cx) {
        this.thread = new JobThread(this.toPathString(), cx);
        this.thread.start();
    }

    @Override
    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    public abstract void run(Context var1) throws Exception;

    class JobThread
    extends Thread {
        Context cx;

        JobThread(String name, Context cx) {
            super(name);
            this.cx = cx;
        }

        @Override
        public void run() {
            try {
                BSimpleJob.this.run(this.cx);
                BSimpleJob.this.success();
            }
            catch (Throwable e) {
                BSimpleJob.this.failed(e);
            }
        }
    }
}

