/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.job;

import javax.baja.job.BJobLogSequence;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BJob
extends BComponent {
    public static final Property jobState = BJob.newProperty(3, BJobState.unknown, null);
    public static final Property progress = BJob.newProperty(3, -1, null);
    public static final Property startTime = BJob.newProperty(1, BAbsTime.NULL, null);
    public static final Property heartbeatTime = BJob.newProperty(1, BAbsTime.NULL, null);
    public static final Property endTime = BJob.newProperty(1, BAbsTime.NULL, null);
    public static final Action cancel = BJob.newAction(0, null);
    public static final Action dispose = BJob.newAction(0, null);
    public static final Action readLog = BJob.newAction(0, null);
    public static final Action readLogFrom = BJob.newAction(2052, BLong.make(0L), null);
    public static final Type TYPE = Sys.loadType(BJob.class);
    private static final BIcon icon = BIcon.std("build.png");
    JobLog log = new JobLog();

    public BJobState getJobState() {
        return (BJobState)this.get(jobState);
    }

    public void setJobState(BJobState v) {
        this.set(jobState, (BValue)v, null);
    }

    public int getProgress() {
        return this.getInt(progress);
    }

    public void setProgress(int v) {
        this.setInt(progress, v, null);
    }

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BAbsTime getHeartbeatTime() {
        return (BAbsTime)this.get(heartbeatTime);
    }

    public void setHeartbeatTime(BAbsTime v) {
        this.set(heartbeatTime, (BValue)v, null);
    }

    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    public void setEndTime(BAbsTime v) {
        this.set(endTime, (BValue)v, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    public void dispose() {
        this.invoke(dispose, null, null);
    }

    public BString readLog() {
        return (BString)this.invoke(readLog, null, null);
    }

    public BJobLogSequence readLogFrom(BLong num) {
        return (BJobLogSequence)this.invoke(readLogFrom, num, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BJob() {
        this.log.setJob(this);
    }

    public BOrd submit(Context cx) {
        return BJobService.getService().submit(this, cx);
    }

    public void doSubmit(Context cx) {
        this.setJobState(BJobState.running);
        this.setStartTime(Clock.time());
        this.setProgress(-1);
        this.resetLog();
        try {
            this.doRun(cx);
        }
        catch (Throwable e) {
            this.failed(e);
        }
    }

    public boolean isAlive() {
        return this.getJobState() == BJobState.running;
    }

    public abstract void doRun(Context var1) throws Exception;

    public abstract void doCancel(Context var1) throws Exception;

    public void doDispose(Context cx) {
        if (this.getJobState().isRunning()) {
            throw new IllegalStateException("Cannot dispose while running");
        }
        this.setJobState(BJobState.unknown);
        if (this.getParent() != null) {
            ((BComponent)this.getParent()).remove(this);
        }
    }

    @Override
    public String toString(Context cx) {
        String jobName = this.getType().getDisplayName(null);
        if (jobName.endsWith(" Job")) {
            jobName = jobName.substring(0, jobName.length() - 4);
        }
        return jobName;
    }

    public void progress(int percent) {
        this.setProgress(percent);
        this.heartbeat();
    }

    public void heartbeat() {
        this.setHeartbeatTime(Clock.time());
    }

    public void success() {
        this.log().success("Job Success");
        this.complete(BJobState.success);
    }

    public void canceled() {
        this.log().add(new JobLogItem(2, "Job Canceled"));
        this.complete(BJobState.canceled);
    }

    public void failed(Throwable cause) {
        if (this.getJobState() == BJobState.canceling || cause instanceof InterruptedException || cause instanceof JobCancelException) {
            this.canceled();
            return;
        }
        this.log().failed("Job Failed", cause);
        this.complete(BJobState.failed);
    }

    public void complete(BJobState state) {
        if (!state.isComplete()) {
            throw new IllegalArgumentException("Cannot complete as " + state);
        }
        this.setJobState(state);
        this.setProgress(100);
        this.setEndTime(Clock.time());
    }

    public JobLog log() {
        return this.log;
    }

    public BString doReadLog() {
        return BString.make(this.log.encode());
    }

    public BJobLogSequence doReadLogFrom(BLong num) {
        return this.log.getSequenceFrom(num.getLong());
    }

    public void resetLog() {
        JobLog old = this.log;
        old.setJob(null);
        this.log = new JobLog(old.sequenceNumber);
        this.log.setJob(this);
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.w("<hr><pre>").safe(this.readLog()).w("</pre>");
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

