/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.io.BogPasswordObjectEncoder;
import com.tridium.nre.util.IElement;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.util.SimpleFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.category.BCategoryMask;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.security.BIPasswordValidator;
import javax.baja.security.BPassword;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class ValueDocDecoder
implements AutoCloseable {
    private final SimpleFactory simpleFactory = new SimpleFactory();
    protected final IDecoderPlugin plugin;
    private Context context = null;
    private static final Map<String, String> typeSwapMap = new HashMap<String, String>();
    private static final boolean decodeTypeSwap;
    private Map<String, String> moduleKeyMap = new HashMap<String, String>();

    public static BValue unmarshal(String xml) throws Exception {
        return BogDecoderPlugin.unmarshal(xml);
    }

    public static BValue unmarshal(String xml, Context cx) throws Exception {
        return BogDecoderPlugin.unmarshal(xml, cx);
    }

    public static BValue unmarshal(String xml, ITypeResolver typeResolver) throws Exception {
        return BogDecoderPlugin.unmarshal(xml, typeResolver);
    }

    public static BValue unmarshal(String xml, ITypeResolver typeResolver, Context cx) throws Exception {
        return BogDecoderPlugin.unmarshal(xml, typeResolver, cx);
    }

    public ValueDocDecoder(IDecoderPlugin plugin) throws Exception {
        this(plugin, null);
    }

    public ValueDocDecoder(IDecoderPlugin plugin, Context context) throws Exception {
        this.plugin = plugin;
        this.context = context;
    }

    public ValueDocDecoder(BOrd ord) throws Exception {
        this(new BogDecoderPlugin(ord), null);
    }

    public ValueDocDecoder(BIFile file) throws Exception {
        this(new BogDecoderPlugin(file), null);
    }

    public ValueDocDecoder(BIFile file, Context context) throws Exception {
        this(new BogDecoderPlugin(file), context);
    }

    public ValueDocDecoder(File file) throws Exception {
        this(new BogDecoderPlugin(file), null);
    }

    public ValueDocDecoder(InputStream in) throws Exception {
        this(in, null);
    }

    public ValueDocDecoder(InputStream in, Context context) throws Exception {
        this(new BogDecoderPlugin(in), context);
    }

    public final ITypeResolver getTypeResolver() {
        return this.plugin.getTypeResolver();
    }

    public final void setTypeResolver(ITypeResolver typeResolver) {
        this.plugin.setTypeResolver(typeResolver);
    }

    public BValue decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    public BValue decodeDocument(boolean close) throws Exception {
        try {
            BValue bValue = this.plugin.decodeDocument(this);
            return bValue;
        }
        finally {
            if (close) {
                this.plugin.close();
            }
        }
    }

    public BValue decode() throws Exception {
        return this.parseSlot(null, true);
    }

    public final IDecoderPlugin getPlugin() {
        return this.plugin;
    }

    public final IElement elem() {
        return this.plugin.elem();
    }

    public final int next() throws Exception {
        return this.plugin.next();
    }

    public final void skip() throws Exception {
        this.plugin.skip();
    }

    public final void skip(int depth) throws Exception {
        this.plugin.skip(depth);
    }

    public final int type() {
        return this.plugin.type();
    }

    public final int line() {
        return this.plugin.line();
    }

    public final int column() {
        return this.plugin.column();
    }

    @Override
    public final void close() {
        this.plugin.close();
    }

    public final int depth() {
        return this.plugin.depth();
    }

    public final String getEncoding() throws IOException {
        return this.plugin.getEncoding();
    }

    public final Version getVersion() throws IOException {
        return this.plugin.getVersion();
    }

    public final boolean isZipped() throws IOException {
        return this.plugin.isZipped();
    }

    public final IElement parse() throws Exception {
        return this.plugin.parse();
    }

    public IElement parse(boolean close) throws Exception {
        return this.plugin.parse(close);
    }

    public final IElement parseCurrent() throws Exception {
        return this.plugin.parseCurrent();
    }

    public final IElement parseCurrent(boolean close) throws Exception {
        return this.plugin.parseCurrent(close);
    }

    public final RuntimeException err(String msg, Throwable cause) {
        return this.plugin.err(msg, cause);
    }

    public final RuntimeException err(String msg) {
        return this.plugin.err(msg);
    }

    public final void warningAndSkip(String msg) throws RuntimeException {
        this.plugin.warningAndSkip(msg);
    }

    public final void warning(String msg) {
        this.plugin.warning(msg);
    }

    public final Logger getLog() {
        return this.plugin.getLog();
    }

    public final void setLog(Logger log) {
        this.plugin.setLog(log);
    }

    public final int getWarningCount() {
        return this.plugin.getWarningCount();
    }

    protected void decodingComponent(BComponent c) throws Exception {
        this.plugin.warningAndSkip("Unknown element <" + this.plugin.elem().name() + "> for decodingComponent");
    }

    protected void parsingSlots(BComponent parent) throws Exception {
    }

    private void parseSlots(BObject parent) throws Exception {
        while (true) {
            int ptype;
            if ((ptype = this.next()) == -1) {
                throw new EOFException();
            }
            if (ptype == 2) {
                return;
            }
            if (ptype != 1) {
                throw this.err("Expected element start");
            }
            this.parseSlot((BComplex)parent, false);
        }
    }

    private BValue parseSlot(BComplex parent, boolean failFast) throws Exception {
        BValue object;
        Property prop;
        int flags;
        boolean stub;
        String catsStr;
        BFacets facets;
        String value;
        String type;
        String handle;
        String name;
        block77: {
            String ename;
            if (this.type() != 1) {
                throw this.err("Expected element start (" + this.type() + ")");
            }
            IElement slotElem = this.plugin.elem();
            switch (ename = slotElem.name().intern()) {
                case "p": 
                case "a": 
                case "t": {
                    break;
                }
                default: {
                    if (parent instanceof BComponent) {
                        this.decodingComponent((BComponent)parent);
                    } else {
                        this.plugin.warningAndSkip("Unknown element <" + ename + ">");
                    }
                    if (failFast) {
                        throw this.err("Unknown element <" + ename + ">");
                    }
                    return null;
                }
            }
            name = null;
            handle = null;
            String module = null;
            type = null;
            value = null;
            String flagStr = null;
            facets = BFacets.NULL;
            catsStr = null;
            stub = false;
            int attrSize = slotElem.attrSize();
            block39: for (int i = 0; i < attrSize; ++i) {
                String attrName = slotElem.attrName(i);
                String attrVal = slotElem.attrValue(i);
                switch (attrName) {
                    case "n": {
                        name = attrVal;
                        continue block39;
                    }
                    case "h": {
                        handle = attrVal;
                        continue block39;
                    }
                    case "v": {
                        value = attrVal;
                        continue block39;
                    }
                    case "t": {
                        type = attrVal;
                        continue block39;
                    }
                    case "m": {
                        module = attrVal;
                        continue block39;
                    }
                    case "f": {
                        flagStr = attrVal;
                        continue block39;
                    }
                    case "x": {
                        facets = this.decodeFacets(attrVal);
                        continue block39;
                    }
                    case "c": {
                        catsStr = attrVal;
                        continue block39;
                    }
                    case "stub": {
                        stub = attrVal.equals("true");
                    }
                }
            }
            flags = this.decodeFlags(flagStr);
            if (module != null && this.plugin.getTypeResolver().loadModule(this, parent, name, module, type) == null) {
                try {
                    IElement toSkip = this.plugin.parseCurrent(false);
                    if (toSkip instanceof BogElement) {
                        XElem elem = ((BogElement)toSkip).getXmlElement();
                        LinkedList<XElem> todo = new LinkedList<XElem>();
                        todo.add(elem);
                        while (!todo.isEmpty()) {
                            XElem x = (XElem)todo.removeFirst();
                            String xname = x.get("n", null);
                            String xmodule = x.get("m", null);
                            String xtype = x.get("t", null);
                            if (xmodule != null) {
                                this.plugin.getLog().fine("Loading module for skipped child element " + x);
                                this.plugin.getTypeResolver().loadModule(this, null, xname, xmodule, xtype);
                            }
                            Collections.addAll(todo, x.elems());
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.plugin.warning("Missing module " + (module.indexOf(61) != -1 ? module.substring(module.indexOf(61) + 1) : module));
                    throw e;
                }
                catch (Exception e) {
                    this.plugin.warning("Missing module " + module);
                    throw this.plugin.err("Missing module " + (module.indexOf(61) != -1 ? module.substring(module.indexOf(61) + 1) : module));
                }
                if (failFast) {
                    throw this.plugin.err("Missing module " + (module.indexOf(61) != -1 ? module.substring(module.indexOf(61) + 1) : module));
                }
                this.plugin.getLog().fine("Missing module: " + module);
            }
            Slot slot = null;
            if (parent != null) {
                if (name == null) {
                    throw this.plugin.err("Missing \"n\" name attribute");
                }
                slot = parent.getSlot(name);
            }
            if (slot != null) {
                if (flagStr != null) {
                    parent.setFlags(slot, flags, Context.decoding);
                }
                if (!slot.isProperty()) {
                    this.plugin.skip();
                    return null;
                }
            } else {
                if (ename.equals("a")) {
                    this.plugin.warningAndSkip("Missing frozen action: " + name);
                    return null;
                }
                if (ename.equals("t")) {
                    this.plugin.warningAndSkip("Missing frozen topic: " + name);
                    return null;
                }
            }
            if (this.decodePrimitive(parent, prop = (Property)slot, value)) {
                if (failFast) {
                    throw this.err("Encountered unexpected primitive");
                }
                return null;
            }
            object = null;
            try {
                object = this.plugin.getTypeResolver().newInstance(this, parent, name, prop, type);
            }
            catch (XException e) {
                try {
                    String fullTypeName;
                    String fullModuleName;
                    if (module != null) {
                        fullModuleName = module.substring(module.indexOf(61) + 1);
                        fullTypeName = fullModuleName + type.substring(type.indexOf(58));
                        object = this.plugin.getTypeResolver().newInstance(this, parent, name, prop, fullTypeName);
                        if (object != null) {
                            this.moduleKeyMap.put(module.substring(0, module.indexOf(61)), fullModuleName);
                        }
                    } else {
                        fullModuleName = this.moduleKeyMap.get(type.substring(0, type.indexOf(58)));
                        fullTypeName = fullModuleName + type.substring(type.indexOf(58));
                        if (fullModuleName != null) {
                            object = this.plugin.getTypeResolver().newInstance(this, parent, name, prop, fullTypeName);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object != null) break block77;
                throw e;
            }
        }
        if (object == null) {
            if (failFast) {
                throw this.err("Unable to instantiate " + (type.indexOf(58) != -1 ? type.substring(type.indexOf(58) + 1) : type));
            }
            return null;
        }
        if (object.isSimple() && value != null) {
            if (this.isTypeBlackListed(object.getType())) {
                value = ((BSimple)object.getType().getInstance()).encodeToString();
            }
            object = this.decodeSimple(object, value);
        }
        if (object.isComponent()) {
            ((ComponentSlotMap)object.fw(1)).setHandle(handle);
            if (!stub) {
                ((ComponentSlotMap)object.fw(1)).setBrokerPropsLoaded(true);
            }
            if (catsStr != null) {
                ((BComponent)object).setCategoryMask(BCategoryMask.make(catsStr), Context.decoding);
            }
        }
        if (parent != null) {
            if (prop != null) {
                if (!prop.isFrozen()) {
                    throw this.plugin.err("Duplicate slot " + parent.getType().getTypeName() + "." + name);
                }
                try {
                    parent.set(prop, object, Context.decoding);
                }
                catch (Exception e) {
                    this.plugin.warningAndSkip("Cannot set property " + parent.getType().getTypeName() + "." + name + ": " + e);
                }
            } else if (parent.isComponent()) {
                parent.asComponent().add(name, object, flags, facets, Context.decoding);
            } else {
                this.plugin.warningAndSkip("Missing slot " + parent.getType().getTypeName() + "." + name);
            }
        }
        this.parseSlots(object);
        if (object.isComponent()) {
            this.parsingSlots((BComponent)object);
        }
        return object;
    }

    private boolean decodePrimitive(BComplex parent, Property prop, String value) throws Exception {
        if (prop == null || value == null) {
            return false;
        }
        if (prop.getTypeAccess() == 7) {
            return false;
        }
        switch (prop.getTypeAccess()) {
            case 0: {
                parent.setBoolean(prop, BBoolean.decode(value), Context.decoding);
                break;
            }
            case 2: {
                parent.setInt(prop, BInteger.decode(value), Context.decoding);
                break;
            }
            case 3: {
                parent.setLong(prop, BLong.decode(value), Context.decoding);
                break;
            }
            case 4: {
                parent.setFloat(prop, BFloat.decode(value), Context.decoding);
                break;
            }
            case 5: {
                parent.setDouble(prop, BDouble.decode(value), Context.decoding);
                break;
            }
            case 6: {
                parent.setString(prop, value, Context.decoding);
                break;
            }
            default: {
                throw new IllegalStateException("" + prop.getTypeAccess());
            }
        }
        int ptype = this.next();
        if (ptype != 2) {
            throw this.err("Expecting end of p element for simple property " + prop.getName());
        }
        return true;
    }

    protected BSimple decodeSimple(BObject obj, String value) {
        try {
            return this.simpleFactory.make(obj.getType(), value, this.context);
        }
        catch (Exception e) {
            throw this.plugin.err("Invalid " + obj.getType().getTypeName() + ": '" + value + "'", e);
        }
    }

    private int decodeFlags(String str) {
        if (str == null) {
            return 0;
        }
        return Flags.decodeFromString(str);
    }

    private BFacets decodeFacets(String str) {
        try {
            if (str == null) {
                return BFacets.NULL;
            }
            return (BFacets)this.simpleFactory.make(BFacets.TYPE, str, this.context);
        }
        catch (Exception e) {
            throw this.plugin.err("Invalid facets " + str, e);
        }
    }

    public boolean isTypeBlackListed(Type type) {
        return false;
    }

    /*
     * Exception decompiling
     */
    public static BogPasswordObjectEncoder getBogEncodingInfo(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static BValue typeResolverNewInstance(NModule module, String typeName) {
        Type type;
        try {
            type = module.getType(typeName);
        }
        catch (TypeNotFoundException e) {
            return ValueDocDecoder.newSwapInstance(module.getModuleName(), typeName);
        }
        return (BValue)type.getInstance();
    }

    static BValue newSwapInstance(String moduleName, String typeName) {
        String typeSwap;
        String typeString = String.format("%s:%s", moduleName, typeName);
        if (decodeTypeSwap) {
            typeSwap = typeSwapMap.get(typeString);
            if (typeSwap == null) {
                throw new TypeNotFoundException(typeString);
            }
        } else {
            throw new TypeNotFoundException(typeString);
        }
        Type type = Sys.getType(typeSwap);
        return (BValue)type.getInstance();
    }

    static {
        typeSwapMap.put("niagaraDriver:NiagaraVirtualGateway", "niagaraDriver:NiagaraVirtualDeviceExt");
        decodeTypeSwap = AccessController.doPrivileged(() -> System.getProperty("niagara.decodeTypeSwap", "true")).equals("true");
    }

    public static class BogTypeResolver
    implements ITypeResolver {
        @Override
        public BModule loadModule(ValueDocDecoder decoder, BComplex parent, String propName, String moduleStr, String ignored) {
            try {
                int equals = moduleStr.indexOf(61);
                String key = moduleStr.substring(0, equals).trim();
                String name = moduleStr.substring(equals + 1).trim();
                NModule[] moduleParts = Nre.getModuleManager().loadModuleParts(name);
                HashMap<RuntimeProfile, NModule> map = new HashMap<RuntimeProfile, NModule>();
                for (NModule part : moduleParts) {
                    map.put(part.getRuntimeProfile(), part);
                }
                this.getModuleMap(decoder).put(key, map);
                this.getModuleNameMap(decoder).put(key, name);
                return moduleParts[0].bmodule();
            }
            catch (ModuleException e) {
                throw decoder.plugin.err("Cannot load module '" + moduleStr + "'", e);
            }
            catch (Exception e) {
                throw decoder.plugin.err("Invalid module attribute '" + moduleStr + "'");
            }
        }

        @Override
        public BValue newInstance(ValueDocDecoder decoder, BComplex parent, String propName, Property prop, String typeStr) {
            if (typeStr == null) {
                if (prop != null) {
                    return prop.getDefaultValue();
                }
                decoder.plugin.warningAndSkip("Missing frozen property: " + propName);
                return null;
            }
            try {
                int x = typeStr.indexOf(58);
                if (x <= 0) {
                    throw decoder.plugin.err("Invalid typespec '" + typeStr + "'");
                }
                String tkey = typeStr.substring(0, x);
                String tname = typeStr.substring(x + 1);
                Map<RuntimeProfile, NModule> byProfile = this.getModuleMap(decoder).get(tkey);
                if (byProfile != null) {
                    for (NModule module : byProfile.values()) {
                        if (!module.hasType(tname)) continue;
                        return ValueDocDecoder.typeResolverNewInstance(module, tname);
                    }
                    Iterator<NModule> i = this.getModuleMap(decoder).get(tkey).values().iterator();
                    if (i.hasNext()) {
                        return ValueDocDecoder.newSwapInstance(i.next().getModuleName(), tname);
                    }
                    throw new TypeNotFoundException(typeStr);
                }
                throw decoder.plugin.err("Undeclared module symbol: " + tkey, new ModuleNotFoundException(tkey));
            }
            catch (XException e) {
                throw e;
            }
            catch (TypeNotFoundException e) {
                decoder.plugin.warningAndSkip("Type \"" + e.getMessage() + "\" not found: " + propName);
                return null;
            }
            catch (Throwable e) {
                throw decoder.plugin.err("Cannot instantiate type '" + typeStr + "'", e);
            }
        }

        public Map<String, Map<RuntimeProfile, NModule>> getModuleMap(ValueDocDecoder decoder) {
            return ((BogDecoderPlugin)decoder.plugin).modules;
        }

        public NModule[] getMappedModules(ValueDocDecoder decoder, String moduleName) {
            if (this.getModuleMap(decoder).containsKey(moduleName)) {
                ArrayList nModulesList = new ArrayList();
                this.getModuleMap(decoder).get(moduleName).values().forEach(nModulesList::add);
                return nModulesList.toArray(new NModule[nModulesList.size()]);
            }
            return null;
        }

        public NModule getMappedModule(ValueDocDecoder decoder, String moduleName, RuntimeProfile profile) {
            if (this.getModuleMap(decoder).containsKey(moduleName)) {
                return this.getModuleMap(decoder).get(moduleName).get(profile);
            }
            return null;
        }

        public void updateModuleMap(ValueDocDecoder decoder, NModule[] modules) {
            for (NModule module : modules) {
                Map<RuntimeProfile, NModule> byProfile = this.getModuleMap(decoder).get(module.getModuleName());
                if (byProfile == null) {
                    byProfile = new HashMap<RuntimeProfile, NModule>();
                    this.getModuleMap(decoder).put(module.getModuleName(), byProfile);
                }
                byProfile.put(module.getRuntimeProfile(), module);
            }
        }

        public Map<String, String> getModuleNameMap(ValueDocDecoder decoder) {
            return ((BogDecoderPlugin)decoder.plugin).moduleNamesBySymbol;
        }
    }

    public static final class BogElement
    implements IElement {
        private final XElem elem;

        private BogElement(XElem elem) {
            this.elem = elem;
        }

        public static BogElement make(XElem elem) {
            return elem == null ? null : new BogElement(elem);
        }

        public String name() {
            return this.elem.name();
        }

        public String get(String attrName) {
            return this.elem.get(attrName);
        }

        public String get(String attrName, String def) {
            return this.elem.get(attrName, def);
        }

        public int geti(String attrName) {
            return this.elem.geti(attrName);
        }

        public int geti(String attrName, int def) {
            return this.elem.geti(attrName, def);
        }

        public double getd(String attrName) {
            return this.elem.getd(attrName);
        }

        public double getd(String attrName, double def) {
            return this.elem.getd(attrName, def);
        }

        public float getf(String attrName) {
            return this.elem.getf(attrName);
        }

        public float getf(String attrName, float def) {
            return this.elem.getf(attrName, def);
        }

        public long getl(String attrName) {
            return this.elem.getl(attrName);
        }

        public long getl(String attrName, long def) {
            return this.elem.getl(attrName, def);
        }

        public int attrSize() {
            return this.elem.attrSize();
        }

        public String attrName(int index) {
            return this.elem.attrName(index);
        }

        public String attrValue(int index) {
            return this.elem.attrValue(index);
        }

        public IElement copy() {
            return BogElement.make(this.elem.copy());
        }

        public String toString() {
            return this.elem.toString();
        }

        public XElem getXmlElement() {
            return this.elem;
        }
    }

    public static final class BogDecoderPlugin
    implements IDecoderPlugin {
        private final XParser parser;
        private final Map<String, Map<RuntimeProfile, NModule>> modules = new HashMap<String, Map<RuntimeProfile, NModule>>();
        private final Map<String, String> moduleNamesBySymbol = new HashMap<String, String>();
        private ITypeResolver typeResolver = new BogTypeResolver();
        public static final ITypeResolver defaultTypeResolver = new BogTypeResolver();
        private static final Logger defaultLog = Logger.getLogger("sys.xml");
        private Logger log = defaultLog;
        private int warningCount;
        protected BIPasswordValidator passPhraseValidator = BPassword.DEFAULT;
        protected EncryptionKeySource reversibleEncodingKeySource = EncryptionKeySource.undefined;
        protected BogPasswordObjectEncoder passwordObjectEncoder = BogPasswordObjectEncoder.makeNone();
        private Optional<BPassword> passPhrase = Optional.empty();
        protected Version version;

        public BogDecoderPlugin(InputStream in) throws Exception {
            this(in, null);
        }

        public BogDecoderPlugin(BOrd ord) throws Exception {
            this((BIFile)((Object)ord.resolve().get()));
        }

        public BogDecoderPlugin(BIFile file) throws Exception {
            this(new BufferedInputStream(file.getInputStream()));
        }

        public BogDecoderPlugin(File file) throws Exception {
            this(new BufferedInputStream(new FileInputStream(file)));
        }

        public BogDecoderPlugin(InputStream in, Context cx) throws Exception {
            this.parser = XParser.make((InputStream)in);
            this.initPasswordHandling(cx);
        }

        public BogDecoderPlugin(BOrd ord, Context cx) throws Exception {
            this((BIFile)((Object)ord.resolve().get()), cx);
        }

        public BogDecoderPlugin(BIFile file, Context cx) throws Exception {
            this(new BufferedInputStream(file.getInputStream()), cx);
        }

        public BogDecoderPlugin(File file, Context cx) throws Exception {
            this(new BufferedInputStream(new FileInputStream(file)), cx);
        }

        private void initPasswordHandling(Context pluginContext) throws Exception {
            if (pluginContext != null) {
                try {
                    PasswordEncodingContext pContext = PasswordEncodingContext.from(pluginContext);
                    if (pContext.hasEncryptionKey()) {
                        this.passwordObjectEncoder = AccessController.doPrivileged(() -> BogPasswordObjectEncoder.make((ISecretBytesSupplier)pContext.getEncryptionKey().get()));
                    }
                }
                catch (PrivilegedActionException pae) {
                    if (pae.getCause() instanceof IOException) {
                        throw (IOException)pae.getCause();
                    }
                    throw new IOException(pae.getCause());
                }
            }
        }

        public Version readHeader() throws Exception {
            this.next();
            IElement root = this.elem();
            if (!root.name().equals("bajaObjectGraph")) {
                throw this.err("Root element must be \"bajaObjectGraph\"");
            }
            String ver = root.get("version");
            if (!ver.equals("1.0") && !ver.equals("4.0")) {
                throw this.err("Unsupported version (" + ver + "): supported versions are 1.0, 4.0");
            }
            this.version = new Version(ver);
            this.passwordObjectEncoder = BogPasswordObjectEncoder.parseBogHeader((IElement)root, (EncryptionKeySource)this.reversibleEncodingKeySource);
            this.passPhraseValidator = BIPasswordValidator.fromPBEValidator((PBEValidator)this.passwordObjectEncoder.getPbeEncodingInfo());
            return this.version;
        }

        @Override
        public BIPasswordValidator getPassPhraseValidator() {
            return this.passPhraseValidator;
        }

        public BogPasswordObjectEncoder getPasswordObjectEncoder() {
            return this.passwordObjectEncoder;
        }

        public void setPasswordObjectEncoder(BogPasswordObjectEncoder value) {
            Objects.requireNonNull(value);
            this.passwordObjectEncoder = value;
        }

        public void setReversibleEncodingKeySource(EncryptionKeySource value) {
            this.reversibleEncodingKeySource = value;
        }

        public void setPassPhrase(Optional<BPassword> value) {
            this.passPhrase = value;
        }

        @Override
        public BValue decodeDocument(ValueDocDecoder decoder) throws Exception {
            this.readHeader();
            if (!this.passwordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.keyring)) {
                PasswordEncodingContext pContext = PasswordEncodingContext.from(decoder.context);
                try {
                    AccessController.doPrivileged(() -> {
                        if (this.passwordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.shared)) {
                            pContext.setDecryptionKey(EncryptionKeySource.external, Optional.of(this.passwordObjectEncoder.passPhraseToKey(null)));
                            pContext.setEncryptionUndefined();
                        } else if (this.passwordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.external)) {
                            pContext.setEncryptionUndefined();
                            if (this.passPhrase.isPresent()) {
                                if (!this.getPassPhraseValidator().validate(AccessController.doPrivileged(this.passPhrase.get()::getValue))) {
                                    throw new BajaRuntimeException("Encryption pass phrase does not match");
                                }
                                pContext.setDecryptionKey(EncryptionKeySource.external, Optional.of(this.passwordObjectEncoder.passPhraseToKey(this.passPhrase.get().getSecretChars())));
                            } else {
                                pContext.setDecryptionKey(EncryptionKeySource.external, Optional.empty());
                            }
                        }
                        return null;
                    });
                }
                catch (PrivilegedActionException pae) {
                    if (pae.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)pae.getCause();
                    }
                    throw new BajaRuntimeException(pae.getCause());
                }
                if (decoder.context == null) {
                    decoder.context = pContext;
                }
            } else if (decoder.context == null) {
                decoder.context = PasswordEncodingContext.makeKeyring();
            } else {
                decoder.context = PasswordEncodingContext.updateForKeyring(decoder.context);
            }
            this.next();
            BValue value = decoder.decode();
            this.next();
            if (this.type() != 2 || !this.elem().name().equals("bajaObjectGraph")) {
                throw this.err("Expected end tag for \"bajaObjectGraph\"");
            }
            return value;
        }

        @Override
        public int next() throws Exception {
            return this.parser.next();
        }

        @Override
        public IElement elem() {
            return BogElement.make(this.parser.elem());
        }

        @Override
        public void skip() throws Exception {
            this.parser.skip();
        }

        @Override
        public void skip(int depth) throws Exception {
            this.parser.skip(depth);
        }

        @Override
        public int type() {
            return this.parser.type();
        }

        @Override
        public int line() {
            return this.parser.line();
        }

        @Override
        public int column() {
            return this.parser.column();
        }

        @Override
        public void close() {
            this.parser.close();
            this.passwordObjectEncoder.close();
        }

        @Override
        public int depth() {
            return this.parser.depth();
        }

        @Override
        public String getEncoding() throws IOException {
            return this.parser.getEncoding();
        }

        @Override
        public boolean isZipped() throws IOException {
            return this.parser.isZipped();
        }

        @Override
        public Version getVersion() throws IOException {
            return this.version;
        }

        @Override
        public IElement parse() throws Exception {
            return BogElement.make(this.parser.parse());
        }

        @Override
        public IElement parse(boolean close) throws Exception {
            return BogElement.make(this.parser.parse(close));
        }

        @Override
        public IElement parseCurrent() throws Exception {
            return BogElement.make(this.parser.parseCurrent());
        }

        @Override
        public IElement parseCurrent(boolean close) throws Exception {
            return BogElement.make(this.parser.parseCurrent(close));
        }

        @Override
        public ITypeResolver getTypeResolver() {
            return this.typeResolver;
        }

        @Override
        public void setTypeResolver(ITypeResolver typeResolver) {
            this.typeResolver = typeResolver == null ? defaultTypeResolver : typeResolver;
        }

        @Override
        public RuntimeException err(String msg, Throwable cause) {
            return new XException(msg, this.parser.line(), this.parser.column(), cause);
        }

        @Override
        public RuntimeException err(String msg) {
            return new XException(msg, this.parser.line(), this.parser.column());
        }

        @Override
        public void warningAndSkip(String msg) throws RuntimeException {
            this.warning(msg);
            try {
                this.skip();
            }
            catch (XException e) {
                throw e;
            }
            catch (Exception e) {
                throw new XException((Throwable)e);
            }
        }

        @Override
        public void warning(String msg) throws RuntimeException {
            this.log.warning(msg + " [" + this.parser.line() + ':' + this.parser.column() + "]");
            ++this.warningCount;
        }

        @Override
        public Logger getLog() {
            return this.log;
        }

        @Override
        public void setLog(Logger log) {
            this.log = log;
        }

        @Override
        public int getWarningCount() {
            return this.warningCount;
        }

        public XParser getXmlParser() {
            return this.parser;
        }

        public static BValue unmarshal(String xml) throws Exception {
            return BogDecoderPlugin.unmarshal(xml, defaultTypeResolver, PasswordEncodingContext.makeNone());
        }

        public static BValue unmarshal(String xml, ITypeResolver typeResolver) throws Exception {
            return BogDecoderPlugin.unmarshal(xml, typeResolver, PasswordEncodingContext.makeNone());
        }

        public static BValue unmarshal(String xml, Context cx) throws Exception {
            return BogDecoderPlugin.unmarshal(xml, defaultTypeResolver, cx);
        }

        public static BValue unmarshal(String xml, ITypeResolver typeResolver, Context cx) throws Exception {
            BogDecoderPlugin plugin = new BogDecoderPlugin(new ByteArrayInputStream(xml.getBytes()), cx);
            ValueDocDecoder decoder = new ValueDocDecoder(plugin, cx);
            decoder.plugin.setTypeResolver(typeResolver);
            decoder.plugin.next();
            return decoder.decode();
        }
    }

    public static interface IDecoderPlugin
    extends AutoCloseable {
        public BValue decodeDocument(ValueDocDecoder var1) throws Exception;

        public int next() throws Exception;

        public IElement elem();

        public void skip() throws Exception;

        public void skip(int var1) throws Exception;

        public int type();

        public int line();

        public int column();

        @Override
        public void close();

        public int depth();

        public String getEncoding() throws IOException;

        public boolean isZipped() throws IOException;

        default public Version getVersion() throws IOException {
            return Version.NULL;
        }

        public IElement parse() throws Exception;

        public IElement parse(boolean var1) throws Exception;

        public IElement parseCurrent() throws Exception;

        public IElement parseCurrent(boolean var1) throws Exception;

        public ITypeResolver getTypeResolver();

        public void setTypeResolver(ITypeResolver var1);

        public RuntimeException err(String var1, Throwable var2);

        public RuntimeException err(String var1);

        public void warningAndSkip(String var1) throws RuntimeException;

        public void warning(String var1);

        public Logger getLog();

        public void setLog(Logger var1);

        public int getWarningCount();

        default public BIPasswordValidator getPassPhraseValidator() {
            return BPassword.DEFAULT;
        }
    }

    public static interface ITypeResolver {
        public BModule loadModule(ValueDocDecoder var1, BComplex var2, String var3, String var4, String var5);

        public BValue newInstance(ValueDocDecoder var1, BComplex var2, String var3, Property var4, String var5);

        default public void setSkipLegacyEncodings(boolean skipLegacyEncodings) {
        }

        default public boolean getSkipLegacyEncodings() {
            return false;
        }
    }
}

