/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileOutputStream
extends OutputStream {
    private RandomAccessFile out;
    private long fp;

    public RandomAccessFileOutputStream(RandomAccessFile out) {
        this(out, 0L);
    }

    public RandomAccessFileOutputStream(RandomAccessFile out, long initFp) {
        this.out = out;
        this.fp = initFp;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() throws IOException {
        this.out.getFD().sync();
    }

    public void seek(long fp) {
        this.fp = fp;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.seek(this.fp);
        this.out.write(b);
        ++this.fp;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.seek(this.fp);
        this.out.write(b);
        this.fp += (long)b.length;
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.out.seek(this.fp);
        this.out.write(b, offset, len);
        this.fp += (long)len;
    }
}

