/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipFileDirectory;
import javax.baja.file.zip.BZipFileEntry;
import javax.baja.file.zip.BZipSpace;
import javax.baja.file.zip.ZipPath;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BZipZipSpace
extends BZipSpace {
    ZipEntry parentZipentry;
    public static final Type TYPE = Sys.loadType(BZipZipSpace.class);

    public BZipZipSpace(BZipFile file) {
        super("zip");
        this.parentSpace = file.getSpace();
        this.ordInSession = file.getOrdInSession();
        this.bZipFile = file;
        this.parentZipentry = this.getEntry(file.getStore());
        this.roots();
    }

    @Override
    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        ZipEntry entry;
        ZipInputStream zin = this.getZipStream();
        while ((entry = zin.getNextEntry()) != null) {
            if (!entry.getName().equals(zipEntry.getName())) continue;
            return zin;
        }
        throw new IOException("Zip entry not found:" + zipEntry.getName());
    }

    private ZipEntry getEntry(BIFileStore store) {
        if (store instanceof BZipFileEntry) {
            return ((BZipFileEntry)store).getZipEntry();
        }
        System.out.println("store: " + (store == null ? "null" : store.getClass().getName()));
        throw new IllegalStateException("Only BZipFileEntry supported");
    }

    ZipInputStream getZipStream() {
        try {
            return new ZipInputStream(((BZipSpace)this.parentSpace).getZip().getInputStream(this.parentZipentry));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private synchronized BDirectory roots() {
        if (this.roots != null) {
            return this.roots;
        }
        this.roots = new BDirectory(new BZipFileDirectory(this, (FilePath)new ZipPath("/")));
        ZipInputStream zin = this.getZipStream();
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName().replace('\\', '/');
                if (this.isModule && (name.endsWith(".class") || name.endsWith(".properties") || name.startsWith("META-INF/") || name.startsWith("meta-inf/"))) continue;
                ZipPath path = new ZipPath("/" + name);
                BZipFileEntry store = new BZipFileEntry(this, path, entry);
                BIFile file = this.makeFile(store);
                BDirectory dir = this.mapToDirectory(path);
                BZipFileDirectory dirStore = (BZipFileDirectory)dir.getStore();
                dirStore.add(file);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Loading zip: " + this.parentZipentry.getName(), e);
        }
        return this.roots;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

